/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class URI
implements Serializable {
    private String scheme;
    private InetAddress host;
    private String hostString;
    private int port;
    private String fragment;

    public URI(String uriString) {
        this.parse(uriString);
    }

    public URI(String uriString, boolean hostLookup) {
        this.parse(uriString);
        if (hostLookup) {
            try {
                this.host = InetAddress.getByName(this.hostString);
            }
            catch (UnknownHostException unknownHostException) {
                this.host = null;
            }
        }
    }

    public static URI create(String uriString) {
        try {
            return new URI(uriString);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void parse(String uriString) {
        try {
            int p3;
            int cs = 0;
            int ce = uriString.length();
            int p1 = uriString.indexOf("://");
            if (p1 > -1) {
                this.scheme = uriString.substring(0, p1);
                cs = p1 + 3;
            } else {
                this.scheme = "r-osgi";
            }
            int p2 = uriString.lastIndexOf("#");
            if (p2 > -1) {
                this.fragment = uriString.substring(p2 + 1);
                ce = p2;
            }
            if ((p3 = uriString.indexOf(":", cs)) > -1) {
                this.port = Integer.parseInt(uriString.substring(p3 + 1, ce));
                ce = p3;
            } else if ("r-osgi".equals(this.scheme)) {
                this.port = 9278;
            } else if ("http".equals(this.scheme)) {
                this.port = 80;
            } else if ("https".equals(this.scheme)) {
                this.port = 443;
            }
            this.hostString = uriString.substring(cs, ce);
        }
        catch (IndexOutOfBoundsException i) {
            throw new IllegalArgumentException(String.valueOf(uriString) + " caused " + i.getMessage());
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host == null ? this.hostString : this.host.getHostAddress();
    }

    public int getPort() {
        return this.port;
    }

    public String getFragment() {
        return this.fragment;
    }

    public URI resolve(String add) {
        return URI.create(String.valueOf(this.toString()) + add);
    }

    public int hashCode() {
        return this.scheme.hashCode() + (this.host == null ? this.hostString.hashCode() : this.host.hashCode()) + this.port + (this.fragment != null ? this.fragment.hashCode() : 0);
    }

    public String toString() {
        return String.valueOf(this.scheme) + "://" + this.getHost() + ":" + this.port + (this.fragment == null ? "" : "#" + this.fragment);
    }

    public boolean equals(Object other) {
        if (other instanceof String) {
            return this.equals(new URI((String)other, true));
        }
        if (other instanceof URI) {
            URI otherURI = (URI)other;
            return this.scheme.equals(otherURI.scheme) && (this.host == null ? this.hostString.equals(otherURI.hostString) : this.host.equals(otherURI.host)) && this.port == otherURI.port && (this.fragment == null && otherURI.fragment == null || this.fragment != null && this.fragment.equals(otherURI.fragment));
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.parse(in.readUTF());
    }
}

