/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.browse;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.IURLConnectionModifier;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.browse.AbstractFileSystemBrowser;
import org.eclipse.ecf.provider.filetransfer.browse.URLRemoteFile;
import org.eclipse.ecf.provider.filetransfer.util.JREProxyHelper;

public class URLFileSystemBrowser
extends AbstractFileSystemBrowser {
    private static final String USERNAME_PREFIX = Messages.UrlConnectionRetrieveFileTransfer_USERNAME_PROMPT;
    private static final String JRE_CONNECT_TIMEOUT_PROPERTY = "sun.net.client.defaultConnectTimeout";
    private static final String DEFAULT_CONNECT_TIMEOUT = "30000";
    private static final String JRE_READ_TIMEOUT_PROPERTY = "sun.net.client.defaultReadTimeout";
    private static final String DEFAULT_READ_TIMEOUT = "30000";
    private JREProxyHelper proxyHelper = new JREProxyHelper();
    protected String username = null;
    protected String password = null;

    public URLFileSystemBrowser(IFileID directoryOrFileID, IRemoteFileSystemListener listener, URL directoryOrFileURL, IConnectContext connectContext, Proxy proxy) {
        super(directoryOrFileID, listener, directoryOrFileURL, connectContext, proxy);
    }

    private void setupTimeouts() {
        String existingTimeout = System.getProperty(JRE_CONNECT_TIMEOUT_PROPERTY);
        if (existingTimeout == null) {
            System.setProperty(JRE_CONNECT_TIMEOUT_PROPERTY, "30000");
        }
        if ((existingTimeout = System.getProperty(JRE_READ_TIMEOUT_PROPERTY)) == null) {
            System.setProperty(JRE_READ_TIMEOUT_PROPERTY, "30000");
        }
    }

    protected void runRequest() throws Exception {
        this.setupProxies();
        this.setupAuthentication();
        this.setupTimeouts();
        URLConnection urlConnection = this.directoryOrFile.openConnection();
        if (this.directoryOrFile.getProtocol().equalsIgnoreCase("jar")) {
            urlConnection.setUseCaches(false);
        }
        urlConnection.setRequestProperty("Connection", "close");
        IURLConnectionModifier connectionModifier = Activator.getDefault().getURLConnectionModifier();
        if (connectionModifier != null) {
            connectionModifier.setSocketFactoryForConnection(urlConnection);
        }
        InputStream ins = urlConnection.getInputStream();
        ins.close();
        this.remoteFiles = new IRemoteFile[1];
        this.remoteFiles[0] = new URLRemoteFile(urlConnection.getLastModified(), urlConnection.getContentLength(), this.fileID);
    }

    protected void setupAuthentication() throws IOException, UnsupportedCallbackException {
        if (this.connectContext == null) {
            return;
        }
        CallbackHandler callbackHandler = this.connectContext.getCallbackHandler();
        if (callbackHandler == null) {
            return;
        }
        NameCallback usernameCallback = new NameCallback(USERNAME_PREFIX);
        ObjectCallback passwordCallback = new ObjectCallback();
        callbackHandler.handle(new Callback[]{usernameCallback, passwordCallback});
        this.username = usernameCallback.getName();
        Object o = passwordCallback.getObject();
        if (!(o instanceof String)) {
            throw new UnsupportedCallbackException((Callback)passwordCallback, Messages.UrlConnectionRetrieveFileTransfer_UnsupportedCallbackException);
        }
        this.password = (String)passwordCallback.getObject();
        Authenticator.setDefault(new UrlConnectionAuthenticator());
    }

    protected void setupProxy(Proxy proxy2) {
        this.proxyHelper.setupProxy(proxy2);
    }

    class UrlConnectionAuthenticator
    extends Authenticator {
        UrlConnectionAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(URLFileSystemBrowser.this.username, URLFileSystemBrowser.this.password.toCharArray());
        }
    }
}

