/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.impl.SLPMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

class SLPConfiguration {
    private static final String USE_SCOPES_PROP = "net.slp.useScopes";
    private static final String USE_SCOPES_DEFAULT = "DEFAULT";
    private static final String DA_ADDRESSES_PROP = "net.slp.DAAddresses";
    private static final String DA_ADDRESSES_DEFAULT = null;
    private static final String WAIT_TIME_PROP = "net.slp.waitTime";
    private static final String WAIT_TIME_DEFAULT = "1000";
    private static final String TRACE_DATRAFFIC_PROP = "net.slp.traceDATraffic";
    private static final String TRACE_DATRAFFIC_DEFAULT = "false";
    private static final String TRACE_MESSAGE_PROP = "net.slp.traceMsg";
    private static final String TRACE_MESSAGE_DEFAULT = "false";
    private static final String TRACE_DROP_PROP = "net.slp.traceDrop";
    private static final String TRACE_DROP_DEFAULT = "false";
    private static final String TRACE_REG_PROP = "net.slp.traceReg";
    private static final String TRACE_REG_DEFAULT = "false";
    private static final String MCAST_TTL_PROP = "net.slp.multicastTTL";
    private static final String MCAST_TTL_DEFAULT = "255";
    private static final String MCAST_MAX_WAIT_PROP = "net.slp.multicastMaximumWait";
    private static final String MCAST_MAX_WAIT_DEFAULT = "15000";
    private static final String MCAST_TIMEOUTS_PROP = "net.slp.multicastTimeouts";
    private static final String MCAST_TIMEOUTS_DEFAULT = "3000,2000,1500,1000,750,500";
    private static final String DATAGRAM_MAX_WAIT_PROP = "net.slp.datagramMaximumWait";
    private static final String DATAGRAM_MAX_WAIT_DEFAULT = "5000";
    private static final String DATAGRAM_TIMEOUTS_PROP = "net.slp.datagramTimeouts";
    private static final String DATAGRAM_TIMEOUTS_DEFAULT = "3000,3000,3000,3000,3000";
    private static final String MTU_PROP = "net.slp.MTU";
    private static final String MTU_DEFAULT = "1400";
    private static final String SECURITY_ENABLED_PROP = "net.slp.securityEnabled";
    private static final String SECURITY_ENABLED_DEFAULT = "false";
    private static final String SPI_PROP = "net.slp.spi";
    private static final String SPI_DEFAULT = "";
    private static final String PRIVATE_KEY_PROP = "net.slp.privateKey.";
    private static final String PUBLIC_KEY_PROP = "net.slp.publicKey.";
    private static final String INTERFACES_PROP = "net.slp.interfaces";
    private static final String INTERFACES_DEFAULT = null;
    private static final String NO_DA_DISCOVERY_PROP = "net.slp.noDADiscovery";
    private static final String PORT_PROP = "net.slp.port";
    private static final String DEFAULT_PORT = "427";
    private static final String DEFAULT_CONVERGENCE_FAILERCOUNT = "2";
    private static final String CONVERGENCE_FAILERCOUNT_PROP = "net.slp.failercount";
    private static final String DEBUG_ENABLED_PROP = "ch.ethz.iks.slp.debug";
    private static String[] INTERFACES;
    private static int PORT;
    private static String SCOPES;
    private static boolean NO_DA_DISCOVERY;
    private static String[] DA_ADDRESSES;
    private static boolean TRACE_DA_TRAFFIC;
    private static boolean TRACE_MESSAGES;
    private static boolean TRACE_DROP;
    private static boolean TRACE_REG;
    private static int MCAST_TTL;
    private static int MCAST_MAX_WAIT;
    private static int[] MCAST_TIMEOUTS;
    private static int DATAGRAM_MAX_WAIT;
    private static int[] DATAGRAM_TIMEOUTS;
    private static int MTU;
    private static boolean SECURITY_ENABLED;
    private static String SPI;
    private static int WAIT_TIME;
    private static Map PUBLIC_KEY_CACHE;
    private static Map PRIVATE_KEY_CACHE;
    private static int CONVERGENCE_FAILERCOUNT;
    private static boolean DEBUG_ENABLED;

    SLPConfiguration() {
        SLPConfiguration.processProperties(System.getProperties());
    }

    SLPConfiguration(File file) throws IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(file));
        props.putAll((Map<?, ?>)System.getProperties());
        SLPConfiguration.processProperties(props);
    }

    private static void processProperties(Properties props) {
        String ifaces = props.getProperty(INTERFACES_PROP, INTERFACES_DEFAULT);
        INTERFACES = ifaces == null ? null : SLPMessage.stringToList(ifaces, ",").toArray(new String[0]);
        PORT = Integer.parseInt(props.getProperty(PORT_PROP, DEFAULT_PORT));
        SCOPES = props.getProperty(USE_SCOPES_PROP, USE_SCOPES_DEFAULT);
        NO_DA_DISCOVERY = new Boolean(props.getProperty(NO_DA_DISCOVERY_PROP, "false"));
        String dAs = props.getProperty(DA_ADDRESSES_PROP, DA_ADDRESSES_DEFAULT);
        DA_ADDRESSES = dAs == null ? null : SLPMessage.stringToList(dAs, ",").toArray(new String[0]);
        TRACE_DA_TRAFFIC = new Boolean(props.getProperty(TRACE_DATRAFFIC_PROP, "false"));
        TRACE_MESSAGES = new Boolean(props.getProperty(TRACE_MESSAGE_PROP, "false"));
        TRACE_DROP = new Boolean(props.getProperty(TRACE_DROP_PROP, "false"));
        TRACE_REG = new Boolean(props.getProperty(TRACE_REG_PROP, "false"));
        MCAST_TTL = Integer.parseInt(props.getProperty(MCAST_TTL_PROP, MCAST_TTL_DEFAULT));
        MCAST_MAX_WAIT = Integer.parseInt(props.getProperty(MCAST_MAX_WAIT_PROP, MCAST_MAX_WAIT_DEFAULT));
        DATAGRAM_MAX_WAIT = Integer.parseInt(props.getProperty(DATAGRAM_MAX_WAIT_PROP, DATAGRAM_MAX_WAIT_DEFAULT));
        MCAST_TIMEOUTS = SLPConfiguration.parseTimeouts(props.getProperty(MCAST_TIMEOUTS_PROP, MCAST_TIMEOUTS_DEFAULT));
        DATAGRAM_TIMEOUTS = SLPConfiguration.parseTimeouts(props.getProperty(DATAGRAM_TIMEOUTS_PROP, DATAGRAM_TIMEOUTS_DEFAULT));
        MTU = Integer.parseInt(props.getProperty(MTU_PROP, MTU_DEFAULT));
        SECURITY_ENABLED = new Boolean(props.getProperty(SECURITY_ENABLED_PROP, "false"));
        SPI = props.getProperty(SPI_PROP, SPI_DEFAULT);
        WAIT_TIME = Integer.parseInt(props.getProperty(WAIT_TIME_PROP, WAIT_TIME_DEFAULT));
        CONVERGENCE_FAILERCOUNT = Integer.parseInt(props.getProperty(CONVERGENCE_FAILERCOUNT_PROP, DEFAULT_CONVERGENCE_FAILERCOUNT));
        DEBUG_ENABLED = new Boolean(props.getProperty(DEBUG_ENABLED_PROP, "false"));
        if (SECURITY_ENABLED) {
            PUBLIC_KEY_CACHE = new HashMap(0);
            PRIVATE_KEY_CACHE = new HashMap(0);
        }
    }

    String[] getInterfaces() {
        return INTERFACES;
    }

    int getPort() {
        return PORT;
    }

    String getScopes() {
        return SCOPES;
    }

    String[] getDaAddresses() {
        return DA_ADDRESSES;
    }

    boolean getNoDaDiscovery() {
        return NO_DA_DISCOVERY;
    }

    boolean getTraceDaTraffic() {
        return TRACE_DA_TRAFFIC;
    }

    boolean getTraceMessage() {
        return TRACE_MESSAGES;
    }

    boolean getTraceDrop() {
        return TRACE_DROP;
    }

    boolean getTraceReg() {
        return TRACE_REG;
    }

    int getMcastTTL() {
        return MCAST_TTL;
    }

    int getMcastMaxWait() {
        return MCAST_MAX_WAIT;
    }

    int getDatagramMaxWait() {
        return DATAGRAM_MAX_WAIT;
    }

    private static int[] parseTimeouts(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        int[] timeouts = new int[st.countTokens()];
        int i = 0;
        while (i < timeouts.length) {
            timeouts[i] = Integer.parseInt(st.nextToken());
            ++i;
        }
        return timeouts;
    }

    int[] getMcastTimeouts() {
        return MCAST_TIMEOUTS;
    }

    int[] getDatagramTimeouts() {
        return DATAGRAM_TIMEOUTS;
    }

    int getMTU() {
        return MTU;
    }

    boolean getSecurityEnabled() {
        return SECURITY_ENABLED;
    }

    String getSPI() {
        return SPI;
    }

    PublicKey getPublicKey(String spi) throws IOException, GeneralSecurityException {
        PublicKey key = (PublicKey)PUBLIC_KEY_CACHE.get(spi);
        if (key != null) {
            return key;
        }
        FileInputStream keyfis = new FileInputStream(System.getProperty(PUBLIC_KEY_PROP + spi));
        byte[] encKey = new byte[keyfis.available()];
        keyfis.read(encKey);
        keyfis.close();
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encKey);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        key = keyFactory.generatePublic(pubKeySpec);
        PUBLIC_KEY_CACHE.put(spi, key);
        return key;
    }

    PrivateKey getPrivateKey(String spi) throws IOException, GeneralSecurityException {
        PrivateKey key = (PrivateKey)PRIVATE_KEY_CACHE.get(spi);
        if (key != null) {
            return key;
        }
        FileInputStream keyfis = new FileInputStream(System.getProperty(PRIVATE_KEY_PROP + spi));
        byte[] encKey = new byte[keyfis.available()];
        keyfis.read(encKey);
        keyfis.close();
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(encKey);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        key = keyFactory.generatePrivate(privKeySpec);
        PRIVATE_KEY_CACHE.put(spi, key);
        return key;
    }

    int getWaitTime() {
        return WAIT_TIME;
    }

    int getConvergenceFailerCount() {
        return CONVERGENCE_FAILERCOUNT;
    }

    public boolean getDebugEnabled() {
        return DEBUG_ENABLED;
    }

    public int getTCPTimeout() {
        return 5000;
    }
}

