/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventHook;

public abstract class AbstractEventHookImpl
implements EventHook {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final DistributionProviderImpl distributionProvider;
    private final Map srvRefToRemoteSrvRegistration = new HashMap();
    private final Map srvRefToServicePublicationRegistration = new HashMap();

    public AbstractEventHookImpl(DistributionProviderImpl distributionProvider) {
        this.distributionProvider = distributionProvider;
    }

    public void event(ServiceEvent event, Collection contexts) {
        switch (event.getType()) {
            case 2: {
                this.handleModifiedServiceEvent(event.getServiceReference(), contexts);
                break;
            }
            case 8: {
                break;
            }
            case 1: {
                this.handleRegisteredServiceEvent(event.getServiceReference(), contexts);
                break;
            }
            case 4: {
                this.handleUnregisteringServiceEvent(event.getServiceReference(), contexts);
                break;
            }
        }
    }

    void handleRegisteredServiceEvent(ServiceReference serviceReference, Collection contexts) {
        Object osgiRemotes = serviceReference.getProperty("osgi.remote.interfaces");
        if (osgiRemotes != null) {
            String[] remoteInterfaces;
            String[] remoteInterfacesArr = (String[])(osgiRemotes instanceof String[] ? osgiRemotes : null);
            if (remoteInterfacesArr == null) {
                this.logError("handleRegisteredServiceEvent", "remoteInterfaces not of String [] type as required by RFC 119");
                return;
            }
            this.trace("handleRegisteredServiceEvent", "serviceReference=" + serviceReference + ",remoteInterfaces=" + Arrays.asList(remoteInterfacesArr));
            String[] stringArray = remoteInterfaces = remoteInterfacesArr != null ? this.getInterfacesForServiceReference(remoteInterfacesArr, serviceReference) : null;
            if (remoteInterfaces == null) {
                this.logError("handleRegisteredServiceEvent", "No exposed remoteInterfaces found for serviceReference=" + serviceReference);
                return;
            }
            Object osgiRemoteConfigurationType = serviceReference.getProperty("osgi.remote.configuration.type");
            String[] remoteConfigurationType = null;
            if (osgiRemoteConfigurationType != null) {
                if (!(osgiRemoteConfigurationType instanceof String[])) {
                    this.logError("handleRegisteredServiceEvent", "osgi.remote.configuration.type is not String[] as required by RFC 119");
                    return;
                }
                remoteConfigurationType = (String[])osgiRemoteConfigurationType;
            }
            this.registerRemoteService(serviceReference, remoteInterfaces, remoteConfigurationType);
        }
    }

    protected abstract void registerRemoteService(ServiceReference var1, String[] var2, String[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRemoteServiceRegistered(ServiceReference serviceReference, IRemoteServiceRegistration remoteServiceRegistration) {
        Map map = this.srvRefToRemoteSrvRegistration;
        synchronized (map) {
            ArrayList<IRemoteServiceRegistration> l = (ArrayList<IRemoteServiceRegistration>)this.srvRefToRemoteSrvRegistration.get(serviceReference);
            if (l == null) {
                l = new ArrayList<IRemoteServiceRegistration>();
                this.srvRefToRemoteSrvRegistration.put(serviceReference, l);
            }
            l.add(remoteServiceRegistration);
            this.distributionProvider.addExposedService(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRemoteServiceUnregistered(ServiceReference reference) {
        IRemoteServiceRegistration[] registrations = null;
        Map map = this.srvRefToRemoteSrvRegistration;
        synchronized (map) {
            this.distributionProvider.removeExposedService(reference);
            List l = (List)this.srvRefToRemoteSrvRegistration.remove(reference);
            if (l != null) {
                registrations = l.toArray(new IRemoteServiceRegistration[0]);
                l.clear();
            }
        }
        if (registrations != null) {
            int i = 0;
            while (i < registrations.length) {
                try {
                    registrations[i].unregister();
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (Exception e) {
                    this.logError("fireRemoteServiceUnregistered", "Exception unregistering remote registration=" + registrations[i], e);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRemoteServicePublished(ServiceReference serviceReference, ServiceRegistration servicePublicationRegistration) {
        Map map = this.srvRefToServicePublicationRegistration;
        synchronized (map) {
            ArrayList<ServiceRegistration> l = (ArrayList<ServiceRegistration>)this.srvRefToServicePublicationRegistration.get(serviceReference);
            if (l == null) {
                l = new ArrayList<ServiceRegistration>();
                this.srvRefToServicePublicationRegistration.put(serviceReference, l);
            }
            l.add(servicePublicationRegistration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRemoteServiceUnpublished(ServiceReference reference) {
        ServiceRegistration[] registrations = null;
        Map map = this.srvRefToServicePublicationRegistration;
        synchronized (map) {
            List l = (List)this.srvRefToServicePublicationRegistration.remove(reference);
            if (l != null) {
                registrations = l.toArray(new ServiceRegistration[0]);
                l.clear();
            }
        }
        if (registrations != null) {
            int i = 0;
            while (i < registrations.length) {
                try {
                    registrations[i].unregister();
                }
                catch (Exception e) {
                    this.logError("fireRemoteServiceUnpublished", "Exception unregistering service publication registrations=" + registrations[i], e);
                }
                ++i;
            }
        }
    }

    private String[] getInterfacesForServiceReference(String[] remoteInterfaces, ServiceReference serviceReference) {
        if (remoteInterfaces == null || remoteInterfaces.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> results = new ArrayList<String>();
        List<String> interfaces = Arrays.asList((String[])serviceReference.getProperty("objectClass"));
        int i = 0;
        while (i < remoteInterfaces.length) {
            String intf = remoteInterfaces[i];
            if ("*".equals(intf)) {
                return interfaces.toArray(new String[0]);
            }
            if (intf != null && interfaces.contains(intf)) {
                results.add(intf);
            }
            ++i;
        }
        return results.toArray(new String[0]);
    }

    protected void trace(String methodName, String message) {
        Trace.trace((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug/eventhook", this.getClass(), (String)methodName, (String)message);
    }

    protected void traceException(String methodName, String message, Throwable t) {
        Trace.catching((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug/exceptions/catching", this.getClass(), (String)(String.valueOf(methodName == null ? "<unknown>" : methodName) + ":" + (message == null ? "<empty>" : message)), (Throwable)t);
    }

    protected void logError(String methodName, String message, Throwable t) {
        this.traceException(methodName, message, t);
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.osgi.services.distribution", 4, String.valueOf(this.getClass().getName()) + ":" + (methodName == null ? "<unknown>" : methodName) + ":" + (message == null ? "<empty>" : message), t));
    }

    protected void logError(String methodName, String message) {
        this.logError(methodName, message, null);
        this.traceException(methodName, message, null);
    }

    protected void handleUnregisteringServiceEvent(ServiceReference serviceReference, Collection contexts) {
        this.fireRemoteServiceUnregistered(serviceReference);
        this.fireRemoteServiceUnpublished(serviceReference);
    }

    protected void handleModifiedServiceEvent(ServiceReference serviceReference, Collection contexts) {
    }

    protected Object getService(ServiceReference sr) {
        return Activator.getDefault().getContext().getService(sr);
    }
}

