/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.internal.osgi.services.distribution.DiscoveredServiceTrackerImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.EventHookImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.osgi.services.distribution";
    private static Activator plugin;
    private BundleContext context;
    private ServiceTracker containerManagerTracker;
    private DistributionProviderImpl distributionProvider;
    private ServiceRegistration eventHookRegistration;
    private ServiceRegistration distributionProviderRegistration;
    private ServiceRegistration discoveredServiceTrackerRegistration;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public static Activator getDefault() {
        return plugin;
    }

    public BundleContext getContext() {
        return this.context;
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService(PLUGIN_ID);
        }
        return this.logService;
    }

    public void log(IStatus status) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(null, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public void log(ServiceReference sr, IStatus status) {
        this.log(sr, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
    }

    public void log(ServiceReference sr, int level, String message, Throwable t) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(sr, level, message, t);
        }
    }

    public void start(BundleContext ctxt) throws Exception {
        plugin = this;
        this.context = ctxt;
        this.distributionProvider = new DistributionProviderImpl();
        this.addDiscoveredServiceTracker();
        this.addServiceRegistryHooks();
        this.addDistributionProvider();
    }

    private void addDiscoveredServiceTracker() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.discovery.DiscoveredServiceTracker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.discoveredServiceTrackerRegistration = this.context.registerService(clazz.getName(), (Object)new DiscoveredServiceTrackerImpl(this.distributionProvider), null);
    }

    private void addServiceRegistryHooks() {
        EventHookImpl hook = new EventHookImpl(this.distributionProvider);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.osgi.framework.hooks.service.EventHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventHookRegistration = this.context.registerService(clazz.getName(), (Object)hook, null);
        try {
            ServiceReference[] refs = this.context.getServiceReferences(null, "(osgi.remote.interfaces=*)");
            if (refs != null) {
                int i = 0;
                while (i < refs.length) {
                    hook.handleRegisteredServiceEvent(refs[i], null);
                    ++i;
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    private void addDistributionProvider() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.remote.distribution.vendor", DistributionProviderImpl.VENDOR_NAME);
        ((Dictionary)properties).put("osgi.remote.distribution.product", DistributionProviderImpl.PRODUCT_NAME);
        ((Dictionary)properties).put("osgi.remote.distribution.product.version", DistributionProviderImpl.PRODUCT_VERSION);
        ((Dictionary)properties).put("osgi.remote.distribition.supported_intents", this.distributionProvider.getSupportedIntents());
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.osgi.service.distribution.DistributionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.distributionProviderRegistration = this.context.registerService(clazz.getName(), (Object)this.distributionProvider, properties);
    }

    private void removeServiceRegistryHooks() {
        if (this.eventHookRegistration != null) {
            this.eventHookRegistration.unregister();
            this.eventHookRegistration = null;
        }
    }

    private void removeDistributionProvider() {
        if (this.distributionProviderRegistration != null) {
            this.distributionProviderRegistration.unregister();
            this.distributionProviderRegistration = null;
        }
    }

    private void removeDiscoveredServiceTracker() {
        if (this.discoveredServiceTrackerRegistration != null) {
            this.discoveredServiceTrackerRegistration.unregister();
            this.discoveredServiceTrackerRegistration = null;
        }
    }

    public void stop(BundleContext ctxt) throws Exception {
        this.removeDiscoveredServiceTracker();
        this.removeDistributionProvider();
        this.removeServiceRegistryHooks();
        if (this.containerManagerTracker != null) {
            this.containerManagerTracker.close();
            this.containerManagerTracker = null;
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        if (this.distributionProvider != null) {
            this.distributionProvider.dispose();
            this.distributionProvider = null;
        }
        this.context = null;
        plugin = null;
    }

    public IContainerManager getContainerManager() {
        if (this.containerManagerTracker == null) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.ecf.core.IContainerManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.containerManagerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.containerManagerTracker.open();
        }
        return (IContainerManager)this.containerManagerTracker.getService();
    }
}

