/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.osgi.framework.ServiceRegistration;

public class RemoteServiceRegistrations {
    private final IServiceID serviceID;
    private final IContainer container;
    private final IRemoteServiceContainerAdapter containerAdapter;
    private IRemoteServiceListener listener;
    private Map serviceRegistrations = new HashMap();

    public RemoteServiceRegistrations(IServiceID serviceID, IContainer c, IRemoteServiceContainerAdapter adapter, IRemoteServiceListener l) {
        this.serviceID = serviceID;
        this.container = c;
        this.containerAdapter = adapter;
        this.listener = l;
        this.containerAdapter.addRemoteServiceListener(this.listener);
    }

    public IServiceID getServiceID() {
        return this.serviceID;
    }

    public IContainer getContainer() {
        return this.container;
    }

    public IRemoteServiceContainerAdapter getContainerAdapter() {
        return this.containerAdapter;
    }

    public void dispose() {
        this.containerAdapter.removeRemoteServiceListener(this.listener);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("RemoteServiceRegistrations[");
        buf.append("containerID=").append(this.getContainer().getID());
        buf.append(";rsca=").append(this.getContainerAdapter()).append("]");
        return buf.toString();
    }

    public void addServiceRegistration(IRemoteServiceReference ref, ServiceRegistration registration) {
        ArrayList<ServiceRegistration> l = (ArrayList<ServiceRegistration>)this.serviceRegistrations.get(ref.getID());
        if (l == null) {
            l = new ArrayList<ServiceRegistration>();
            this.serviceRegistrations.put(ref.getID(), l);
        }
        l.add(registration);
    }

    public ServiceRegistration[] removeServiceRegistration(IRemoteServiceReference reference) {
        List l;
        if (this.getContainerAdapter().ungetRemoteService(reference) && (l = (List)this.serviceRegistrations.remove(reference.getID())) != null) {
            return l.toArray(new ServiceRegistration[0]);
        }
        return null;
    }

    public List removeAllServiceRegistrations() {
        ArrayList results = new ArrayList();
        Iterator i = this.serviceRegistrations.keySet().iterator();
        while (i.hasNext()) {
            List l = (List)this.serviceRegistrations.get(i.next());
            if (l == null) continue;
            results.addAll(l);
        }
        return results;
    }

    public boolean isEmpty() {
        return this.serviceRegistrations.size() == 0;
    }
}

