/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.Collection;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.osgi.services.discovery.ServiceEndpointDescriptionImpl;

class ServiceEndpointDescriptionHelper {
    private static final long DEFAULT_FUTURE_TIMEOUT = new Long(System.getProperty("ecf.rs.lookup.timeout", new Long(30000L).toString()));
    private final ServiceEndpointDescriptionImpl description;
    private final ID localDiscoveryContainerID;
    private final IServiceID serviceID;
    private final String serviceName;
    private ID endpointID;

    public ServiceEndpointDescriptionHelper(ServiceEndpointDescriptionImpl d) throws NullPointerException {
        this.description = d;
        this.localDiscoveryContainerID = this.description.getLocalDiscoveryContainerID();
        if (this.localDiscoveryContainerID == null) {
            throw new NullPointerException("ServiceEndpointDescription localDiscoveryContainerID cannot be null");
        }
        this.serviceID = this.description.getServiceID();
        if (this.serviceID == null) {
            throw new NullPointerException("ServiceEndpointDescription serviceID cannot be null");
        }
        this.serviceName = this.serviceID.getServiceName();
        if (this.serviceName == null) {
            throw new NullPointerException("ServiceEndpointDescription serviceName is null");
        }
    }

    public ServiceEndpointDescriptionImpl getDescription() {
        return this.description;
    }

    public ID getLocalDiscoveryContainerID() {
        return this.localDiscoveryContainerID;
    }

    public IServiceID getServiceID() {
        return this.serviceID;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Collection getProvidedInterfaces() {
        Collection c = this.description.getProvidedInterfaces();
        if (c == null) {
            throw new NullPointerException("ServiceEndpointDescription providedInterfaces cannot be null");
        }
        return c;
    }

    public Long getRemoteServiceID() throws NullPointerException {
        String longStr = (String)this.description.getProperty("ecf.rsvc.id");
        if (longStr == null) {
            throw new NullPointerException("ServiceEndpointDescriptoin remote service ID cannot be null");
        }
        return new Long(longStr);
    }

    public synchronized ID getEndpointID() throws IDCreateException {
        if (this.endpointID == null) {
            byte[] endpointBytes = this.description.getPropertyBytes("ecf.sp.cid");
            if (endpointBytes == null) {
                throw new IDCreateException("ServiceEndpointDescription endpointBytes cannot be null");
            }
            String endpointStr = new String(endpointBytes);
            String namespaceStr = this.description.getPropertyString("ecf.sp.cns");
            if (namespaceStr == null) {
                throw new IDCreateException("ServiceEndpointDescription namespaceStr cannot be null");
            }
            this.endpointID = IDFactory.getDefault().createID(namespaceStr, endpointStr);
        }
        return this.endpointID;
    }

    public long getFutureTimeout() {
        return DEFAULT_FUTURE_TIMEOUT;
    }
}

