/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic;

import java.io.IOException;
import java.io.Serializable;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.IConnectHandlerPolicy;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.TCPServerSOContainerGroup;
import org.eclipse.ecf.server.generic.GenericServerContainer;

public abstract class AbstractGenericServer {
    protected TCPServerSOContainerGroup serverGroup;

    protected void handleDisconnect(ID targetID) {
    }

    protected void handleEject(ID targetID) {
    }

    public List getServerContainers() {
        ArrayList result = new ArrayList();
        Iterator i = this.serverGroup.elements();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public GenericServerContainer getFirstServerContainer() {
        return (GenericServerContainer)((Object)this.getServerContainers().get(0));
    }

    public AbstractGenericServer(String host, int port) {
        this.serverGroup = new TCPServerSOContainerGroup(host, port);
    }

    protected void putOnTheAir() throws IOException {
        if (!this.serverGroup.isOnTheAir()) {
            this.serverGroup.putOnTheAir();
        }
    }

    protected void takeOffTheAir() {
        if (this.serverGroup.isOnTheAir()) {
            this.serverGroup.takeOffTheAir();
        }
    }

    public synchronized void start(String path, int keepAlive) throws Exception {
        this.createAndInitializeServer(path, keepAlive);
        this.putOnTheAir();
    }

    public synchronized void stop() {
        if (this.serverGroup != null) {
            this.serverGroup.takeOffTheAir();
        }
        List servers = this.getServerContainers();
        Iterator i = servers.iterator();
        while (i.hasNext()) {
            GenericServerContainer s = (GenericServerContainer)((Object)i.next());
            s.ejectAllGroupMembers((Serializable)((Object)"Shutting down immediately"));
            s.dispose();
        }
    }

    protected void createAndInitializeServer(String path) throws IDCreateException {
        this.createAndInitializeServer(path, 30000);
    }

    protected void createAndInitializeServer(String path, int keepAlive) throws IDCreateException {
        if (path == null || path.equals("")) {
            throw new NullPointerException("Cannot create ID with null or empty path");
        }
        GenericServerContainer s = new GenericServerContainer(this, (ISharedObjectContainerConfig)this.createServerConfig(path), this.serverGroup, path, keepAlive);
        IConnectHandlerPolicy policy = this.createConnectHandlerPolicy(s, path);
        if (policy != null) {
            s.setConnectPolicy(policy);
        }
    }

    protected PermissionCollection checkConnect(Object address, ID fromID, ID targetID, String targetGroup, Object connectData) throws Exception {
        return null;
    }

    protected IConnectHandlerPolicy createConnectHandlerPolicy(GenericServerContainer s, String path) {
        return new IConnectHandlerPolicy(){

            public PermissionCollection checkConnect(Object address, ID fromID, ID targetID, String targetGroup, Object connectData) throws Exception {
                return AbstractGenericServer.this.checkConnect(address, fromID, targetID, targetGroup, connectData);
            }

            public void refresh() {
            }
        };
    }

    protected ID createServerIDFromPath(String path) throws IDCreateException {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String id = "ecftcp://" + this.getHost() + ":" + this.getPort() + path;
        return IDFactory.getDefault().createStringID(id);
    }

    protected SOContainerConfig createServerConfig(String path) throws IDCreateException {
        return new SOContainerConfig(this.createServerIDFromPath(path));
    }

    protected String getHost() {
        return this.serverGroup.getName();
    }

    protected int getPort() {
        return this.serverGroup.getPort();
    }
}

