/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ecf.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;

class OverrideWithRemoteOperation
extends SynchronizeModelOperation {
    protected OverrideWithRemoteOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    private ISchedulingRule createSchedulingRule(Collection rules) {
        if (rules.size() == 1) {
            return (ISchedulingRule)rules.iterator().next();
        }
        return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        SyncInfoSet syncInfoSet = this.getSyncInfoSet();
        SyncInfo[] syncInfos = syncInfoSet.getSyncInfos();
        HashSet<IProject> projects = new HashSet<IProject>();
        int i = 0;
        while (i < syncInfos.length) {
            projects.add(syncInfos[i].getLocal().getProject());
            ++i;
        }
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)new OverrideWithRemoteRunnable(syncInfos), this.createSchedulingRule(projects), 1, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    class OverrideWithRemoteRunnable
    implements IWorkspaceRunnable {
        private SyncInfo[] syncInfos;

        public OverrideWithRemoteRunnable(SyncInfo[] syncInfos) {
            this.syncInfos = syncInfos;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            monitor.beginTask("", this.syncInfos.length);
            monitor.subTask("Overriding resources with remote copy...");
            int i = 0;
            while (i < this.syncInfos.length) {
                if (monitor.isCanceled()) {
                    return;
                }
                IResourceVariant remoteVariant = this.syncInfos[i].getRemote();
                IResource resource = this.syncInfos[i].getLocal();
                block0 : switch (this.syncInfos[i].getKind() & 3) {
                    case 1: {
                        IStorage storage;
                        monitor.subTask("Creating " + resource.getName() + "...");
                        switch (resource.getType()) {
                            case 1: {
                                storage = remoteVariant.getStorage(null);
                                this.createParents(resource);
                                ((IFile)resource).create(storage.getContents(), true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                break block0;
                            }
                            case 2: {
                                if (resource.exists()) break block0;
                                ((IFolder)resource).create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                break block0;
                            }
                        }
                        monitor.worked(1);
                        break;
                    }
                    case 3: {
                        IStorage storage;
                        switch (resource.getType()) {
                            case 1: {
                                monitor.subTask("Replacing " + resource.getName() + " with remote content...");
                                storage = remoteVariant.getStorage(null);
                                ((IFile)resource).setContents(storage.getContents(), true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                break block0;
                            }
                        }
                        monitor.worked(1);
                        break;
                    }
                    case 2: {
                        if (resource.exists()) {
                            monitor.subTask("Deleting " + resource.getName() + "...");
                        }
                        resource.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
                ++i;
            }
        }

        private void createParents(IResource resource) throws CoreException {
            IContainer container = resource.getParent();
            while (!container.exists() && container.getType() == 2) {
                IFolder folder = (IFolder)container;
                folder.create(true, true, null);
                container = folder.getParent();
            }
        }
    }
}

