/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ecf.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterGroup;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.IRosterManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class RemotePeerSynchronizeWizardPage
extends WizardPage {
    private CheckboxTreeViewer resourcesViewer;
    private TreeViewer peersViewer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    RemotePeerSynchronizeWizardPage() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.internal.ecf.ui.wizards.RemotePeerSynchronizeWizardPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz.getName());
        this.setTitle("Synchronize with Remote Peer");
        this.setDescription("Select the resources to be synchronized.");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout(256));
        this.createResourcesViewer(composite);
        this.createPeersViewer(composite);
        this.attachListeners();
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    private void createResourcesViewer(Composite composite) {
        this.resourcesViewer = new ContainerCheckedTreeViewer(composite);
        this.resourcesViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof org.eclipse.core.resources.IContainer) {
                    try {
                        IResource[] members = ((org.eclipse.core.resources.IContainer)element).members();
                        ArrayList<IResource> nonDerivedMembers = new ArrayList<IResource>();
                        int i = 0;
                        while (i < members.length) {
                            if (!members[i].isDerived()) {
                                nonDerivedMembers.add(members[i]);
                            }
                            ++i;
                        }
                        return nonDerivedMembers.toArray();
                    }
                    catch (CoreException coreException) {
                        return new IResource[0];
                    }
                }
                return new IResource[0];
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean hasChildren(Object element) {
                if (!(element instanceof org.eclipse.core.resources.IContainer)) {
                    return false;
                }
                try {
                    IResource[] members = ((org.eclipse.core.resources.IContainer)element).members();
                    int i = 0;
                    while (true) {
                        if (i >= members.length) {
                            return false;
                        }
                        if (!members[i].isDerived()) {
                            return true;
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
        });
        this.resourcesViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.resourcesViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
    }

    private void createPeersViewer(Composite composite) {
        this.peersViewer = new TreeViewer(composite, 2820);
        this.peersViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IRosterGroup) {
                    return ((IRosterGroup)parentElement).getEntries().toArray();
                }
                if (parentElement instanceof IRoster) {
                    return ((IRoster)parentElement).getItems().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return ((IRosterItem)element).getParent();
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IRosterGroup) {
                    return !((IRosterGroup)element).getEntries().isEmpty();
                }
                if (element instanceof IRoster) {
                    return !((IRoster)element).getItems().isEmpty();
                }
                return false;
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.peersViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                IRosterItem item = (IRosterItem)entry.getValue();
                return item.getName();
            }
        });
        IContainerManager manager = (IContainerManager)ContainerFactory.getDefault();
        IContainer[] containers = manager.getAllContainers();
        HashMap<IContainer, IRoster> presenceContainers = new HashMap<IContainer, IRoster>();
        int i = 0;
        while (i < containers.length) {
            IRosterManager rosterManager;
            IPresenceContainerAdapter adapter;
            IContainer iContainer = containers[i];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ecf.presence.IPresenceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IPresenceContainerAdapter)iContainer.getAdapter((Class)clazz)) != null && (rosterManager = adapter.getRosterManager()) != null) {
                presenceContainers.put(containers[i], rosterManager.getRoster());
            }
            ++i;
        }
        this.peersViewer.setInput((Object)presenceContainers.entrySet().toArray());
    }

    private void attachListeners() {
        this.resourcesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RemotePeerSynchronizeWizardPage.this.verify();
            }
        });
        this.peersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RemotePeerSynchronizeWizardPage.this.verify();
            }
        });
    }

    void verify() {
        if (this.resourcesViewer.getCheckedElements().length == 0) {
            this.setPageComplete(false);
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.peersViewer.getSelection();
        if (!(selection.getFirstElement() instanceof IRosterEntry)) {
            this.setErrorMessage("A remote peer must be selected to synchronize with.");
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private Map.Entry getSelectedEntry() {
        IStructuredSelection selection = (IStructuredSelection)this.peersViewer.getSelection();
        return (Map.Entry)selection.getFirstElement();
    }

    ID getContainerId() {
        Map.Entry entry = this.getSelectedEntry();
        IContainer container = (IContainer)entry.getKey();
        return container.getID();
    }

    IRosterEntry getRosterEntry() {
        IStructuredSelection selection = (IStructuredSelection)this.peersViewer.getSelection();
        return (IRosterEntry)selection.getFirstElement();
    }

    IResource[] getSelectedResources() {
        IStructuredSelection selection = (IStructuredSelection)this.resourcesViewer.getSelection();
        return selection.toList().toArray(new IResource[selection.size()]);
    }
}

