/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.MessageEventNotificationListener;
import org.jivesoftware.smackx.MessageEventRequestListener;
import org.jivesoftware.smackx.packet.MessageEvent;

public class MessageEventManager {
    private List messageEventNotificationListeners = new ArrayList();
    private List messageEventRequestListeners = new ArrayList();
    private XMPPConnection con;
    private PacketFilter packetFilter = new PacketExtensionFilter("x", "jabber:x:event");
    private PacketListener packetListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public MessageEventManager(XMPPConnection con) {
        this.con = con;
        this.init();
    }

    public static void addNotificationsRequests(Message message, boolean offline, boolean delivered, boolean displayed, boolean composing) {
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setOffline(offline);
        messageEvent.setDelivered(delivered);
        messageEvent.setDisplayed(displayed);
        messageEvent.setComposing(composing);
        message.addExtension(messageEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageEventRequestListener(MessageEventRequestListener messageEventRequestListener) {
        List list = this.messageEventRequestListeners;
        synchronized (list) {
            if (!this.messageEventRequestListeners.contains(messageEventRequestListener)) {
                this.messageEventRequestListeners.add(messageEventRequestListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageEventRequestListener(MessageEventRequestListener messageEventRequestListener) {
        List list = this.messageEventRequestListeners;
        synchronized (list) {
            this.messageEventRequestListeners.remove(messageEventRequestListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageEventNotificationListener(MessageEventNotificationListener messageEventNotificationListener) {
        List list = this.messageEventNotificationListeners;
        synchronized (list) {
            if (!this.messageEventNotificationListeners.contains(messageEventNotificationListener)) {
                this.messageEventNotificationListeners.add(messageEventNotificationListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageEventNotificationListener(MessageEventNotificationListener messageEventNotificationListener) {
        List list = this.messageEventNotificationListeners;
        synchronized (list) {
            this.messageEventNotificationListeners.remove(messageEventNotificationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageEventRequestListeners(String from, String packetID, String methodName) {
        MessageEventRequestListener[] listeners = null;
        List list = this.messageEventRequestListeners;
        synchronized (list) {
            listeners = new MessageEventRequestListener[this.messageEventRequestListeners.size()];
            this.messageEventRequestListeners.toArray(listeners);
        }
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.jivesoftware.smackx.MessageEventRequestListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray = new Class[3];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz3;
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("org.jivesoftware.smackx.MessageEventManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[2] = clazz4;
            Method method = clazz.getDeclaredMethod(methodName, classArray);
            int i = 0;
            while (i < listeners.length) {
                method.invoke((Object)listeners[i], from, packetID, this);
                ++i;
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageEventNotificationListeners(String from, String packetID, String methodName) {
        MessageEventNotificationListener[] listeners = null;
        List list = this.messageEventNotificationListeners;
        synchronized (list) {
            listeners = new MessageEventNotificationListener[this.messageEventNotificationListeners.size()];
            this.messageEventNotificationListeners.toArray(listeners);
        }
        try {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.jivesoftware.smackx.MessageEventNotificationListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray = new Class[2];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz3;
            Method method = clazz.getDeclaredMethod(methodName, classArray);
            int i = 0;
            while (i < listeners.length) {
                method.invoke((Object)listeners[i], from, packetID);
                ++i;
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.packetListener = new PacketListener(){

            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                MessageEvent messageEvent = (MessageEvent)message.getExtension("x", "jabber:x:event");
                if (messageEvent.isMessageEventRequest()) {
                    Iterator it = messageEvent.getEventTypes();
                    while (it.hasNext()) {
                        MessageEventManager.this.fireMessageEventRequestListeners(message.getFrom(), message.getPacketID(), ((String)it.next()).concat("NotificationRequested"));
                    }
                } else {
                    Iterator it = messageEvent.getEventTypes();
                    while (it.hasNext()) {
                        MessageEventManager.this.fireMessageEventNotificationListeners(message.getFrom(), messageEvent.getPacketID(), ((String)it.next()).concat("Notification"));
                    }
                }
            }
        };
        this.con.addPacketListener(this.packetListener, this.packetFilter);
    }

    public void sendDeliveredNotification(String to, String packetID) {
        Message msg = new Message(to);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setDelivered(true);
        messageEvent.setPacketID(packetID);
        msg.addExtension(messageEvent);
        this.con.sendPacket(msg);
    }

    public void sendDisplayedNotification(String to, String packetID) {
        Message msg = new Message(to);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setDisplayed(true);
        messageEvent.setPacketID(packetID);
        msg.addExtension(messageEvent);
        this.con.sendPacket(msg);
    }

    public void sendComposingNotification(String to, String packetID) {
        Message msg = new Message(to);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setComposing(true);
        messageEvent.setPacketID(packetID);
        msg.addExtension(messageEvent);
        this.con.sendPacket(msg);
    }

    public void sendCancelledNotification(String to, String packetID) {
        Message msg = new Message(to);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setCancelled(true);
        messageEvent.setPacketID(packetID);
        msg.addExtension(messageEvent);
        this.con.sendPacket(msg);
    }

    public void destroy() {
        if (this.con != null) {
            this.con.removePacketListener(this.packetListener);
        }
    }

    public void finalize() {
        this.destroy();
    }
}

