/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.discovery;

import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.osgi.services.discovery.ECFServiceEndpointDescription;

public class ECFServiceEndpointDescriptionImpl
extends ECFServiceEndpointDescription {
    private static final long DEFAULT_FUTURE_TIMEOUT = new Long(System.getProperty("ecf.rs.lookup.timeout", new Long(30000L).toString()));
    private final ID endpointId;
    private final IServiceID serviceId;

    public ECFServiceEndpointDescriptionImpl(IServiceInfo serviceInfo) {
        super(((ServiceProperties)serviceInfo.getServiceProperties()).asProperties());
        this.serviceId = serviceInfo.getServiceID();
        IServiceProperties serviceProperties = serviceInfo.getServiceProperties();
        byte[] endpointBytes = serviceProperties.getPropertyBytes("ecf.sp.cid");
        if (endpointBytes == null) {
            throw new IDCreateException("ServiceEndpointDescription endpointBytes cannot be null");
        }
        String endpointStr = new String(endpointBytes);
        String namespaceStr = serviceProperties.getPropertyString("ecf.sp.cns");
        if (namespaceStr == null) {
            throw new IDCreateException("ServiceEndpointDescription namespaceStr cannot be null");
        }
        this.endpointId = IDFactory.getDefault().createID(namespaceStr, endpointStr);
    }

    public ID getECFEndpointID() throws IDCreateException {
        return this.endpointId;
    }

    public long getFutureTimeout() {
        return DEFAULT_FUTURE_TIMEOUT;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.serviceId == null ? 0 : this.serviceId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ECFServiceEndpointDescriptionImpl other = (ECFServiceEndpointDescriptionImpl)obj;
        return !(this.serviceId == null ? other.serviceId != null : !this.serviceId.equals((Object)other.serviceId));
    }
}

