/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.ContainerAdapterHelper;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.RemoteServiceRegistrations;
import org.eclipse.ecf.osgi.services.discovery.ECFServiceEndpointDescription;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceUnregisteredEvent;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.TimeoutException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.discovery.DiscoveredServiceNotification;
import org.osgi.service.discovery.DiscoveredServiceTracker;
import org.osgi.service.discovery.ServiceEndpointDescription;

public class DiscoveredServiceTrackerImpl
implements DiscoveredServiceTracker {
    DistributionProviderImpl distributionProvider;
    Map discoveredRemoteServiceRegistrations = Collections.synchronizedMap(new HashMap());
    List ecfRemoteServiceProperties = Arrays.asList("ecf.rsvc.id", "ecf.robjectClass", "osgi.remote.endpoint.id", "osgi.remote.endpoint.interface", "osgi.remote.endpoint.location", "service.interface", "service.interface.version", "service.properties");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public DiscoveredServiceTrackerImpl(DistributionProviderImpl dp) {
        this.distributionProvider = dp;
    }

    public void serviceChanged(DiscoveredServiceNotification notification) {
        if (notification == null) {
            this.logWarning("serviceChanged", "DiscoveredServiceNotification is null.  Ignoring");
            return;
        }
        int notificationType = notification.getType();
        switch (notificationType) {
            case 1: {
                this.handleDiscoveredServiceAvailable(notification.getServiceEndpointDescription());
                break;
            }
            case 4: {
                this.handleDiscoveredServiceUnavailable(notification.getServiceEndpointDescription());
                break;
            }
            case 2: {
                break;
            }
            case 8: {
                break;
            }
            default: {
                this.logWarning("serviceChanged", "DiscoveredServiceNotification type=" + notificationType + " not found.  Ignoring");
            }
        }
    }

    private void handleDiscoveredServiceUnavailable(ServiceEndpointDescription sed) {
        ECFServiceEndpointDescription ecfSED = this.getECFserviceEndpointDescription(sed);
        if (ecfSED == null) {
            return;
        }
        ServiceRegistration[] proxyServiceRegistrations = this.removeProxyServiceRegistrations((ServiceEndpointDescription)ecfSED);
        if (proxyServiceRegistrations != null) {
            int i = 0;
            while (i < proxyServiceRegistrations.length) {
                this.trace("handleDiscoveredServiceUnavailable", "proxyServiceRegistrations=" + proxyServiceRegistrations[i] + ",serviceEndpointDesc=" + ecfSED);
                this.unregisterProxyServiceRegistration(proxyServiceRegistrations[i]);
                ++i;
            }
        }
    }

    private void handleDiscoveredServiceAvailable(ServiceEndpointDescription sed) {
        ECFServiceEndpointDescription ecfSED = this.getECFserviceEndpointDescription(sed);
        if (ecfSED == null) {
            return;
        }
        ID endpointID = ecfSED.getECFEndpointID();
        ContainerAdapterHelper[] cahs = this.findRSCAs(endpointID, (ServiceEndpointDescription)ecfSED);
        if (cahs == null || cahs.length == 0) {
            this.logError("handleDiscoveredServiceAvailable", "No RemoteServiceContainerAdapters found for description=" + ecfSED, null);
            return;
        }
        if (cahs.length > 1) {
            this.logWarning("handleDiscoveredServiceAvailable", "Multiple remote service containers=" + Arrays.asList(cahs) + " found for service endpoint description=" + ecfSED);
        }
        Collection providedInterfaces = ecfSED.getProvidedInterfaces();
        int i = 0;
        while (i < cahs.length) {
            Iterator j = providedInterfaces.iterator();
            while (j.hasNext()) {
                String providedInterface = (String)j.next();
                this.trace("handleDiscoveredServiceAvailable", "rsca=" + cahs[i] + ",intf=" + providedInterface);
                IFuture futureRemoteReferences = cahs[i].getRSCA().asyncGetRemoteServiceReferences(new ID[]{endpointID}, providedInterface, null);
                this.processFutureForRemoteServiceReferences(ecfSED, futureRemoteReferences, cahs[i]);
            }
            ++i;
        }
    }

    private ECFServiceEndpointDescription getECFserviceEndpointDescription(ServiceEndpointDescription aServiceEndpointDesc) {
        ECFServiceEndpointDescription ecfSED;
        if (!(aServiceEndpointDesc instanceof ECFServiceEndpointDescription)) {
            IAdapterManager adapterManager = Activator.getDefault().getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.osgi.services.discovery.ECFServiceEndpointDescription");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ecfSED = (ECFServiceEndpointDescription)adapterManager.loadAdapter((Object)aServiceEndpointDesc, clazz.getName());
        } else {
            ecfSED = (ECFServiceEndpointDescription)aServiceEndpointDesc;
        }
        return ecfSED;
    }

    private void processFutureForRemoteServiceReferences(final ECFServiceEndpointDescription sed, final IFuture futureRemoteReferences, final ContainerAdapterHelper ch) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    IRemoteServiceReference[] remoteReferences = (IRemoteServiceReference[])futureRemoteReferences.get(sed.getFutureTimeout());
                    IStatus futureStatus = futureRemoteReferences.getStatus();
                    if (futureStatus.isOK()) {
                        DiscoveredServiceTrackerImpl.this.trace("processFutureForRemoteServiceReferences.run", "containerHelper=" + ch + "remoteReferences=" + (remoteReferences == null ? "null" : Arrays.asList(remoteReferences).toString()));
                        if (remoteReferences != null && remoteReferences.length > 0) {
                            DiscoveredServiceTrackerImpl.this.registerRemoteServiceReferences(sed, ch, remoteReferences);
                        } else {
                            DiscoveredServiceTrackerImpl.this.logError("processFutureForRemoteServiceReferences", "getRemoteServiceReferences result is empty. containerHelper=" + ch + "remoteReferences=" + (remoteReferences == null ? "null" : Arrays.asList(remoteReferences).toString()), null);
                        }
                    } else {
                        DiscoveredServiceTrackerImpl.this.logError("processFutureForRemoteServiceReferences", "Future status NOT ok message=" + futureStatus.getMessage(), futureStatus.getException());
                    }
                }
                catch (InterruptedException e) {
                    DiscoveredServiceTrackerImpl.this.logError("processFutureForRemoteServiceReferences", "Retrieval interrupted", e);
                }
                catch (OperationCanceledException e) {
                    DiscoveredServiceTrackerImpl.this.logError("processFutureForRemoteServiceReferences", "Retrieval cancelled", e);
                }
                catch (TimeoutException e) {
                    DiscoveredServiceTrackerImpl.this.logError("processFutureForRemoteServiceReferences", "Retrieval timedout after " + e.getDuration(), e);
                }
            }
        });
        t.start();
    }

    private void addProxyServiceRegistration(ServiceEndpointDescription sed, ContainerAdapterHelper ch, IRemoteServiceReference ref, ServiceRegistration registration) {
        ID containerID = ch.getContainer().getID();
        RemoteServiceRegistrations reg = (RemoteServiceRegistrations)this.discoveredRemoteServiceRegistrations.get(containerID);
        if (reg == null) {
            reg = new RemoteServiceRegistrations(sed, ch.getContainer(), ch.getRSCA(), new RemoteServiceReferenceUnregisteredListener());
            this.discoveredRemoteServiceRegistrations.put(containerID, reg);
        }
        reg.addServiceRegistration(ref, registration);
        this.trace("addLocalServiceRegistration", "containerHelper=" + ch + ",remoteServiceReference=" + ref + ",localServiceRegistration=" + registration);
        this.distributionProvider.addRemoteService(registration.getReference());
    }

    private boolean findProxyServiceRegistration(ServiceEndpointDescription sed) {
        Iterator i = this.discoveredRemoteServiceRegistrations.keySet().iterator();
        while (i.hasNext()) {
            ID containerID = (ID)i.next();
            RemoteServiceRegistrations reg = (RemoteServiceRegistrations)this.discoveredRemoteServiceRegistrations.get(containerID);
            if (!sed.equals(reg.getServiceEndpointDescription())) continue;
            return true;
        }
        return false;
    }

    private ServiceRegistration[] removeProxyServiceRegistrations(ServiceEndpointDescription sed) {
        ArrayList results = new ArrayList();
        Iterator i = this.discoveredRemoteServiceRegistrations.keySet().iterator();
        while (i.hasNext()) {
            ID containerID = (ID)i.next();
            RemoteServiceRegistrations reg = (RemoteServiceRegistrations)this.discoveredRemoteServiceRegistrations.get(containerID);
            if (!sed.equals(reg.getServiceEndpointDescription())) continue;
            i.remove();
            results.addAll(reg.removeAllServiceRegistrations());
            reg.dispose();
        }
        return results.toArray(new ServiceRegistration[0]);
    }

    private void unregisterProxyServiceRegistration(ServiceRegistration reg) {
        try {
            this.distributionProvider.removeRemoteService(reg.getReference());
            reg.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            this.logWarning("unregisterProxyServiceRegistration", "Exception unregistering serviceRegistration=" + reg);
        }
        catch (Exception e) {
            this.logError("unregisterProxyServiceRegistration", "Exception unregistering serviceRegistration=" + reg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRemoteServiceReferences(ECFServiceEndpointDescription sed, ContainerAdapterHelper ch, IRemoteServiceReference[] remoteReferences) {
        Map map = this.discoveredRemoteServiceRegistrations;
        synchronized (map) {
            if (this.findProxyServiceRegistration((ServiceEndpointDescription)sed)) {
                this.logError("registerRemoteServiceReferences", "serviceEndpointDesc=" + sed + " previously registered locally...ignoring", null);
                return;
            }
            int i = 0;
            while (i < remoteReferences.length) {
                IRemoteService remoteService = ch.getRSCA().getRemoteService(remoteReferences[i]);
                if (remoteService == null) {
                    this.logError("registerRemoteServiceReferences", "Remote service is null for remote reference " + remoteReferences[i], null);
                } else {
                    String[] clazzes = (String[])remoteReferences[i].getProperty("ecf.robjectClass");
                    if (clazzes == null || clazzes.length == 0) {
                        this.logError("registerRemoteServiceReferences", "No classes specified for remote service reference " + remoteReferences[i], null);
                    } else {
                        Dictionary properties = this.getPropertiesForRemoteService((ServiceEndpointDescription)sed, ch.getRSCA(), remoteReferences[i], remoteService);
                        Object proxy = null;
                        try {
                            proxy = remoteService.getProxy();
                            if (proxy == null) {
                                this.logError("registerRemoteServiceReferences", "Remote service proxy is null", null);
                            } else {
                                this.trace("registerRemoteServiceReferences", "rsca=" + ch + ",remoteReference=" + remoteReferences[i]);
                                ServiceRegistration registration = Activator.getDefault().getContext().registerService(clazzes, proxy, properties);
                                this.addProxyServiceRegistration((ServiceEndpointDescription)sed, ch, remoteReferences[i], registration);
                            }
                        }
                        catch (Exception e) {
                            this.logError("registerRemoteServiceReferences", "Exception creating or registering remote reference " + remoteReferences[i], e);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private boolean isRemoteServiceProperty(String propertyKey) {
        return this.ecfRemoteServiceProperties.contains(propertyKey);
    }

    private Dictionary getPropertiesForRemoteService(ServiceEndpointDescription description, IRemoteServiceContainerAdapter containerAdapter, IRemoteServiceReference remoteReference, IRemoteService remoteService) {
        Properties results = new Properties();
        String[] propKeys = remoteReference.getPropertyKeys();
        int i = 0;
        while (i < propKeys.length) {
            if (!this.isRemoteServiceProperty(propKeys[i])) {
                results.put(propKeys[i], remoteReference.getProperty(propKeys[i]));
            }
            ++i;
        }
        results.put("osgi.remote", remoteService);
        return results;
    }

    private ContainerAdapterHelper[] findRSCAs(ID endpointID, ServiceEndpointDescription sedh) {
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        if (containerManager == null) {
            return null;
        }
        IContainer[] containers = containerManager.getAllContainers();
        if (containers == null) {
            this.logWarning("findRSCAs", "No containers found for container manager");
            return new ContainerAdapterHelper[0];
        }
        ArrayList<ContainerAdapterHelper> results = new ArrayList<ContainerAdapterHelper>();
        int i = 0;
        while (i < containers.length) {
            IRemoteServiceContainerAdapter adapter;
            IContainer iContainer = containers[i];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IRemoteServiceContainerAdapter)iContainer.getAdapter((Class)clazz)) != null && this.includeRCSAForDescription(containers[i], adapter, endpointID, sedh)) {
                results.add(new ContainerAdapterHelper(containers[i], adapter));
            }
            ++i;
        }
        return results.toArray(new ContainerAdapterHelper[0]);
    }

    private boolean includeRCSAForDescription(IContainer container, IRemoteServiceContainerAdapter adapter, ID endpointID, ServiceEndpointDescription description) {
        Namespace namespace;
        if (endpointID.equals((Object)container.getID())) {
            return false;
        }
        String connectNamespaceName = (String)description.getProperty("ecf.sp.cns");
        return connectNamespaceName != null && (namespace = container.getConnectNamespace()) != null && namespace.getName().equals(connectNamespaceName);
    }

    protected void trace(String methodName, String message) {
        Trace.trace((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug/discoveredservicetracker", this.getClass(), (String)methodName, (String)message);
    }

    protected void traceException(String methodName, String message, Throwable t) {
        Trace.catching((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug/exceptions/catching", this.getClass(), (String)(String.valueOf(methodName == null ? "<unknown>" : methodName) + ":" + (message == null ? "<empty>" : message)), (Throwable)t);
    }

    protected void logError(String methodName, String message, Throwable t) {
        this.traceException(methodName, message, t);
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.osgi.services.distribution", 4, String.valueOf(this.getClass().getName()) + ":" + (methodName == null ? "<unknown>" : methodName) + ":" + (message == null ? "<empty>" : message), t));
    }

    protected void logError(String methodName, String message) {
        this.logError(methodName, message, null);
        this.traceException(methodName, message, null);
    }

    private void logWarning(String methodName, String message) {
        this.trace(methodName, "WARNING:" + message);
        Activator activator = Activator.getDefault();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ecf.internal.osgi.services.distribution.DiscoveredServiceTrackerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        activator.log((IStatus)new Status(2, "org.eclipse.ecf.osgi.services.distribution", 2, String.valueOf(clazz.getName()) + ":" + (methodName == null ? "<unknown>" : methodName) + ":" + (message == null ? "<empty>" : message), null));
    }

    class RemoteServiceReferenceUnregisteredListener
    implements IRemoteServiceListener {
        RemoteServiceReferenceUnregisteredListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleServiceEvent(IRemoteServiceEvent event) {
            if (event instanceof IRemoteServiceUnregisteredEvent) {
                DiscoveredServiceTrackerImpl.this.trace("handleRemoteServiceUnregisteredEvent", "localContainerID=" + event.getLocalContainerID() + ",containerID=" + event.getContainerID() + ",remoteReference=" + event.getReference());
                ServiceRegistration[] proxyServiceRegistrations = null;
                Map map = DiscoveredServiceTrackerImpl.this.discoveredRemoteServiceRegistrations;
                synchronized (map) {
                    RemoteServiceRegistrations rsRegs = (RemoteServiceRegistrations)DiscoveredServiceTrackerImpl.this.discoveredRemoteServiceRegistrations.get(event.getLocalContainerID());
                    if (rsRegs != null) {
                        proxyServiceRegistrations = rsRegs.removeServiceRegistration(event.getReference());
                        if (rsRegs.isEmpty()) {
                            rsRegs.dispose();
                            DiscoveredServiceTrackerImpl.this.discoveredRemoteServiceRegistrations.remove(event.getContainerID());
                        }
                    }
                }
                if (proxyServiceRegistrations != null) {
                    int i = 0;
                    while (i < proxyServiceRegistrations.length) {
                        DiscoveredServiceTrackerImpl.this.trace("handleRemoteServiceUnregisteredEvent.unregister", "localContainerID=" + event.getLocalContainerID() + ",containerID=" + event.getContainerID() + ",remoteReference=" + event.getReference() + ",proxyServiceRegistrations=" + proxyServiceRegistrations[i]);
                        DiscoveredServiceTrackerImpl.this.unregisterProxyServiceRegistration(proxyServiceRegistrations[i]);
                        ++i;
                    }
                }
            }
        }
    }
}

