/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.internal.osgi.services.distribution.AbstractEventHookImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.discovery.ServicePublication;

public class EventHookImpl
extends AbstractEventHookImpl {
    private static final String CONTAINER_DEFAULT_TYPE = System.getProperty("ecf.osgi.services.distribution.container.default.type", "ecf.r_osgi.peer");
    private static final List excludedProperties = Arrays.asList("service.id", "objectClass", "osgi.remote.interfaces", "osgi.remote.requires.intents", "osgi.remote", "osgi.remote.configuration.type", "ecf.rsvc.cid");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public EventHookImpl(DistributionProviderImpl distributionProvider) {
        super(distributionProvider);
    }

    protected void registerRemoteService(ServiceReference serviceReference, String[] remoteInterfaces, String[] remoteConfigurationType) {
        Map ecfConfiguration = this.parseECFConfigurationType(remoteConfigurationType);
        RSCAHolder[] rscas = this.findRSCAHolders(serviceReference, ecfConfiguration);
        if (rscas == null || rscas.length == 0) {
            this.trace("registerRemoteService", "No remote service container adapters found for serviceReference=" + serviceReference + " and configuration=" + ecfConfiguration);
            return;
        }
        String[] remoteRequiresIntents = (String[])serviceReference.getProperty("osgi.remote.requires.intents");
        if (remoteRequiresIntents != null) {
            rscas = this.findRSCAHoldersSatisfyingRequiredIntents(rscas, remoteRequiresIntents);
        }
        if (rscas == null || rscas.length == 0) {
            this.trace("registerRemoteService", "No remote service container adapters found satisfying required intents for serviceReference=" + serviceReference + " and configuration=" + ecfConfiguration);
            return;
        }
        int i = 0;
        while (i < rscas.length) {
            IRemoteServiceRegistration remoteRegistration = rscas[i].getContainerAdapter().registerRemoteService(remoteInterfaces, this.getService(serviceReference), this.getPropertiesForRemoteService(serviceReference));
            this.trace("registerRemoteService", "containerID=" + rscas[i].getContainer().getID() + " serviceReference=" + serviceReference + " remoteRegistration=" + remoteRegistration);
            this.fireRemoteServiceRegistered(serviceReference, remoteRegistration);
            this.publishRemoteService(rscas[i], serviceReference, remoteInterfaces, remoteRegistration);
            ++i;
        }
    }

    private RSCAHolder[] findRSCAHoldersSatisfyingRequiredIntents(RSCAHolder[] rscas, String[] remoteRequiresIntents) {
        ArrayList<RSCAHolder> results = new ArrayList<RSCAHolder>();
        int i = 0;
        while (i < rscas.length) {
            boolean include = true;
            List<String> supportedIntents = Arrays.asList(rscas[i].getContainerTypeDescription().getSupportedIntents());
            int j = 0;
            while (j < remoteRequiresIntents.length) {
                if (!supportedIntents.contains(remoteRequiresIntents[j])) {
                    include = false;
                }
                ++j;
            }
            if (include) {
                this.trace("findRSCAHoldersSatisfyingRequiredIntents.include", "containerID=" + rscas[i].getContainer().getID() + " satisfying intents.  supported intents=" + supportedIntents);
                results.add(rscas[i]);
            } else {
                this.trace("findRSCAHoldersSatisfyingRequiredIntents.exclude", "containerID=" + rscas[i].getContainer().getID() + " supported intents=" + supportedIntents);
            }
            ++i;
        }
        return results.toArray(new RSCAHolder[0]);
    }

    Dictionary getServicePublicationProperties(RSCAHolder holder, ServiceReference ref, String[] remoteInterfaces, IRemoteServiceRegistration remoteRegistration) {
        Properties properties = new Properties();
        ((Dictionary)properties).put("service.interface", this.getAsCollection(remoteInterfaces));
        ((Dictionary)properties).put("service.properties", this.getServicePropertiesForRemotePublication(ref));
        IContainer container = holder.getContainer();
        ((Dictionary)properties).put("ecf.sp.cid", container.getID());
        Namespace rsnamespace = holder.getContainerAdapter().getRemoteServiceNamespace();
        if (rsnamespace != null) {
            ((Dictionary)properties).put("ecf.rsvc.ns", rsnamespace.getName());
        }
        ((Dictionary)properties).put("ecf.rsvc.id", (Long)remoteRegistration.getProperty("ecf.rsvc.id"));
        return properties;
    }

    private void publishRemoteService(RSCAHolder holder, ServiceReference ref, String[] remoteInterfaces, IRemoteServiceRegistration remoteRegistration) {
        Dictionary properties = this.getServicePublicationProperties(holder, ref, remoteInterfaces, remoteRegistration);
        BundleContext context = Activator.getDefault().getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.discovery.ServicePublication");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceRegistration reg = context.registerService(clazz.getName(), (Object)new ServicePublication(){}, properties);
        this.fireRemoteServicePublished(ref, reg);
        this.trace("publishRemoteService", "containerID=" + holder.getContainer().getID() + ",serviceReference=" + ref + " properties=" + properties + ",remoteRegistration=" + remoteRegistration);
    }

    private Collection getAsCollection(String[] remoteInterfaces) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < remoteInterfaces.length) {
            result.add(remoteInterfaces[i]);
            ++i;
        }
        return result;
    }

    private Map parseECFConfigurationType(String[] remoteConfigurationType) {
        HashMap results = new HashMap();
        return results;
    }

    protected Dictionary getPropertiesForRemoteService(ServiceReference sr) {
        String[] propKeys = sr.getPropertyKeys();
        Properties newProps = new Properties();
        int i = 0;
        while (i < propKeys.length) {
            if (!this.excludeRemoteServiceProperty(propKeys[i])) {
                newProps.put(propKeys[i], sr.getProperty(propKeys[i]));
            }
            ++i;
        }
        return newProps;
    }

    protected Map getServicePropertiesForRemotePublication(ServiceReference sr) {
        String[] propKeys = sr.getPropertyKeys();
        Properties newProps = new Properties();
        int i = 0;
        while (i < propKeys.length) {
            if (!this.excludeRemoteServiceProperty(propKeys[i])) {
                newProps.put(propKeys[i], sr.getProperty(propKeys[i]));
            }
            ++i;
        }
        return newProps;
    }

    private boolean excludeRemoteServiceProperty(String string) {
        return excludedProperties.contains(string);
    }

    protected RSCAHolder[] findRSCAHolders(ServiceReference serviceReference, Map ecfConfiguration) {
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        return containerManager != null ? this.findRSCAHoldersWithContainerManager(containerManager, serviceReference, ecfConfiguration) : null;
    }

    private RSCAHolder[] findRSCAHoldersWithContainerManager(IContainerManager containerManager, ServiceReference serviceReference, Map ecfConfiguration) {
        IContainer[] containers = containerManager.getAllContainers();
        if (containers == null || containers.length == 0) {
            containers = this.createDefaultContainer(containerManager.getContainerFactory());
        }
        ArrayList<RSCAHolder> rscas = new ArrayList<RSCAHolder>();
        int i = 0;
        while (i < containers.length) {
            IRemoteServiceContainerAdapter rsca;
            IContainer iContainer = containers[i];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((rsca = (IRemoteServiceContainerAdapter)iContainer.getAdapter((Class)clazz)) == null) {
                this.trace("getRSCAHoldersFromContainers", "Container=" + containers[i].getID() + " not an IRemoteServiceContainerAdapter. Excluding rsca=" + rsca + " from remote registration");
            } else {
                ContainerTypeDescription desc = containerManager.getContainerTypeDescription(containers[i].getID());
                if (desc == null) {
                    this.trace("getRSCAHoldersFromContainers", "Container=" + containers[i].getID() + " has null ContainerTypeDescription. Excluding rsca=" + rsca + " from remote registration");
                } else if (this.includeContainer(containers[i], rsca, desc, serviceReference, ecfConfiguration)) {
                    rscas.add(new RSCAHolder(containers[i], rsca, desc));
                }
            }
            ++i;
        }
        return rscas.toArray(new RSCAHolder[0]);
    }

    protected boolean includeContainer(IContainer container, IRemoteServiceContainerAdapter rsca, ContainerTypeDescription desc, ServiceReference serviceReference, Map ecfConfiguration) {
        Object cID = serviceReference.getProperty("ecf.rsvc.cid");
        if (cID == null || !(cID instanceof ID)) {
            this.trace("includeContainer", "serviceReference=" + serviceReference + " does not set remote service container id service property.  INCLUDING containerID=" + container.getID() + " in remote registration");
            return true;
        }
        ID containerID = (ID)cID;
        if (container.getID().equals((Object)containerID)) {
            this.trace("includeContainer", "serviceReference=" + serviceReference + " has MATCHING container id=" + containerID + ".  INCLUDING rsca=" + container.getID() + " in remote registration");
            return true;
        }
        this.trace("includeContainer", "serviceReference=" + serviceReference + " has non-matching id=" + containerID + ".  EXCLUDING id=" + container.getID() + " in remote registration");
        return false;
    }

    private IContainer[] createDefaultContainer(IContainerFactory iContainerFactory) {
        try {
            IContainer[] containers = new IContainer[]{iContainerFactory.createContainer(CONTAINER_DEFAULT_TYPE)};
            return containers;
        }
        catch (ContainerCreateException e) {
            this.trace("createDefaultContainer", "Failed to create default container" + e.getLocalizedMessage());
            Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.osgi.services.distribution", "Failed to create default container", (Throwable)e));
            return new IContainer[0];
        }
    }

    class RSCAHolder {
        private IContainer container;
        private IRemoteServiceContainerAdapter rsca;
        private ContainerTypeDescription ctd;

        public RSCAHolder(IContainer c, IRemoteServiceContainerAdapter ca, ContainerTypeDescription d) {
            Assert.isNotNull((Object)c);
            Assert.isNotNull((Object)ca);
            Assert.isNotNull((Object)d);
            this.container = c;
            this.rsca = ca;
            this.ctd = d;
        }

        public IContainer getContainer() {
            return this.container;
        }

        public IRemoteServiceContainerAdapter getContainerAdapter() {
            return this.rsca;
        }

        public ContainerTypeDescription getContainerTypeDescription() {
            return this.ctd;
        }
    }
}

