/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.filetransfer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.filetransfer.IFileTransferInfo;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IIncomingFileTransferRequestListener;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IFileTransferRequestEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.internal.provider.xmpp.XmppPlugin;
import org.eclipse.ecf.internal.provider.xmpp.filetransfer.XMPPIncomingFileTransfer;
import org.eclipse.ecf.provider.xmpp.identity.XMPPID;
import org.jivesoftware.smackx.filetransfer.FileTransferListener;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IncomingFileTransfer;

public class XMPPFileTransferRequestListener
implements FileTransferListener {
    protected IFileTransferListener transferListener;
    protected IIncomingFileTransferRequestListener requestListener;
    protected IncomingFileTransfer incoming = null;
    protected IContainer container = null;

    public XMPPFileTransferRequestListener(IContainer container, IIncomingFileTransferRequestListener listener) {
        this.container = container;
        this.requestListener = listener;
    }

    public void fileTransferRequest(final FileTransferRequest request) {
        this.requestListener.handleFileTransferRequest(new IFileTransferRequestEvent(){
            private static final long serialVersionUID = -6173401619917403353L;
            boolean requestAccepted = false;
            IFileTransferInfo fileTransferInfo;
            {
                this.fileTransferInfo = new IFileTransferInfo(this, fileTransferRequest){
                    Map props;
                    File f;
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ FileTransferRequest val$request;
                    {
                        this.this$1 = var1_1;
                        this.val$request = fileTransferRequest;
                        this.props = new HashMap<K, V>();
                        this.f = new File(fileTransferRequest.getFileName());
                    }

                    public String getDescription() {
                        return this.val$request.getDescription();
                    }

                    public File getFile() {
                        return this.f;
                    }

                    public Map getProperties() {
                        return this.props;
                    }

                    public Object getAdapter(Class adapter) {
                        if (adapter == null) {
                            return null;
                        }
                        if (adapter.isInstance(this)) {
                            return this;
                        }
                        IAdapterManager adapterManager = XmppPlugin.getDefault().getAdapterManager();
                        return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
                    }

                    public long getFileSize() {
                        return this.val$request.getFileSize();
                    }

                    public String getMimeType() {
                        return this.val$request.getMimeType();
                    }

                    public String toString() {
                        StringBuffer buf = new StringBuffer("FileTransferInfo[");
                        buf.append("file=").append(this.f);
                        buf.append(";size=").append(this.getFileSize());
                        buf.append(";description=" + this.getDescription());
                        buf.append(";mimeType=").append(this.getMimeType()).append("]");
                        return buf.toString();
                    }
                };
            }

            public IIncomingFileTransfer accept(File localFileToSave) throws IncomingFileTransferException {
                try {
                    FileOutputStream outs = new FileOutputStream(localFileToSave);
                    return this.accept(outs, new IFileTransferListener(this, outs){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ OutputStream val$outs;
                        {
                            this.this$1 = var1_1;
                            this.val$outs = outputStream;
                        }

                        public void handleTransferEvent(IFileTransferEvent event) {
                            if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
                                try {
                                    this.val$outs.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    });
                }
                catch (FileNotFoundException e) {
                    throw new IncomingFileTransferException("Exception opening file for writing", (Throwable)e);
                }
            }

            public IFileTransferInfo getFileTransferInfo() {
                return this.fileTransferInfo;
            }

            public ID getRequesterID() {
                return XMPPFileTransferRequestListener.this.createIDFromName(request.getRequestor());
            }

            public void reject() {
                request.reject();
            }

            public boolean requestAccepted() {
                return this.requestAccepted;
            }

            public String toString() {
                StringBuffer buf = new StringBuffer("FileTransferRequestEvent[");
                buf.append("requester=").append(this.getRequesterID());
                buf.append(";requestAccepted=").append(this.requestAccepted());
                buf.append(";transferInfo=").append(this.getFileTransferInfo()).append("]");
                return buf.toString();
            }

            public IIncomingFileTransfer accept(OutputStream outputStream, IFileTransferListener listener) throws IncomingFileTransferException {
                if (this.requestAccepted) {
                    throw new IncomingFileTransferException("Incoming request previously accepted");
                }
                if (outputStream == null) {
                    throw new IncomingFileTransferException("outputStream cannot be null");
                }
                XMPPFileTransferRequestListener.this.incoming = request.accept();
                try {
                    return new XMPPIncomingFileTransfer(IDFactory.getDefault().createStringID(request.getStreamID()), request.getFileName(), XMPPFileTransferRequestListener.this.incoming.recieveFile(), outputStream, request.getFileSize(), listener);
                }
                catch (Exception e) {
                    throw new IncomingFileTransferException("Exception receiving file", (Throwable)e);
                }
            }
        });
    }

    private XMPPID createIDFromName(String uname) {
        try {
            return new XMPPID(this.container.getConnectNamespace(), uname);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean hasListener(IIncomingFileTransferRequestListener listener2) {
        return listener2 == this.requestListener;
    }
}

