/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.remoteservices.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.remoteservices.ui.RemoteServiceHandlerUtil;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;
import org.eclipse.ecf.remoteservices.ui.MethodInvocationDialog;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class ReflectiveRemoteServiceHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String clazz = event.getParameter("org.eclipse.ecf.remoteservices.ui.commands.reflectiveMethodDialogParameter");
        IRemoteServiceContainerAdapter adapter = RemoteServiceHandlerUtil.getActiveIRemoteServiceContainerAdapterChecked(event);
        if (adapter == null) {
            MessageDialog.openError(null, (String)"Handler invocation failed", (String)"No container found");
            return null;
        }
        IRemoteServiceReference[] references = RemoteServiceHandlerUtil.getActiveIRemoteServiceReferencesChecked(event);
        if (references == null || references.length == 0) {
            MessageDialog.openError(null, (String)"Handler invocation failed", (String)"No remote service reference found");
            return null;
        }
        IRemoteService remoteService = adapter.getRemoteService(references[0]);
        if (remoteService == null) {
            MessageDialog.openError(null, (String)"Handler invocation failed", (String)"No remote service found");
            return null;
        }
        try {
            this.executeMethodInvocationDialog(Class.forName(clazz), remoteService);
        }
        catch (ClassNotFoundException e) {
            MessageDialog.openError(null, (String)"Handler invocation failed", (String)e.getLocalizedMessage());
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void executeMethodInvocationDialog(Class cls, IRemoteService remoteService) {
        MethodInvocationDialog mid = new MethodInvocationDialog(null, cls);
        if (mid.open() == 0) {
            final int timeout = mid.getTimeout() > 0 ? mid.getTimeout() : 30000;
            final String methodName = mid.getMethod().getName();
            final Object[] methodArgs = mid.getMethodArguments();
            IRemoteCall remoteCall = new IRemoteCall(){

                public String getMethod() {
                    return methodName;
                }

                public Object[] getParameters() {
                    return methodArgs;
                }

                public long getTimeout() {
                    return timeout;
                }
            };
            int invokeType = mid.getInvocationType();
            try {
                switch (invokeType) {
                    case 2: {
                        remoteService.callAsync(remoteCall);
                        break;
                    }
                    case 1: {
                        this.invokeFuture(cls, remoteService, remoteCall);
                        break;
                    }
                    case 0: {
                        this.invokeAsyncListener(cls, remoteService, remoteCall);
                        break;
                    }
                    case 3: {
                        throw new UnsupportedOperationException();
                    }
                    case 4: {
                        throw new UnsupportedOperationException();
                    }
                    case 5: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            catch (Exception e) {
                this.showException(e);
            }
        }
    }

    protected void showException(final Throwable t, final IContainer container, ID targetID) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                String msg = t.toString();
                if (t.getCause() != null) {
                    msg = String.valueOf(msg) + t.getCause().toString();
                }
                MessageDialog.openInformation(null, (String)"Received Exception", (String)NLS.bind((String)"Exception: {0}", (Object)msg));
                container.disconnect();
            }
        });
    }

    protected void invokeFuture(Class cls, IRemoteService remoteService, IRemoteCall remoteCall) throws InterruptedException, InvocationTargetException, OperationCanceledException {
        IFuture asyncResult = remoteService.callAsync(remoteCall);
        this.showResult(cls.getName(), remoteCall, asyncResult.get());
    }

    private void invokeAsyncListener(final Class interfaceClass, IRemoteService remoteService, final IRemoteCall remoteCall) {
        remoteService.callAsync(remoteCall, new IRemoteCallListener(){

            public void handleEvent(IRemoteCallEvent event) {
                if (event instanceof IRemoteCallCompleteEvent) {
                    IRemoteCallCompleteEvent complete = (IRemoteCallCompleteEvent)event;
                    if (complete.hadException()) {
                        ReflectiveRemoteServiceHandler.this.showException(complete.getException());
                    } else {
                        ReflectiveRemoteServiceHandler.this.showResult(interfaceClass.getName(), remoteCall, complete.getResponse());
                    }
                }
            }
        });
    }

    protected void showException(final Throwable t) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                String msg = t.toString();
                if (t.getCause() != null) {
                    msg = String.valueOf(msg) + t.getCause().toString();
                }
                MessageDialog.openInformation(null, (String)"Received Exception", (String)NLS.bind((String)"Exception: {0}", (Object)msg));
            }
        });
    }

    protected void showResult(String serviceInterface, IRemoteCall remoteCall, Object result) {
        List<Object> display = result != null && result.getClass().isArray() ? Arrays.asList((Object[])result) : result;
        final Object[] bindings = new Object[]{serviceInterface, remoteCall.getMethod(), Arrays.asList(remoteCall.getParameters()), display};
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation(null, (String)"Received Response", (String)NLS.bind((String)"Service Interface:\n{0}\n\nMethod: {1}\nParameters: {2}\n\nResult:  {3}", (Object[])bindings));
            }
        });
    }
}

