/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.messages;

import ch.ethz.iks.r_osgi.RemoteOSGiException;
import ch.ethz.iks.r_osgi.messages.DeliverServiceMessage;
import ch.ethz.iks.r_osgi.messages.FetchServiceMessage;
import ch.ethz.iks.r_osgi.messages.InvokeMethodMessage;
import ch.ethz.iks.r_osgi.messages.LeaseMessage;
import ch.ethz.iks.r_osgi.messages.LeaseUpdateMessage;
import ch.ethz.iks.r_osgi.messages.MethodResultMessage;
import ch.ethz.iks.r_osgi.messages.RemoteEventMessage;
import ch.ethz.iks.r_osgi.messages.StreamRequestMessage;
import ch.ethz.iks.r_osgi.messages.StreamResultMessage;
import ch.ethz.iks.r_osgi.messages.TimeOffsetMessage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class RemoteOSGiMessage {
    public static final short LEASE = 1;
    public static final short FETCH_SERVICE = 2;
    public static final short DELIVER_SERVICE = 3;
    public static final short DELIVER_BUNDLE = 4;
    public static final short INVOKE_METHOD = 5;
    public static final short METHOD_RESULT = 6;
    public static final short REMOTE_EVENT = 7;
    public static final short TIME_OFFSET = 8;
    public static final short LEASE_UPDATE = 9;
    public static final short STREAM_REQUEST = 10;
    public static final short STREAM_RESULT = 11;
    private short funcID;
    protected short xid;

    RemoteOSGiMessage(short funcID) {
        this.funcID = funcID;
    }

    public final short getXID() {
        return this.xid;
    }

    public void setXID(short xid) {
        this.xid = xid;
    }

    public final short getFuncID() {
        return this.funcID;
    }

    public static RemoteOSGiMessage parse(ObjectInputStream input) throws IOException {
        RemoteOSGiMessage msg;
        input.readByte();
        byte funcID = input.readByte();
        short xid = input.readShort();
        switch (funcID) {
            case 1: {
                msg = new LeaseMessage(input);
                break;
            }
            case 2: {
                msg = new FetchServiceMessage(input);
                break;
            }
            case 3: {
                msg = new DeliverServiceMessage(input);
                break;
            }
            case 5: {
                msg = new InvokeMethodMessage(input);
                break;
            }
            case 6: {
                msg = new MethodResultMessage(input);
                break;
            }
            case 7: {
                msg = new RemoteEventMessage(input);
                break;
            }
            case 8: {
                msg = new TimeOffsetMessage(input);
                break;
            }
            case 9: {
                msg = new LeaseUpdateMessage(input);
                break;
            }
            case 10: {
                msg = new StreamRequestMessage(input);
                break;
            }
            case 11: {
                msg = new StreamResultMessage(input);
                break;
            }
            default: {
                throw new RemoteOSGiException("funcID " + funcID + " not supported.");
            }
        }
        msg.funcID = funcID;
        msg.xid = xid;
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(ObjectOutputStream out) throws IOException {
        ObjectOutputStream objectOutputStream = out;
        synchronized (objectOutputStream) {
            out.write(1);
            out.write(this.funcID);
            out.writeShort(this.xid);
            this.writeBody(out);
            out.flush();
            out.reset();
        }
    }

    protected abstract void writeBody(ObjectOutputStream var1) throws IOException;

    protected static byte[] readBytes(ObjectInputStream input) throws IOException {
        int length = input.readInt();
        byte[] buffer = new byte[length];
        input.readFully(buffer);
        return buffer;
    }

    protected static void writeBytes(ObjectOutputStream out, byte[] bytes) throws IOException {
        out.writeInt(bytes.length);
        if (bytes.length > 0) {
            out.write(bytes);
        }
    }

    protected static void writeStringArray(ObjectOutputStream out, String[] strings) throws IOException {
        short length = (short)strings.length;
        out.writeShort(length);
        short i = 0;
        while (i < length) {
            out.writeUTF(strings[i]);
            i = (short)(i + 1);
        }
    }

    protected static String[] readStringArray(ObjectInputStream in) throws IOException {
        short length = in.readShort();
        String[] result = new String[length];
        short i = 0;
        while (i < length) {
            result[i] = in.readUTF();
            i = (short)(i + 1);
        }
        return result;
    }
}

