/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceURL;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

class ServiceDeregistration
extends SLPMessage {
    ServiceURL url;
    List scopeList;
    List attList;

    ServiceDeregistration(ServiceURL serviceURL, List scopes, List attributes, Locale theLocale) {
        this.funcID = (byte)4;
        this.locale = theLocale;
        if (serviceURL == null) {
            throw new IllegalArgumentException("serviceURL must not be null");
        }
        this.url = serviceURL;
        this.scopeList = scopes;
        if (this.scopeList == null) {
            this.scopeList = Arrays.asList("default");
        }
        this.attList = attributes;
        if (this.attList == null) {
            this.attList = new ArrayList();
        }
    }

    public ServiceDeregistration(DataInputStream input) throws ServiceLocationException, IOException {
        this.scopeList = ServiceDeregistration.stringToList(input.readUTF(), ",");
        this.url = ServiceURL.fromBytes(input);
        this.attList = ServiceDeregistration.stringToList(input.readUTF(), ",");
        if (SLPCore.CONFIG.getSecurityEnabled() && !this.verify()) {
            throw new ServiceLocationException(7, "Authentication failed for " + this.toString());
        }
    }

    protected void writeTo(DataOutputStream out) throws IOException {
        super.writeHeader(out, this.getSize());
        out.writeUTF(ServiceDeregistration.listToString(this.scopeList, ","));
        this.url.writeTo(out);
        out.writeUTF(ServiceDeregistration.listToString(this.attList, ","));
    }

    int getSize() {
        return this.getHeaderSize() + 2 + ServiceDeregistration.listToString(this.scopeList, ",").length() + this.url.getLength() + 2 + ServiceDeregistration.listToString(this.attList, ",").length();
    }

    void sign(List spiList) throws ServiceLocationException {
        this.url.sign(spiList);
    }

    boolean verify() throws ServiceLocationException {
        return this.url.verify();
    }
}

