/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provisional.docshare.cola;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provisional.docshare.DocShare;
import org.eclipse.ecf.internal.provisional.docshare.SynchronizationStrategy;
import org.eclipse.ecf.internal.provisional.docshare.cola.ColaUpdateMessage;
import org.eclipse.ecf.internal.provisional.docshare.messages.UpdateMessage;
import org.eclipse.osgi.util.NLS;

public class ColaSynchronizer
implements SynchronizationStrategy {
    private final LinkedList unacknowledgedLocalOperations;
    private final boolean isInitiator;
    private long localOperationsCount;
    private long remoteOperationsCount;
    private static Map sessionStrategies = new HashMap();

    private ColaSynchronizer(DocShare docshare) {
        this.isInitiator = docshare.isInitiator();
        this.unacknowledgedLocalOperations = new LinkedList();
        this.localOperationsCount = 0L;
        this.remoteOperationsCount = 0L;
    }

    public static ColaSynchronizer getInstanceFor(DocShare docshare) {
        if (sessionStrategies.get((Object)docshare) == null) {
            sessionStrategies.put(docshare, new ColaSynchronizer(docshare));
        }
        return (ColaSynchronizer)sessionStrategies.get((Object)docshare);
    }

    public static void cleanUpFor(DocShare docshare) {
        sessionStrategies.remove((Object)docshare);
    }

    public UpdateMessage registerOutgoingMessage(UpdateMessage localMsg) {
        Trace.entering((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/entering", this.getClass(), (String)"registerOutgoingMessage", (Object)localMsg);
        ColaUpdateMessage colaMsg = new ColaUpdateMessage(localMsg, this.localOperationsCount, this.remoteOperationsCount);
        if (!colaMsg.isReplacement()) {
            this.unacknowledgedLocalOperations.add(colaMsg);
            ++this.localOperationsCount;
        }
        Trace.exiting((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/exiting", this.getClass(), (String)"registerOutgoingMessage", (Object)colaMsg);
        return colaMsg;
    }

    public List transformIncomingMessage(UpdateMessage remoteMsg) {
        ColaUpdateMessage firstOp;
        if (!(remoteMsg instanceof ColaUpdateMessage)) {
            throw new IllegalArgumentException("UpdateMessage is incompatible with Cola SynchronizationStrategy");
        }
        Trace.entering((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/entering", this.getClass(), (String)"transformIncomingMessage", (Object)remoteMsg);
        ColaUpdateMessage transformedRemote = (ColaUpdateMessage)remoteMsg;
        LinkedList<ColaUpdateMessage> transformedRemotes = new LinkedList<ColaUpdateMessage>();
        transformedRemotes.add(transformedRemote);
        ++this.remoteOperationsCount;
        if (!this.unacknowledgedLocalOperations.isEmpty()) {
            Iterator it = this.unacknowledgedLocalOperations.iterator();
            while (it.hasNext()) {
                ColaUpdateMessage unackedLocalOp = (ColaUpdateMessage)it.next();
                if (transformedRemote.getRemoteOperationsCount() > unackedLocalOp.getLocalOperationsCount()) {
                    Trace.trace((String)"org.eclipse.ecf.internal.provisional.docshare", (String)NLS.bind((String)"transformIncomingMessage.removing {0}", (Object)unackedLocalOp));
                    it.remove();
                    continue;
                }
                Trace.trace((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"breaking out of unackedLocalOperations loop");
                break;
            }
            if (!this.unacknowledgedLocalOperations.isEmpty()) {
                ColaUpdateMessage localOp = (ColaUpdateMessage)this.unacknowledgedLocalOperations.getFirst();
                Assert.isTrue((transformedRemote.getRemoteOperationsCount() == localOp.getLocalOperationsCount() ? 1 : 0) != 0);
                ListIterator unackOpsListIt = this.unacknowledgedLocalOperations.listIterator();
                while (unackOpsListIt.hasNext()) {
                    ListIterator trafoRemotesIt = transformedRemotes.listIterator();
                    while (trafoRemotesIt.hasNext()) {
                        localOp = (ColaUpdateMessage)unackOpsListIt.next();
                        transformedRemote = (ColaUpdateMessage)trafoRemotesIt.next();
                        if ((transformedRemote = transformedRemote.transformAgainst(localOp, this.isInitiator)).isSplitUp()) {
                            trafoRemotesIt.remove();
                            Iterator splitUpIterator = transformedRemote.getSplitUpRepresentation().iterator();
                            while (splitUpIterator.hasNext()) {
                                trafoRemotesIt.add(splitUpIterator.next());
                            }
                        }
                        if (!localOp.isSplitUp()) continue;
                        unackOpsListIt.remove();
                        Iterator splitUpOpIterator = localOp.getSplitUpRepresentation().iterator();
                        while (splitUpOpIterator.hasNext()) {
                            unackOpsListIt.add(splitUpOpIterator.next());
                        }
                    }
                }
            }
        }
        Trace.exiting((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/exiting", this.getClass(), (String)"transformIncomingMessage", (Object)transformedRemote);
        if (transformedRemotes.size() > 1 && (firstOp = (ColaUpdateMessage)transformedRemotes.get(0)).isDeletion()) {
            ListIterator deletionFinalizerIt = transformedRemotes.listIterator();
            ColaUpdateMessage previousDel = (ColaUpdateMessage)deletionFinalizerIt.next();
            while (deletionFinalizerIt.hasNext()) {
                ColaUpdateMessage currentDel = (ColaUpdateMessage)deletionFinalizerIt.next();
                currentDel.setOffset(currentDel.getOffset() - previousDel.getLengthOfReplacedText());
                previousDel = currentDel;
            }
        }
        return transformedRemotes;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ColaSynchronizer");
        return buf.toString();
    }
}

