/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.clients;

import java.util.Map;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.example.clients.IMessageReceiver;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.IPresenceListener;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageEvent;
import org.eclipse.ecf.presence.im.IChatMessageSender;

public class XMPPChatClient {
    protected static String CONTAINER_TYPE = "ecf.xmpp.smack";
    Namespace namespace = null;
    IContainer container = null;
    IPresenceContainerAdapter presence = null;
    IChatMessageSender sender = null;
    ID userID = null;
    IMessageReceiver receiver = null;
    IPresenceListener presenceListener = null;
    static /* synthetic */ Class class$0;

    public XMPPChatClient() {
        this(null);
    }

    public XMPPChatClient(IMessageReceiver receiver) {
        this.setMessageReceiver(receiver);
    }

    public XMPPChatClient(IMessageReceiver receiver, IPresenceListener presenceListener) {
        this(receiver);
        this.setPresenceListener(presenceListener);
    }

    protected void setMessageReceiver(IMessageReceiver receiver) {
        this.receiver = receiver;
    }

    protected void setPresenceListener(IPresenceListener listener) {
        this.presenceListener = listener;
    }

    public IContainer setupContainer() throws ECFException {
        if (this.container == null) {
            this.container = ContainerFactory.getDefault().createContainer(CONTAINER_TYPE);
            this.namespace = this.container.getConnectNamespace();
        }
        return this.container;
    }

    public IContainer getContainer() {
        return this.container;
    }

    protected Namespace getConnectNamespace() {
        return this.namespace;
    }

    public void setupPresence() throws ECFException {
        if (this.presence == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.presence.IPresenceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.presence = (IPresenceContainerAdapter)this.container.getAdapter((Class)clazz);
            this.sender = this.presence.getChatManager().getChatMessageSender();
            this.presence.getChatManager().addMessageListener(new IIMMessageListener(){

                public void handleMessageEvent(IIMMessageEvent messageEvent) {
                    if (messageEvent instanceof IChatMessageEvent) {
                        IChatMessage m = ((IChatMessageEvent)messageEvent).getChatMessage();
                        if (XMPPChatClient.this.receiver != null) {
                            XMPPChatClient.this.receiver.handleMessage(m);
                        }
                    }
                }
            });
            if (this.presenceListener != null) {
                this.presence.getRosterManager().addPresenceListener(this.presenceListener);
            }
        }
    }

    public void connect(String account, String password) throws ECFException {
        this.setupContainer();
        this.setupPresence();
        this.doConnect(account, password);
    }

    public void doConnect(String account, String password) throws ECFException {
        ID targetID = IDFactory.getDefault().createID(this.namespace, account);
        this.container.connect(targetID, ConnectContextFactory.createPasswordConnectContext((String)password));
        this.userID = this.createID(account);
    }

    public ID createID(String name) {
        try {
            return IDFactory.getDefault().createID(this.namespace, name);
        }
        catch (IDCreateException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendChat(String jid, String msg) {
        if (this.sender != null) {
            try {
                this.sender.sendChatMessage(this.createID(jid), msg);
            }
            catch (ECFException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendProperties(String jid, Map properties) {
        if (this.sender != null) {
            try {
                this.sender.sendChatMessage(this.createID(jid), null, IChatMessage.Type.CHAT, null, null, properties);
            }
            catch (ECFException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean isConnected() {
        if (this.container == null) {
            return false;
        }
        return this.container.getConnectedID() != null;
    }

    public synchronized void close() {
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
            this.presence = null;
            this.sender = null;
            this.receiver = null;
            this.userID = null;
        }
    }
}

