/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.share.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConfig;
import org.eclipse.ecf.core.sharedobject.ReplicaSharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.example.collab.share.SharedObjectMsg;
import org.eclipse.ecf.example.collab.share.TransactionSharedObject;
import org.eclipse.ecf.example.collab.share.io.FileData;
import org.eclipse.ecf.example.collab.share.io.FileTransferListener;
import org.eclipse.ecf.example.collab.share.io.FileTransferParams;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.osgi.util.NLS;

public class FileTransferSharedObject
extends TransactionSharedObject {
    public static final int DEFAULT_START_WAIT_INTERVAL = 5000;
    private static final String HANDLEDATA_MSG = "handleData";
    private static final String HANDLEDONE_MSG = "handleDone";
    private static final String STARTSENDTOALL_MSG = "startSendToAll";
    private static final String START_MSG = "start";
    protected FileTransferParams transferParams;
    protected FileTransferListener progressListener;
    protected ID targetReceiver;
    protected InputStream inputStream;
    protected OutputStream outputStream;
    protected long dataWritten = -1L;

    public FileTransferSharedObject(InputStream ins, FileTransferParams params) {
        this(null, ins, params);
    }

    public FileTransferSharedObject(InputStream ins) {
        this(null, ins, null);
    }

    public FileTransferSharedObject(FileTransferParams params) {
        this.transferParams = params == null ? new FileTransferParams() : params;
        this.progressListener = this.transferParams.getProgressListener();
    }

    public FileTransferSharedObject(ID receiver, InputStream ins, FileTransferParams params) {
        this.targetReceiver = receiver;
        Assert.isNotNull((Object)ins);
        if (ins == null) {
            throw new NullPointerException(Messages.FileTransferSharedObject_EXCEPTION_INPUTSTREAM_NOT_NULL);
        }
        this.setInputStream(ins);
        this.transferParams = params == null ? new FileTransferParams() : params;
        this.progressListener = this.transferParams.getProgressListener();
    }

    public FileTransferSharedObject() {
    }

    protected void setInputStream(InputStream src) {
        this.inputStream = src;
    }

    protected void addRemoteParticipants(ID[] ids) {
        if (ids != null && this.participantIDs != null) {
            int i = 0;
            while (i < ids.length) {
                if (this.targetReceiver == null) {
                    if (!this.getHomeContainerID().equals((Object)ids[i])) {
                        this.participantIDs.addElement(ids[i]);
                    }
                } else if (this.targetReceiver.equals((Object)ids[i])) {
                    this.participantIDs.addElement(ids[i]);
                }
                ++i;
            }
        }
    }

    protected void setOutputStream(OutputStream src) {
        this.outputStream = src;
    }

    public void activated(ID[] others) {
        try {
            if (!this.isHost() && !this.getContext().isGroupManager()) {
                if (this.progressListener != null) {
                    this.progressListener.receiveStart(this, this.transferParams.getRemoteFile(), this.transferParams.getLength(), this.transferParams.getRate());
                }
                this.openOutputFile();
                if (this.transferParams.getLength() != -1L) {
                    this.dataWritten = 0L;
                }
            } else if (this.progressListener != null) {
                this.progressListener.sendStart(this, this.transferParams.getLength(), this.transferParams.getRate());
            }
        }
        catch (Exception e) {
            try {
                this.getContext().sendCreateResponse(this.getHomeContainerID(), (Throwable)e, FileTransferSharedObject.getNextReplicateID());
            }
            catch (Exception e1) {
                this.log("Exception sending failure back to host", e1);
            }
            return;
        }
        super.activated(others);
    }

    protected void openOutputFile() throws IOException {
        File aFile = this.transferParams.getRemoteFile();
        if (aFile == null) {
            throw new IOException(Messages.FileTransferSharedObject_EXCEPTION_REMOTE_FILE_NOT_NULL);
        }
        if (this.getContext().isGroupManager() && !this.transferParams.getIncludeServer()) {
            this.setOutputStream(null);
        } else {
            try {
                String parent = aFile.getParent();
                if (parent != null && new File(parent).mkdirs()) {
                    // empty if block
                }
            }
            catch (Exception ex) {
                this.log(NLS.bind((String)"Exception creating local directory for ", (Object)aFile), ex);
            }
            this.setOutputStream(new BufferedOutputStream(new FileOutputStream(aFile)));
        }
    }

    protected void replicate(ID remoteMember) {
        if (this.targetReceiver == null) {
            super.replicate(remoteMember);
            return;
        }
        if (remoteMember == null) {
            try {
                ReplicaSharedObjectDescription createInfo = this.getReplicaDescription(this.targetReceiver);
                if (createInfo != null) {
                    this.getContext().sendCreate(this.targetReceiver, createInfo);
                    return;
                }
            }
            catch (IOException e) {
                this.log("Could not send createFail message", e);
            }
        }
    }

    public void init(ISharedObjectConfig config) throws SharedObjectInitException {
        super.init(config);
        Map map = config.getProperties();
        Object[] args = (Object[])map.get("args");
        if (args != null && args.length == 1) {
            this.transferParams = (FileTransferParams)args[0];
            this.progressListener = this.transferParams.getProgressListener();
        }
    }

    protected ReplicaSharedObjectDescription getReplicaDescription(ID remoteMember) {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        map.put("args", new Object[]{this.transferParams});
        return new ReplicaSharedObjectDescription(this.getClass(), this.getID(), this.getConfig().getHomeContainerID(), map, FileTransferSharedObject.getNextReplicateID());
    }

    protected boolean sendData(ID rcvr, FileData data) throws IOException {
        this.forwardMsgTo(rcvr, SharedObjectMsg.createMsg(HANDLEDATA_MSG, data));
        return data.isDone();
    }

    protected boolean sendChunk(ID rcvr) throws IOException {
        FileData data = new FileData(this.inputStream, this.transferParams.getChunkSize());
        int size = data.getDataSize();
        if (this.progressListener != null && size != -1) {
            this.progressListener.sendData(this, size);
        }
        return this.sendData(rcvr, data);
    }

    protected void handleData(FileData data) {
        this.preSaveData(data);
        int size = data.getDataSize();
        if (this.progressListener != null && size != -1) {
            this.progressListener.receiveData(this, size);
        }
        this.saveData(data);
    }

    protected void preSaveData(FileData data) {
    }

    protected void saveData(FileData data) {
        try {
            if (this.outputStream != null) {
                long len = this.transferParams.getLength();
                this.dataWritten += (long)data.getDataSize();
                if (len != -1L && this.dataWritten > len) {
                    throw new IOException(NLS.bind((String)Messages.FileTransferSharedObject_EXCEPTION_FILE_LARGER_THAN_LEN, (Object)String.valueOf(len)));
                }
                data.saveData(this.outputStream);
                this.outputStream.flush();
            }
        }
        catch (Exception e) {
            this.notifyExceptionOnSave(e);
            try {
                this.forwardMsgHome(SharedObjectMsg.createMsg(HANDLEDONE_MSG, e));
                this.hardClose();
            }
            catch (Exception e1) {
                this.log("Exception sending done msg back to host", e1);
            }
            if (this.progressListener != null) {
                this.progressListener.receiveDone(this, e);
            }
            return;
        }
        Exception except = null;
        if (data.isDone()) {
            try {
                this.hardClose();
            }
            catch (Exception e1) {
                except = e1;
                this.notifyExceptionOnClose(except);
            }
            if (this.progressListener != null) {
                this.progressListener.receiveDone(this, except);
            }
            try {
                this.forwardMsgHome(SharedObjectMsg.createMsg(HANDLEDONE_MSG, except));
            }
            catch (Exception e) {
                this.log("Exception sending done message home", e);
            }
            this.doneReceiving();
        }
    }

    protected void notifyExceptionOnSave(Throwable t) {
    }

    protected void notifyExceptionOnClose(Throwable t) {
    }

    public void doneReceiving() {
    }

    public void handleDone(Exception e) {
    }

    protected void preStartWaiting() {
    }

    protected void preStartSending() {
    }

    protected void preChunkSent() {
    }

    protected void chunkSent() {
    }

    protected void doneSending(Exception e) {
        if (this.progressListener != null) {
            this.progressListener.sendDone(this, e);
        }
    }

    protected void committed() {
        this.preStartWaiting();
        this.start();
    }

    protected void preWait() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        if (this.isHost()) {
            Date start = this.transferParams.getStartDate();
            if (start != null && start.after(new Date())) {
                try {
                    this.preWait();
                    FileTransferSharedObject fileTransferSharedObject = this;
                    synchronized (fileTransferSharedObject) {
                        this.wait(5000L);
                    }
                    this.sendSelf(SharedObjectMsg.createMsg(START_MSG));
                }
                catch (Exception exception) {}
            } else {
                this.preStartSending();
                this.startSendToAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSendToAll() {
        block7: {
            try {
                this.preChunkSent();
                boolean res = this.sendChunk(this.targetReceiver);
                this.chunkSent();
                if (!res) {
                    FileTransferSharedObject fileTransferSharedObject = this;
                    synchronized (fileTransferSharedObject) {
                        int waittime = this.transferParams.getWaitTime();
                        if (waittime <= 0) {
                            waittime = 10;
                        }
                        this.wait(waittime);
                    }
                    this.sendSelf(SharedObjectMsg.createMsg(STARTSENDTOALL_MSG));
                    break block7;
                }
                this.hardClose();
                this.doneSending(null);
            }
            catch (Exception e) {
                this.doneSending(e);
            }
        }
    }

    protected void hardClose() throws IOException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {}
            this.inputStream = null;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (Exception exception) {}
            this.outputStream = null;
        }
    }

    public void deactivated() {
        super.deactivated();
        try {
            this.hardClose();
        }
        catch (Exception exception) {}
    }
}

