/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.ui.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.internal.presence.ui.Activator;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterGroup;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.ui.menu.AbstractRosterMenuHandler;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.services.IServiceLocator;

public abstract class AbstractRosterMenuContributionItem
extends CompoundContributionItem {
    private static final String DEFAULT_TOP_MENU_NAME = "Share";
    protected static final IContributionItem[] NO_CONTRIBUTIONS = new IContributionItem[0];
    private static final String ROSTERCOMMAND_PREFIX = "org.eclipse.ecf.presence.ui.rosterCommand.";
    private static final List contributionItems = new ArrayList();
    private static final List handlerActivations = new ArrayList();
    private static int commandIdIndex = 0;
    private IServiceLocator serviceLocator;
    private IHandlerService handlerService;
    private ICommandService commandService;
    private String topMenuName = "Share";
    private ImageDescriptor topMenuImageDescriptor = Activator.getDefault().getImageRegistry().getDescriptor("collaboration");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected void setTopMenuName(String name) {
        this.topMenuName = name;
    }

    public void setTopMenuImageDescriptor(ImageDescriptor image) {
        this.topMenuImageDescriptor = image;
    }

    protected ImageDescriptor getTopMenuImageDescriptor() {
        return this.topMenuImageDescriptor;
    }

    private void initialize() {
        this.serviceLocator = PlatformUI.getWorkbench();
        Assert.isNotNull((Object)this.serviceLocator);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.handlerService = (IHandlerService)this.serviceLocator.getService((Class)clazz);
        Assert.isNotNull((Object)this.handlerService);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.commandService = (ICommandService)this.serviceLocator.getService((Class)clazz2);
        Assert.isNotNull((Object)this.commandService);
    }

    public AbstractRosterMenuContributionItem() {
        this.initialize();
    }

    public AbstractRosterMenuContributionItem(String id) {
        super(id);
        this.initialize();
    }

    protected IContributionItem[] createContributionItemsForRoster(IRoster roster) {
        Collection rosterItems = roster.getItems();
        ArrayList<IContributionItem> contributions = new ArrayList<IContributionItem>();
        Iterator i = rosterItems.iterator();
        while (i.hasNext()) {
            IRosterItem item = (IRosterItem)i.next();
            IContributionItem[] adds = null;
            if (item instanceof IRosterEntry) {
                adds = this.createContributionItemsForEntry((IRosterEntry)item);
            } else if (item instanceof IRosterGroup) {
                adds = this.createContributionItemsForGroup((IRosterGroup)item);
            }
            if (adds == null) continue;
            int j = 0;
            while (j < adds.length) {
                contributions.add(adds[j]);
                ++j;
            }
        }
        return contributions.toArray(new IContributionItem[0]);
    }

    protected IContributionItem[] createContributionItemsForGroup(IRosterGroup group) {
        Collection entries = group.getEntries();
        MenuManager menuManager = null;
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            IRosterEntry entry = (IRosterEntry)i.next();
            IContributionItem[] menuContributions = this.createContributionItemsForEntry(entry);
            if (menuContributions == null || menuContributions.length <= 0) continue;
            int j = 0;
            while (j < menuContributions.length) {
                if (menuManager == null) {
                    menuManager = this.createMenuManagerForGroup(group);
                }
                menuManager.add(menuContributions[j]);
                ++j;
            }
        }
        if (menuManager != null) {
            return new IContributionItem[]{menuManager};
        }
        return NO_CONTRIBUTIONS;
    }

    protected MenuManager createMenuManagerForGroup(IRosterGroup group) {
        return new MenuManager(group.getName());
    }

    protected IContributionItem[] createContributionItemsForPresenceContainer(IPresenceContainerAdapter presenceContainerAdapter) {
        IRoster roster = presenceContainerAdapter.getRosterManager().getRoster();
        IContributionItem[] contributions = this.createContributionItemsForRoster(roster);
        if (contributions == null || contributions.length == 0) {
            return NO_CONTRIBUTIONS;
        }
        MenuManager menuManager = this.createMenuManagerForRoster(roster);
        int i = 0;
        while (i < contributions.length) {
            menuManager.add(contributions[i]);
            ++i;
        }
        return new IContributionItem[]{menuManager};
    }

    protected MenuManager createMenuManagerForRoster(IRoster roster) {
        return new MenuManager(roster.getUser().getName());
    }

    private int getNextCommandIdIndex() {
        return commandIdIndex++;
    }

    protected abstract AbstractRosterMenuHandler createRosterEntryHandler(IRosterEntry var1);

    protected boolean addEntry(IRosterEntry entry) {
        IPresence presence = entry.getPresence();
        if (presence == null) {
            return false;
        }
        return presence.getType().equals((Object)IPresence.Type.AVAILABLE) && presence.getMode().equals((Object)IPresence.Mode.AVAILABLE);
    }

    protected IContributionItem[] createContributionItemsForEntry(IRosterEntry entry) {
        if (this.addEntry(entry)) {
            AbstractRosterMenuHandler drh;
            String commandId = ROSTERCOMMAND_PREFIX + this.getNextCommandIdIndex();
            Command command = this.commandService.getCommand(commandId);
            command.define(commandId, null, this.commandService.getCategory(String.valueOf(commandId) + ".c"));
            IHandler handler = command.getHandler();
            if (handler != null && handler instanceof AbstractRosterMenuHandler && (drh = (AbstractRosterMenuHandler)handler) != null) {
                drh.fireHandlerChangeEvent();
                drh.dispose();
            }
            AbstractRosterMenuHandler newHandler = this.createRosterEntryHandler(entry);
            command.setHandler((IHandler)newHandler);
            handlerActivations.add(this.handlerService.activateHandler(commandId, (IHandler)newHandler));
            return new IContributionItem[]{this.createCommandContributionItemForEntry(commandId, entry)};
        }
        return NO_CONTRIBUTIONS;
    }

    protected ImageDescriptor getRosterEntryImageDescriptor(IRosterEntry entry) {
        IPresence p = entry.getPresence();
        if (p != null) {
            IPresence.Type pType = p.getType();
            IPresence.Mode pMode = p.getMode();
            if (pType.equals((Object)IPresence.Type.AVAILABLE)) {
                if (pMode.equals((Object)IPresence.Mode.AVAILABLE)) {
                    return SharedImages.getImageDescriptor((String)"IMG_USER_AVAILABLE");
                }
                if (pMode.equals((Object)IPresence.Mode.AWAY) || pMode.equals((Object)IPresence.Mode.EXTENDED_AWAY)) {
                    return SharedImages.getImageDescriptor((String)"IMG_USER_AWAY");
                }
                if (pMode.equals((Object)IPresence.Mode.DND)) {
                    return SharedImages.getImageDescriptor((String)"IMG_USER_DND");
                }
            }
        }
        return SharedImages.getImageDescriptor((String)"IMG_USER_UNAVAILABLE");
    }

    protected CommandContributionItem createCommandContributionItemForEntry(String commandId, IRosterEntry rosterEntry) {
        return new CommandContributionItem(this.serviceLocator, null, commandId, new HashMap(), this.getRosterEntryImageDescriptor(rosterEntry), null, null, rosterEntry.getName(), null, null, 8);
    }

    public void dispose() {
        super.dispose();
        contributionItems.clear();
        if (this.handlerService != null) {
            this.handlerService.deactivateHandlers((Collection)handlerActivations);
            this.handlerService = null;
        }
        handlerActivations.clear();
        this.commandService = null;
    }

    protected void clearOldContributions() {
        contributionItems.clear();
        this.handlerService.deactivateHandlers((Collection)handlerActivations);
    }

    protected List getPresenceContainerAdapters() {
        ArrayList<IPresenceContainerAdapter> presenceContainers = new ArrayList<IPresenceContainerAdapter>();
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        if (containerManager == null) {
            return presenceContainers;
        }
        IContainer[] containers = containerManager.getAllContainers();
        int i = 0;
        while (i < containers.length) {
            IContainer iContainer = containers[i];
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ecf.presence.IPresenceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IPresenceContainerAdapter presenceContainerAdapter = (IPresenceContainerAdapter)iContainer.getAdapter((Class)clazz);
            if (containers[i].getConnectedID() != null && presenceContainerAdapter != null) {
                presenceContainers.add(presenceContainerAdapter);
            }
            ++i;
        }
        return presenceContainers;
    }

    protected IContributionItem[] getContributionItems() {
        IContributionItem[] items;
        this.clearOldContributions();
        List presenceContainers = this.getPresenceContainerAdapters();
        if (presenceContainers.size() == 0) {
            return NO_CONTRIBUTIONS;
        }
        ArrayList<IContributionItem> contributions = new ArrayList<IContributionItem>();
        Iterator i = presenceContainers.iterator();
        while (i.hasNext()) {
            items = this.createContributionItemsForPresenceContainer((IPresenceContainerAdapter)i.next());
            int j = 0;
            while (j < items.length) {
                contributions.add(items[j]);
                ++j;
            }
        }
        if (contributions.size() > 0) {
            MenuManager menuManager = this.createMenuManagerForTop();
            items = contributions.toArray(new IContributionItem[0]);
            int i2 = 0;
            while (i2 < items.length) {
                menuManager.add(items[i2]);
                ++i2;
            }
            return new IContributionItem[]{new Separator(), menuManager};
        }
        return NO_CONTRIBUTIONS;
    }

    protected MenuManager createMenuManagerForTop() {
        return new MenuManager(this.topMenuName);
    }
}

