/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.debugger;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.debugger.EnhancedDebugger;

public class EnhancedDebuggerWindow {
    private static EnhancedDebuggerWindow instance;
    private static ImageIcon connectionCreatedIcon;
    private static ImageIcon connectionActiveIcon;
    private static ImageIcon connectionClosedIcon;
    private static ImageIcon connectionClosedOnErrorIcon;
    public static boolean PERSISTED_DEBUGGER;
    public static int MAX_TABLE_ROWS;
    private JFrame frame;
    private JTabbedPane tabbedPane;
    private List debuggers;
    static /* synthetic */ Class class$0;

    static {
        PERSISTED_DEBUGGER = false;
        MAX_TABLE_ROWS = 150;
    }

    private EnhancedDebuggerWindow() {
        URL url = Thread.currentThread().getContextClassLoader().getResource("images/trafficlight_off.png");
        if (url != null) {
            connectionCreatedIcon = new ImageIcon(url);
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource("images/trafficlight_green.png")) != null) {
            connectionActiveIcon = new ImageIcon(url);
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource("images/trafficlight_red.png")) != null) {
            connectionClosedIcon = new ImageIcon(url);
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource("images/warning.png")) != null) {
            connectionClosedOnErrorIcon = new ImageIcon(url);
        }
        this.frame = null;
        this.tabbedPane = null;
        this.debuggers = new ArrayList();
    }

    public static EnhancedDebuggerWindow getInstance() {
        if (instance == null) {
            instance = new EnhancedDebuggerWindow();
        }
        return instance;
    }

    static synchronized void addDebugger(EnhancedDebugger debugger) {
        EnhancedDebuggerWindow.getInstance().showNewDebugger(debugger);
    }

    private void showNewDebugger(EnhancedDebugger debugger) {
        if (this.frame == null) {
            this.createDebug();
        }
        debugger.tabbedPane.setName("Connection_" + this.tabbedPane.getComponentCount());
        this.tabbedPane.add((Component)debugger.tabbedPane, this.tabbedPane.getComponentCount() - 1);
        this.tabbedPane.setIconAt(this.tabbedPane.indexOfComponent(debugger.tabbedPane), connectionCreatedIcon);
        this.frame.setTitle("Smack Debug Window -- Total connections: " + (this.tabbedPane.getComponentCount() - 1));
        this.debuggers.add(debugger);
    }

    static synchronized void userHasLogged(EnhancedDebugger debugger, String user) {
        int index = EnhancedDebuggerWindow.getInstance().tabbedPane.indexOfComponent(debugger.tabbedPane);
        EnhancedDebuggerWindow.getInstance().tabbedPane.setTitleAt(index, user);
        EnhancedDebuggerWindow.getInstance().tabbedPane.setIconAt(index, connectionActiveIcon);
    }

    static synchronized void connectionClosed(EnhancedDebugger debugger) {
        EnhancedDebuggerWindow.getInstance().tabbedPane.setIconAt(EnhancedDebuggerWindow.getInstance().tabbedPane.indexOfComponent(debugger.tabbedPane), connectionClosedIcon);
    }

    static synchronized void connectionClosedOnError(EnhancedDebugger debugger, Exception e) {
        int index = EnhancedDebuggerWindow.getInstance().tabbedPane.indexOfComponent(debugger.tabbedPane);
        EnhancedDebuggerWindow.getInstance().tabbedPane.setToolTipTextAt(index, "Connection closed due to the exception: " + e.getMessage());
        EnhancedDebuggerWindow.getInstance().tabbedPane.setIconAt(index, connectionClosedOnErrorIcon);
    }

    private void createDebug() {
        this.frame = new JFrame("Smack Debug Window");
        if (!PERSISTED_DEBUGGER) {
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    EnhancedDebuggerWindow.this.rootWindowClosing(evt);
                }
            });
        }
        this.tabbedPane = new JTabbedPane();
        JPanel informationPanel = new JPanel();
        informationPanel.setLayout(new BoxLayout(informationPanel, 1));
        JPanel versionPanel = new JPanel();
        versionPanel.setLayout(new BoxLayout(versionPanel, 0));
        versionPanel.setMaximumSize(new Dimension(2000, 31));
        versionPanel.add(new JLabel(" Smack version: "));
        JFormattedTextField field = new JFormattedTextField((Object)SmackConfiguration.getVersion());
        field.setEditable(false);
        field.setBorder(null);
        versionPanel.add(field);
        informationPanel.add(versionPanel);
        JPanel iqProvidersPanel = new JPanel();
        iqProvidersPanel.setLayout(new GridLayout(1, 1));
        iqProvidersPanel.setBorder(BorderFactory.createTitledBorder("Installed IQ Providers"));
        Vector<String> providers = new Vector<String>();
        Iterator it = ProviderManager.getIQProviders();
        while (it.hasNext()) {
            Object provider = it.next();
            Class<?> clazz = provider.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                providers.add(((Class)provider).getName());
                continue;
            }
            providers.add(provider.getClass().getName());
        }
        Collections.sort(providers);
        JList list = new JList(providers);
        iqProvidersPanel.add(new JScrollPane(list));
        informationPanel.add(iqProvidersPanel);
        JPanel extensionProvidersPanel = new JPanel();
        extensionProvidersPanel.setLayout(new GridLayout(1, 1));
        extensionProvidersPanel.setBorder(BorderFactory.createTitledBorder("Installed Extension Providers"));
        providers = new Vector();
        Iterator it2 = ProviderManager.getExtensionProviders();
        while (it2.hasNext()) {
            Object provider = it2.next();
            Class<?> clazz = provider.getClass();
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz3) {
                providers.add(((Class)provider).getName());
                continue;
            }
            providers.add(provider.getClass().getName());
        }
        Collections.sort(providers);
        list = new JList(providers);
        extensionProvidersPanel.add(new JScrollPane(list));
        informationPanel.add(extensionProvidersPanel);
        this.tabbedPane.add("Smack Info", informationPanel);
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Close");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EnhancedDebuggerWindow.this.tabbedPane.getSelectedIndex() < EnhancedDebuggerWindow.this.tabbedPane.getComponentCount() - 1) {
                    int index = EnhancedDebuggerWindow.this.tabbedPane.getSelectedIndex();
                    EnhancedDebugger debugger = (EnhancedDebugger)EnhancedDebuggerWindow.this.debuggers.get(index);
                    debugger.cancel();
                    EnhancedDebuggerWindow.this.tabbedPane.remove(debugger.tabbedPane);
                    EnhancedDebuggerWindow.this.debuggers.remove(debugger);
                    EnhancedDebuggerWindow.this.frame.setTitle("Smack Debug Window -- Total connections: " + (EnhancedDebuggerWindow.this.tabbedPane.getComponentCount() - 1));
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Close All Not Active");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EnhancedDebugger debugger;
                ArrayList<EnhancedDebugger> debuggersToRemove = new ArrayList<EnhancedDebugger>();
                int index = 0;
                while (index < EnhancedDebuggerWindow.this.tabbedPane.getComponentCount() - 1) {
                    debugger = (EnhancedDebugger)EnhancedDebuggerWindow.this.debuggers.get(index);
                    if (!debugger.isConnectionActive()) {
                        debugger.cancel();
                        debuggersToRemove.add(debugger);
                    }
                    ++index;
                }
                Iterator it = debuggersToRemove.iterator();
                while (it.hasNext()) {
                    debugger = (EnhancedDebugger)it.next();
                    EnhancedDebuggerWindow.this.tabbedPane.remove(debugger.tabbedPane);
                    EnhancedDebuggerWindow.this.debuggers.remove(debugger);
                }
                EnhancedDebuggerWindow.this.frame.setTitle("Smack Debug Window -- Total connections: " + (EnhancedDebuggerWindow.this.tabbedPane.getComponentCount() - 1));
            }
        });
        menu.add(menuItem);
        this.tabbedPane.addMouseListener(new PopupListener(menu));
        this.frame.getContentPane().add(this.tabbedPane);
        this.frame.setSize(650, 400);
        if (!PERSISTED_DEBUGGER) {
            this.frame.setVisible(true);
        }
    }

    public void rootWindowClosing(WindowEvent evt) {
        Iterator it = this.debuggers.iterator();
        while (it.hasNext()) {
            EnhancedDebugger debugger = (EnhancedDebugger)it.next();
            debugger.cancel();
        }
        this.debuggers.removeAll(this.debuggers);
        instance = null;
    }

    public void setVisible(boolean visible) {
        if (this.frame != null) {
            this.frame.setVisible(visible);
        }
    }

    public boolean isVisible() {
        if (this.frame != null) {
            return this.frame.isVisible();
        }
        return false;
    }

    private class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

