/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.util.StringUtils;
import org.eclipse.ecf.example.collab.share.io.FileTransferParams;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;
import org.eclipse.ecf.internal.example.collab.ui.ChatDropTarget;
import org.eclipse.ecf.internal.example.collab.ui.ChatLine;
import org.eclipse.ecf.internal.example.collab.ui.ChatWindow;
import org.eclipse.ecf.internal.example.collab.ui.LineChatClientView;
import org.eclipse.ecf.internal.example.collab.ui.MessageLoader;
import org.eclipse.ecf.internal.example.collab.ui.TreeDropTarget;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.im.IChatManager;
import org.eclipse.ecf.presence.ui.MessagesView;
import org.eclipse.ecf.ui.screencapture.IImageSender;
import org.eclipse.ecf.ui.screencapture.ScreenCaptureJob;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ChatComposite
extends Composite {
    private static final String CHAT_OUTPUT_FONT = "ChatFont";
    final LineChatClientView view;
    private Color meColor = null;
    private Color otherColor = null;
    private Color systemColor = null;
    Action appShare = null;
    Action coBrowseURL = null;
    Action outputClear = null;
    Action outputCopy = null;
    Action outputPaste = null;
    Action outputSelectAll = null;
    Action sendFileToGroup = null;
    Action sendFileToGroupAndLaunch = null;
    Action sendMessage = null;
    Action closeGroup = null;
    Action sendShowViewRequest = null;
    Action showChatWindow;
    protected final String TEXT_INPUT_INIT = MessageLoader.getString("LineChatClientView.textinputinit");
    protected static final int DEFAULT_INPUT_HEIGHT = 25;
    protected static final int DEFAULT_INPUT_SEPARATOR = 5;
    Text textinput = null;
    StyledText textoutput = null;
    TableViewer tableView = null;
    ChatDropTarget chatDropTarget = null;
    TreeDropTarget treeDropTarget = null;
    ChatWindow chatWindow;
    boolean typing;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    ChatComposite(LineChatClientView view, Composite parent, TableViewer table, String initText) {
        this(view, parent, table, initText, null);
    }

    ChatComposite(LineChatClientView view, Composite parent, TableViewer table, String initText, ChatWindow chatWindow) {
        super(parent, 0);
        this.view = view;
        this.chatWindow = chatWindow;
        this.setLayout((Layout)new FillLayout());
        this.meColor = this.colorFromRGBString(ClientPlugin.getDefault().getPluginPreferences().getString("prefMeTextColor"));
        this.otherColor = this.colorFromRGBString(ClientPlugin.getDefault().getPluginPreferences().getString("prefOtherTextColor"));
        this.systemColor = this.colorFromRGBString(ClientPlugin.getDefault().getPluginPreferences().getString("prefSystemTextColor"));
        ClientPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new ColorPropertyChangeListener());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ChatComposite.this.meColor != null) {
                    ChatComposite.this.meColor.dispose();
                }
                if (ChatComposite.this.otherColor != null) {
                    ChatComposite.this.otherColor.dispose();
                }
                if (ChatComposite.this.systemColor != null) {
                    ChatComposite.this.systemColor.dispose();
                }
            }
        });
        Composite chattingComposite = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        chattingComposite.setLayout((Layout)layout);
        this.tableView = table;
        this.textoutput = this.createStyledTextWidget(chattingComposite);
        this.textoutput.setLayoutData((Object)new GridData(4, 4, true, true));
        String fontName = ClientPlugin.getDefault().getPluginPreferences().getString("chatFont");
        if (fontName != null && !fontName.equals("")) {
            FontRegistry fr = ClientPlugin.getDefault().getFontRegistry();
            FontData[] newFont = new FontData[]{new FontData(fontName)};
            fr.put(CHAT_OUTPUT_FONT, newFont);
            this.textoutput.setFont(fr.get(CHAT_OUTPUT_FONT));
        }
        ClientPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new FontPropertyChangeListener());
        this.textoutput.append(initText);
        this.textinput = new Text(chattingComposite, 2052);
        this.textinput.setText(this.TEXT_INPUT_INIT);
        GridData gd = new GridData(4, 0x1000000, true, false);
        GC gc = new GC((Drawable)this.textinput);
        gc.setFont(this.textinput.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        gd.heightHint = fontMetrics.getHeight() * 2;
        this.textinput.setLayoutData((Object)gd);
        this.textinput.selectAll();
        this.textinput.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent evt) {
                ChatComposite.this.handleKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                ChatComposite.this.handleKeyReleased(evt);
            }
        });
        this.textinput.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                String t = ChatComposite.this.textinput.getText();
                if (t.equals(ChatComposite.this.TEXT_INPUT_INIT)) {
                    ChatComposite.this.textinput.selectAll();
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.textinput.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                String t = ChatComposite.this.textinput.getText();
                if (t.equals(ChatComposite.this.TEXT_INPUT_INIT)) {
                    ChatComposite.this.textinput.selectAll();
                }
            }
        });
        this.textinput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ChatComposite.this.typing && ChatComposite.this.textinput.getText().trim().length() == 0) {
                    ChatComposite.this.typing = false;
                } else if (!ChatComposite.this.typing) {
                    ChatComposite.this.typing = true;
                    ChatComposite.this.view.lch.sendStartedTyping();
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.initializeDropTargets();
    }

    private StyledText createStyledTextWidget(Composite parent) {
        try {
            SourceViewer result = new SourceViewer(parent, null, null, true, 2634);
            result.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()));
            result.setDocument((IDocument)new Document());
            return result.getTextWidget();
        }
        catch (Exception e) {
            ClientPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.example.collab", 2, MessageLoader.getString("ChatComposite.NO_HYPERLINKING"), (Throwable)e));
            return new StyledText(parent, 2634);
        }
        catch (NoClassDefFoundError e) {
            ClientPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.example.collab", 2, MessageLoader.getString("ChatComposite.NO_HYPERLINKING"), (Throwable)e));
            return new StyledText(parent, 2634);
        }
    }

    public void appendText(ChatLine text) {
        String t;
        if (text == null || this.textoutput == null || this.textoutput.isDisposed()) {
            return;
        }
        IUser user = text.getOriginator();
        StyleRange range = new StyleRange();
        range.start = this.textoutput.getText().length();
        if (user != null) {
            String prefix = String.valueOf(user.getNickname()) + ": ";
            String date = text.getDate();
            if (date != null && !date.equals("")) {
                prefix = String.valueOf(date) + ' ' + prefix;
            }
            range.length = prefix.length();
            range.foreground = user.equals(this.view.userdata) ? this.meColor : this.otherColor;
            this.textoutput.append(prefix);
            this.textoutput.setStyleRange(range);
            this.textoutput.append(text.getText());
        } else {
            String content = text.getText();
            String date = text.getDate();
            if (date != null && !date.equals("")) {
                content = String.valueOf(date) + ' ' + content;
            }
            range.length = content.length();
            range.foreground = this.otherColor;
            this.textoutput.append(content);
        }
        if (!text.isNoCRLF()) {
            this.textoutput.append(Text.DELIMITER);
        }
        if ((t = this.textoutput.getText()) != null) {
            this.textoutput.setSelection(t.length());
        }
    }

    protected void clearInput() {
        this.textinput.setText("");
    }

    private void contributeToActionBars() {
        IActionBars bars = this.view.view.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
    }

    protected void copyFileLocally(String inputFile, String outputFile) throws IOException {
        File aFile = new File(outputFile);
        File dir = aFile.getParentFile();
        dir.mkdirs();
        BufferedInputStream ins = new BufferedInputStream(new FileInputStream(inputFile));
        byte[] buf = new byte[1024];
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(aFile));
        while (ins.read(buf) != -1) {
            bos.write(buf);
        }
        ins.close();
        bos.close();
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.chatWindow != null) {
            manager.add((IAction)this.showChatWindow);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.outputCopy);
        manager.add((IAction)this.outputPaste);
        manager.add((IAction)this.outputClear);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.outputSelectAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.sendFileToGroup);
        manager.add((IAction)this.coBrowseURL);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.sendMessage);
        manager.add((IAction)this.sendShowViewRequest);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.closeGroup);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalPullDown(IMenuManager manager) {
        if (this.chatWindow != null) {
            manager.add((IAction)this.showChatWindow);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.outputCopy);
        manager.add((IAction)this.outputPaste);
        manager.add((IAction)this.outputClear);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.outputSelectAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.sendFileToGroup);
        manager.add((IAction)this.coBrowseURL);
        manager.add((IAction)this.appShare);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.sendMessage);
        manager.add((IAction)this.sendShowViewRequest);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.closeGroup);
    }

    private void fillTreeContextMenu(IMenuManager manager) {
        IStructuredSelection iss = (IStructuredSelection)this.tableView.getSelection();
        Object element = iss.getFirstElement();
        if (element == null || !(element instanceof IUser)) {
            this.fillContextMenu(manager);
        } else {
            this.fillTreeContextMenuUser(manager, (IUser)element);
        }
    }

    private void sendImage(final IUser toUser) {
        if (MessageDialog.openQuestion(null, (String)MessageLoader.getString("ChatComposite.DIALOG_SCREEN_CAPTURE_TITLE"), (String)MessageLoader.getString("ChatComposite.DIALOG_SCREEN_CAPTURE_TEXT"))) {
            ScreenCaptureJob job = new ScreenCaptureJob(this.getDisplay(), toUser.getID(), toUser.getNickname(), new IImageSender(){

                public void sendImage(ID targetID, ImageData imageData) {
                    ChatComposite.this.view.lch.sendImage(toUser.getID(), imageData);
                }
            });
            job.schedule(5000L);
        }
    }

    private void fillTreeContextMenuUser(IMenuManager man, final IUser user) {
        boolean toUs = false;
        if (this.view.userdata != null && this.view.userdata.getID().equals((Object)user.getID())) {
            toUs = true;
        }
        if (!toUs) {
            Action sendImageToUser = new Action(){

                public void run() {
                    ChatComposite.this.sendImage(user);
                }
            };
            sendImageToUser.setText(NLS.bind((String)MessageLoader.getString("ChatComposite.SEND_SCREEN_CAPTURE_TEXT"), (Object)user.getNickname()));
            sendImageToUser.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            man.add((IAction)sendImageToUser);
            Action sendFileToUser = new Action(){

                public void run() {
                    ChatComposite.this.sendFileToUser(user, false);
                }
            };
            sendFileToUser.setText(NLS.bind((String)MessageLoader.getString("ChatComposite.SEND_FILE_TEXT"), (Object)user.getNickname()));
            sendFileToUser.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            sendFileToUser.setEnabled(false);
            man.add((IAction)sendFileToUser);
            Action sendFileToUserAndLaunch = new Action(){

                public void run() {
                    ChatComposite.this.sendFileToUser(user, true);
                }
            };
            sendFileToUserAndLaunch.setText(NLS.bind((String)MessageLoader.getString("ChatComposite.SEND_FILE_AND_LAUNCH_TEXT"), (Object)user.getNickname()));
            sendFileToUserAndLaunch.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            sendFileToUserAndLaunch.setEnabled(false);
            man.add((IAction)sendFileToUserAndLaunch);
            Action coBrowseToUser = new Action(){

                public void run() {
                    ChatComposite.this.sendCoBrowseToUser(user);
                }
            };
            coBrowseToUser.setText(NLS.bind((String)MessageLoader.getString("ChatComposite.COBROWSE_TEXT"), (Object)user.getNickname()));
            man.add((IAction)coBrowseToUser);
            man.add((IContributionItem)new Separator());
            man.add((IContributionItem)new Separator());
            Action ringUser = new Action(){

                public void run() {
                    ChatComposite.this.sendRingMessageToUser(user);
                }
            };
            ringUser.setText(NLS.bind((String)MessageLoader.getString("ChatComposite.RING_OTHER_TEXT"), (Object)user.getNickname()));
            man.add((IAction)ringUser);
            Action sendMessageToUser = new Action(){

                public void run() {
                    ChatComposite.this.sendPrivateTextMsg(user);
                }
            };
            sendMessageToUser.setText(NLS.bind((String)MessageLoader.getString("ChatComposite.SEND_PRIVATE_MESSAGE_TEXT"), (Object)user.getNickname()));
            man.add((IAction)sendMessageToUser);
            Action sendShowViewRequest = new Action(){

                public void run() {
                    ChatComposite.this.sendShowViewRequest(user);
                }
            };
            sendShowViewRequest.setText(NLS.bind((String)MessageLoader.getString("ChatComposite.SEND_SHOW_VIEW_REQUEST_TEXT"), (Object)user.getNickname()));
            man.add((IAction)sendShowViewRequest);
        } else {
            Action sendMessageToUser = new Action(){

                public void run() {
                    MessageDialog.openError(null, (String)(String.valueOf(MessageLoader.getString("ChatComposite.MESSAGE_TO_TITLE")) + user.getNickname()), (String)(String.valueOf(MessageLoader.getString("ChatComposite.MESSAGE_TO_TEXT")) + user.getNickname() + "\n\tID:  " + user.getID().getName()));
                }
            };
            sendMessageToUser.setText(MessageLoader.getString("ChatComposite.MENU_SEND_MESSAGE_TO_YOURSELF_TEXT"));
            man.add((IAction)sendMessageToUser);
        }
        man.add((IContributionItem)new Separator("additions"));
    }

    protected String[] getArgs(String aString) {
        StringTokenizer st = new StringTokenizer(aString);
        int argscount = st.countTokens() - 1;
        if (argscount < 1) {
            return null;
        }
        String[] newArray = new String[argscount];
        st.nextToken();
        int i = 0;
        while (st.hasMoreTokens()) {
            newArray[i++] = st.nextToken();
        }
        return newArray;
    }

    protected String getCommand(String aString) {
        StringTokenizer st = new StringTokenizer(aString);
        return st.nextToken();
    }

    private String getID(String title, String message, String initialValue) {
        InputDialog id = new InputDialog(this.view.view.getSite().getShell(), title, message, initialValue, null);
        id.setBlockOnOpen(true);
        int res = id.open();
        if (res == 0) {
            return id.getValue();
        }
        return null;
    }

    protected void handleEnter() {
        if (this.textinput.getText().trim().length() > 0) {
            this.view.handleTextInput(this.textinput.getText());
        }
        this.clearInput();
        this.typing = false;
    }

    protected void handleKeyPressed(KeyEvent evt) {
        if (evt.character == '\r') {
            this.handleEnter();
        } else if (evt.character == '\u001b' && this.chatWindow != null) {
            this.chatWindow.getShell().setVisible(false);
        }
    }

    protected void handleKeyReleased(KeyEvent evt) {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ChatComposite.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.textoutput);
        this.textoutput.setMenu(menu);
        ISelectionProvider selectionProvider = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                TextSelection selection = new TextSelection(ChatComposite.this.textoutput.getSelectionRange().x, ChatComposite.this.textoutput.getSelectionRange().y);
                return selection;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
                if (selection instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    ChatComposite.this.textoutput.setSelection(textSelection.getOffset(), textSelection.getOffset() + textSelection.getLength());
                }
            }
        };
        this.view.view.getSite().registerContextMenu(menuMgr, selectionProvider);
        MenuManager treeMenuMgr = new MenuManager();
        treeMenuMgr.setRemoveAllWhenShown(true);
        treeMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ChatComposite.this.fillTreeContextMenu(manager);
            }
        });
        Menu treeMenu = treeMenuMgr.createContextMenu(this.tableView.getControl());
        this.tableView.getControl().setMenu(treeMenu);
        this.view.view.getSite().registerContextMenu(treeMenuMgr, (ISelectionProvider)this.tableView);
    }

    protected Control getTreeControl() {
        return this.tableView.getControl();
    }

    protected Control getTextControl() {
        return this.textoutput;
    }

    protected void makeActions() {
        this.outputSelectAll = new Action(){

            public void run() {
                ChatComposite.this.outputSelectAll();
            }
        };
        this.outputSelectAll.setText(MessageLoader.getString("LineChatClientView.contextmenu.selectall"));
        this.outputSelectAll.setToolTipText(MessageLoader.getString("LineChatClientView.contextmenu.selectall.tooltip"));
        this.outputSelectAll.setAccelerator(262209);
        this.outputCopy = new Action(){

            public void run() {
                ChatComposite.this.outputCopy();
            }
        };
        this.outputCopy.setText(MessageLoader.getString("LineChatClientView.contextmenu.copy"));
        this.outputCopy.setToolTipText(MessageLoader.getString("LineChatClientView.contextmenu.copy.tooltip"));
        this.outputCopy.setAccelerator(262211);
        this.outputCopy.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.outputClear = new Action(){

            public void run() {
                ChatComposite.this.outputClear();
            }
        };
        this.outputClear.setText(MessageLoader.getString("LineChatClientView.contextmenu.clear"));
        this.outputClear.setToolTipText(MessageLoader.getString("LineChatClientView.contextmenu.clear.tooltip"));
        this.outputPaste = new Action(){

            public void run() {
                ChatComposite.this.outputPaste();
            }
        };
        this.outputPaste.setText(MessageLoader.getString("LineChatClientView.contextmenu.paste"));
        this.outputPaste.setToolTipText(MessageLoader.getString("LineChatClientView.contextmenu.paste.tooltip"));
        this.outputPaste.setAccelerator(262230);
        this.outputPaste.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        this.sendFileToGroup = new Action(){

            public void run() {
                ChatComposite.this.sendFileToGroup(false);
            }
        };
        this.sendFileToGroup.setText(MessageLoader.getString("LineChatClientView.contextmenu.sendfile"));
        this.sendFileToGroup.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.sendFileToGroup.setEnabled(false);
        this.coBrowseURL = new Action(){

            public void run() {
                ChatComposite.this.sendCoBrowseToUser(null);
            }
        };
        this.coBrowseURL.setText(MessageLoader.getString("LineChatClientView.contextmenu.cobrowse"));
        this.appShare = new Action(){

            public void run() {
            }
        };
        this.appShare.setText(MessageLoader.getString("LineChatClientView.contextmenu.appshare"));
        this.appShare.setEnabled(Platform.getOS().equalsIgnoreCase("win32"));
        this.sendMessage = new Action(){

            public void run() {
                ChatComposite.this.sendMessageToGroup();
            }
        };
        this.sendMessage.setText(MessageLoader.getString("LineChatClientView.contextmenu.sendmessage"));
        this.closeGroup = new Action(){

            public void run() {
                ChatComposite.this.closeProjectGroup(null);
            }
        };
        this.closeGroup.setText(MessageLoader.getString("LineChatClientView.contextmenu.leaveGroup"));
        this.closeGroup.setEnabled(true);
        this.sendShowViewRequest = new Action(){

            public void run() {
                ChatComposite.this.sendShowViewRequest(null);
            }
        };
        this.sendShowViewRequest.setText(MessageLoader.getString("LineChatClientView.contextmenu.sendShowViewRequest"));
        this.sendShowViewRequest.setEnabled(true);
        if (this.chatWindow != null) {
            this.showChatWindow = new Action(){

                public void run() {
                    ChatComposite.this.chatWindow.open();
                    if (!ChatComposite.this.chatWindow.hasFocus()) {
                        ChatComposite.this.chatWindow.getShell().forceActive();
                    }
                }
            };
            this.showChatWindow.setText(MessageLoader.getString("ChatComposite.SHOW_CHAT_WINDOW_TEXT"));
        }
    }

    protected void sendShowViewRequest(IUser touser) {
        int i;
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = ww.getActivePage();
        if (page == null) {
            return;
        }
        ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new LabelProvider(){
            private HashMap images = new HashMap();

            public Image getImage(Object element) {
                ImageDescriptor desc = null;
                if (element instanceof IViewCategory) {
                    desc = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
                } else if (element instanceof IViewDescriptor) {
                    desc = ((IViewDescriptor)element).getImageDescriptor();
                }
                if (desc == null) {
                    return null;
                }
                Image image = (Image)this.images.get(desc);
                if (image == null) {
                    image = desc.createImage();
                    this.images.put(desc, image);
                }
                return image;
            }

            public String getText(Object element) {
                String label = element instanceof IViewCategory ? ((IViewCategory)element).getLabel() : (element instanceof IViewDescriptor ? ((IViewDescriptor)element).getLabel() : super.getText(element));
                int i = label.indexOf(38);
                while (i >= 0 && i < label.length() - 1) {
                    if (!Character.isWhitespace(label.charAt(i + 1))) {
                        return String.valueOf(label.substring(0, i)) + label.substring(i + 1);
                    }
                    i = label.indexOf(38, i + 1);
                }
                return label;
            }

            public void dispose() {
                Iterator i = this.images.values().iterator();
                while (i.hasNext()) {
                    ((Image)i.next()).dispose();
                }
                this.images = null;
                super.dispose();
            }
        }, new ITreeContentProvider(){
            private HashMap parents = new HashMap();

            public Object[] getChildren(Object element) {
                if (element instanceof IViewRegistry) {
                    return ((IViewRegistry)element).getCategories();
                }
                if (element instanceof IViewCategory) {
                    Object[] children = ((IViewCategory)element).getViews();
                    int i = 0;
                    while (i < children.length) {
                        this.parents.put(children[i], element);
                        ++i;
                    }
                    return children;
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof IViewCategory) {
                    return PlatformUI.getWorkbench().getViewRegistry();
                }
                if (element instanceof IViewDescriptor) {
                    return this.parents.get(element);
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof IViewRegistry || element instanceof IViewCategory;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
                this.parents = null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.parents.clear();
            }
        });
        dlg.setTitle(MessageLoader.getString("LineChatClientView.contextmenu.sendShowViewRequest"));
        dlg.setMessage(MessageLoader.getString("LineChatClientView.contextmenu.sendShowViewRequest.dialog.title"));
        dlg.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof IViewDescriptor) || !"org.eclipse.ui.internal.introview".equals(((IViewDescriptor)element).getId());
            }
        });
        dlg.setComparator(new ViewerComparator());
        dlg.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                int i = 0;
                while (i < selection.length) {
                    if (!(selection[i] instanceof IViewDescriptor)) {
                        return new Status(4, ClientPlugin.getDefault().getBundle().getSymbolicName(), 0, "", null);
                    }
                    ++i;
                }
                return new Status(0, ClientPlugin.getDefault().getBundle().getSymbolicName(), 0, "", null);
            }
        });
        IViewRegistry reg = PlatformUI.getWorkbench().getViewRegistry();
        dlg.setInput((Object)reg);
        IDialogSettings dlgSettings = ClientPlugin.getDefault().getDialogSettings();
        IDialogSettings section = dlgSettings.getSection("SendShowViewRequestDialog");
        if (section == null) {
            section = dlgSettings.addNewSection("SendShowViewRequestDialog");
        } else {
            String[] selectedIDs = section.getArray("SELECTION");
            if (selectedIDs != null && selectedIDs.length > 0) {
                ArrayList<IViewDescriptor> list = new ArrayList<IViewDescriptor>(selectedIDs.length);
                i = 0;
                while (i < selectedIDs.length) {
                    IViewDescriptor desc = reg.find(selectedIDs[i]);
                    if (desc != null) {
                        list.add(desc);
                    }
                    ++i;
                }
                dlg.setInitialElementSelections(list);
            }
        }
        dlg.open();
        if (dlg.getReturnCode() == 1) {
            return;
        }
        Object[] descs = dlg.getResult();
        if (descs == null) {
            return;
        }
        String[] selectedIDs = new String[descs.length];
        i = 0;
        while (i < descs.length) {
            selectedIDs[i] = ((IViewDescriptor)descs[i]).getId();
            this.view.lch.sendShowView(touser, selectedIDs[i]);
            ++i;
        }
        section.put("SELECTION", selectedIDs);
    }

    protected void closeProjectGroup(IUser user) {
        if (MessageDialog.openConfirm(null, (String)MessageLoader.getString("LineChatClientView.contextmenu.closeMessageTitle"), (String)MessageLoader.getFormattedString("LineChatClientView.contextmenu.closeMessageMessage", this.view.name))) {
            this.view.lch.chatGUIDestroy();
        }
    }

    protected void outputClear() {
        if (MessageDialog.openConfirm(null, (String)MessageLoader.getString("ChatComposite.DIALOG_CONFIRM_CLEAR_TITLE"), (String)MessageLoader.getString("ChatComposite.DIALOG_CONFIRM_CLEAR_TEXT"))) {
            this.textoutput.setText("");
        }
    }

    protected void outputCopy() {
        String t = this.textoutput.getSelectionText();
        if (t == null || t.length() == 0) {
            this.textoutput.selectAll();
        }
        this.textoutput.copy();
        this.textoutput.setSelection(this.textoutput.getText().length());
    }

    protected void outputPaste() {
        this.textinput.paste();
    }

    protected void outputSelectAll() {
        this.textoutput.selectAll();
    }

    protected int getChunkPreference() {
        IPreferenceStore pstore = ClientPlugin.getDefault().getPreferenceStore();
        int chunksize = pstore.getInt("filetransferchunksize");
        if (chunksize <= 0) {
            chunksize = 1024;
        }
        return chunksize;
    }

    protected int getDelayPreference() {
        IPreferenceStore pstore = ClientPlugin.getDefault().getPreferenceStore();
        int delay = pstore.getInt("filetransferdelay");
        if (delay <= 0) {
            delay = 10;
        }
        return delay;
    }

    protected void readStreamAndSend(InputStream local, String fileName, Date startDate, ID target, final boolean launch) {
        block2: {
            try {
                ID eclipseStageID = IDFactory.getDefault().createStringID("chat");
                BufferedInputStream ins = new BufferedInputStream(local);
                File remoteFile = new File(new File(fileName).getName());
                FileTransferParams sp = new FileTransferParams(remoteFile, this.getChunkPreference(), this.getDelayPreference(), null, true, -1L, null);
                final Object[] args = new Object[]{this.view, target, ins, sp, eclipseStageID};
                new Thread(new Runnable(){

                    public void run() {
                        if (launch) {
                            LineChatClientView lineChatClientView = ChatComposite.this.view;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.ecf.example.collab.share.io.EclipseFileTransferAndLaunch");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            String string = clazz.getName();
                            String[] stringArray = new String[5];
                            Class<?> clazz2 = class$1;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = class$1 = Class.forName("org.eclipse.ecf.example.collab.share.io.FileSenderUI");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            stringArray[0] = clazz2.getName();
                            Class<?> clazz3 = class$2;
                            if (clazz3 == null) {
                                try {
                                    clazz3 = class$2 = Class.forName("org.eclipse.ecf.core.identity.ID");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            stringArray[1] = clazz3.getName();
                            Class<?> clazz4 = class$3;
                            if (clazz4 == null) {
                                try {
                                    clazz4 = class$3 = Class.forName("java.io.InputStream");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            stringArray[2] = clazz4.getName();
                            Class<?> clazz5 = class$4;
                            if (clazz5 == null) {
                                try {
                                    clazz5 = class$4 = Class.forName("org.eclipse.ecf.example.collab.share.io.FileTransferParams");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            stringArray[3] = clazz5.getName();
                            Class<?> clazz6 = class$2;
                            if (clazz6 == null) {
                                try {
                                    clazz6 = class$2 = Class.forName("org.eclipse.ecf.core.identity.ID");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            stringArray[4] = clazz6.getName();
                            lineChatClientView.createObject(null, string, stringArray, args);
                        } else {
                            LineChatClientView lineChatClientView = ChatComposite.this.view;
                            Class<?> clazz = class$5;
                            if (clazz == null) {
                                try {
                                    clazz = class$5 = Class.forName("org.eclipse.ecf.example.collab.share.io.EclipseFileTransfer");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            String string = clazz.getName();
                            String[] stringArray = new String[5];
                            Class<?> clazz7 = class$1;
                            if (clazz7 == null) {
                                try {
                                    clazz7 = class$1 = Class.forName("org.eclipse.ecf.example.collab.share.io.FileSenderUI");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            stringArray[0] = clazz7.getName();
                            Class<?> clazz8 = class$2;
                            if (clazz8 == null) {
                                try {
                                    clazz8 = class$2 = Class.forName("org.eclipse.ecf.core.identity.ID");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            stringArray[1] = clazz8.getName();
                            Class<?> clazz9 = class$3;
                            if (clazz9 == null) {
                                try {
                                    clazz9 = class$3 = Class.forName("java.io.InputStream");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            stringArray[2] = clazz9.getName();
                            Class<?> clazz10 = class$4;
                            if (clazz10 == null) {
                                try {
                                    clazz10 = class$4 = Class.forName("org.eclipse.ecf.example.collab.share.io.FileTransferParams");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            stringArray[3] = clazz10.getName();
                            Class<?> clazz11 = class$2;
                            if (clazz11 == null) {
                                try {
                                    clazz11 = class$2 = Class.forName("org.eclipse.ecf.core.identity.ID");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            stringArray[4] = clazz11.getName();
                            lineChatClientView.createObject(null, string, stringArray, args);
                        }
                    }
                }, "FileRepObject creator").start();
            }
            catch (Exception e) {
                if (this.view.lch == null) break block2;
                this.view.lch.chatException(e, "readStreamAndSend()");
            }
        }
    }

    protected void sendCoBrowseToUser(IUser user) {
        String res = null;
        ID userID = null;
        if (user != null) {
            res = this.getID(NLS.bind((String)MessageLoader.getString("ChatComposite.COBROWSE_TITLE"), (Object)user.getNickname()), MessageLoader.getString("ChatComposite.COBROWSE_URL_TEXT"), "http://");
            userID = user.getID();
        } else {
            res = this.getID(MessageLoader.getString("ChatComposite.DIALOG_COBROWSE_TITLE"), MessageLoader.getString("ChatComposite.DIALOG_COBROWSE_TEXT"), MessageLoader.getString("ChatComposite.DIALOG_COBROWSE_HTTPPREFIX"));
        }
        if (res != null) {
            Object[] args = new Object[]{userID, res};
            this.view.createObject(null, LineChatClientView.SHOWURLCLASSNAME, LineChatClientView.SHOWURLARGTYPES, args);
        }
    }

    protected void sendFile(String pathName, final String fileName, Date startDate, ID target, boolean launch) {
        FileInputStream ins;
        block5: {
            try {
                this.copyFileLocally(pathName, fileName);
            }
            catch (IOException e) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError(null, (String)MessageLoader.getString("ChatComposite.DIALOG_COPY_ERROR_TITLE"), (String)(String.valueOf(MessageLoader.getString("ChatComposite.DIALOG_COPY_ERROR_TEXT")) + e));
                    }
                });
                if (this.view.lch != null) {
                    this.view.lch.chatException(e, "sendFile(" + pathName + "/" + fileName + ")");
                }
                return;
            }
            ins = null;
            try {
                ins = new FileInputStream(pathName);
            }
            catch (FileNotFoundException e) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError(null, (String)MessageLoader.getString("ChatComposite.DIALOG_FILE_OPEN_ERROR_TITLE"), (String)NLS.bind((String)MessageLoader.getString("ChatComposite.EXCEPTION_FILE_NOT_FOUND_TEXT"), (Object)fileName, (Object)e.getLocalizedMessage()));
                    }
                });
                if (this.view.lch == null) break block5;
                this.view.lch.chatException(e, NLS.bind((String)MessageLoader.getString("ChatComposite.EXCEPTION_FILE_NOT_FOUND_TEXT1"), (Object)fileName));
            }
        }
        this.readStreamAndSend(ins, fileName, startDate, target, launch);
    }

    protected void sendFileToGroup(boolean launch) {
        FileDialog fd = new FileDialog(Display.getDefault().getActiveShell(), 4096);
        fd.setFilterPath(System.getProperty("user.dir"));
        fd.setText(MessageLoader.getString("ChatComposite.SELECT_FILE_FOR_GROUP_TEXT"));
        String res = fd.open();
        if (res != null) {
            File selected = new File(res);
            File localTarget = new File(this.view.downloaddir, selected.getName());
            this.sendFile(selected.getPath(), localTarget.getAbsolutePath(), null, null, launch);
        }
    }

    protected void sendFileToUser(IUser user, boolean launch) {
        FileDialog fd = new FileDialog(Display.getDefault().getActiveShell(), 4096);
        fd.setFilterPath(System.getProperty("user.dir"));
        fd.setText(NLS.bind((String)MessageLoader.getString("ChatComposite.SELECt_FILE_TITLE"), (Object)user.getNickname()));
        String res = fd.open();
        if (res != null) {
            File selected = new File(res);
            File localTarget = new File(this.view.downloaddir, selected.getName());
            this.sendFile(selected.getPath(), localTarget.getAbsolutePath(), null, user.getID(), launch);
        }
    }

    protected void sendMessageToGroup() {
        String res = this.getID(MessageLoader.getString("ChatComposite.MESSAGE_TO_GROUP_TITLE"), MessageLoader.getString("ChatComposite.MESSAGE_TO_GROUP_TEXT"), "");
        if (res != null & !res.equals("")) {
            String[] args = new String[]{res, this.view.userdata.getNickname()};
            this.view.createObject(null, LineChatClientView.MESSAGECLASSNAME, args);
        }
    }

    protected void sendPrivateTextMsg(IUser data) {
        if (this.view.lch != null) {
            IPresenceContainerAdapter ipca = this.view.lch.getPresenceContainer();
            MessagesView messagesView = this.view.lch.findMessagesView();
            if (messagesView != null) {
                IChatManager chatManager = ipca.getChatManager();
                messagesView.openTab(chatManager.getChatMessageSender(), chatManager.getTypingMessageSender(), this.view.lch.getContainerID(), data.getID());
            }
        }
    }

    protected void sendRepObjectToGroup(IUser user) {
        String result = this.getID(MessageLoader.getString("ChatComposite.SEND_REPLICATED_OBJECT_TITLE"), MessageLoader.getString("ChatComposite.SEND_REPLICATED_OBJECT_TEXT"), "");
        if (result != null && !result.equals("")) {
            this.view.createObject(null, this.getCommand(result), this.getArgs(result));
        }
    }

    protected void sendRepObjectToServer() {
    }

    protected void sendRingMessageToUser(IUser data) {
        String res = null;
        if (this.view.lch != null && (res = data != null ? this.getID(String.valueOf(MessageLoader.getString("ChatComposite.RING_TITLE")) + data.getNickname(), MessageLoader.getString("ChatComposite.RING_MESSAGE_TEXT"), "") : this.getID(MessageLoader.getString("ChatComposite.RING_GROUP_TITLE"), MessageLoader.getString("ChatComposite.RING_MESSAGE_TEXT"), "")) != null) {
            this.view.lch.sendRingMessageToUser(data, res);
        }
    }

    protected void startProgram(IUser ud) {
        String res = null;
        ID receiver = null;
        if (ud == null) {
            res = this.getID(MessageLoader.getString("ChatComposite.START_PROGRAM_GROUP_TITLE"), MessageLoader.getString("ChatComposite.START_PROGRAM_GROUP_TEXT"), "");
        } else {
            res = this.getID(String.valueOf(MessageLoader.getString("ChatComposite.START_PROGRAM_TITLE")) + ud.getNickname(), String.valueOf(MessageLoader.getString("ChatComposite.START_PROGRAM_TEXT")) + ud.getNickname() + ":", "");
            receiver = ud.getID();
        }
        if (res != null) {
            this.view.runProgram(receiver, res, null);
        }
    }

    protected void initializeDropTargets() {
        this.chatDropTarget = new ChatDropTarget(this.view, (Control)this.textoutput, this);
        this.treeDropTarget = new TreeDropTarget(this.view, this.tableView.getControl(), this);
    }

    private Color colorFromRGBString(String rgb) {
        if (rgb == null || rgb.equals("")) {
            return new Color((Device)this.getShell().getDisplay(), 0, 0, 0);
        }
        String[] vals = StringUtils.split((String)rgb, (String)",");
        return new Color((Device)this.getShell().getDisplay(), Integer.parseInt(vals[0]), Integer.parseInt(vals[1]), Integer.parseInt(vals[2]));
    }

    private class ColorPropertyChangeListener
    implements Preferences.IPropertyChangeListener {
        private ColorPropertyChangeListener() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            ChatComposite.this.meColor.dispose();
            ChatComposite.this.otherColor.dispose();
            ChatComposite.this.systemColor.dispose();
            ChatComposite.this.meColor = ChatComposite.this.colorFromRGBString(ClientPlugin.getDefault().getPluginPreferences().getString("prefMeTextColor"));
            ChatComposite.this.otherColor = ChatComposite.this.colorFromRGBString(ClientPlugin.getDefault().getPluginPreferences().getString("prefOtherTextColor"));
            ChatComposite.this.systemColor = ChatComposite.this.colorFromRGBString(ClientPlugin.getDefault().getPluginPreferences().getString("prefSystemTextColor"));
        }
    }

    private class FontPropertyChangeListener
    implements Preferences.IPropertyChangeListener {
        private FontPropertyChangeListener() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            String fontName;
            if (event.getProperty().equals("chatFont") && (fontName = ClientPlugin.getDefault().getPluginPreferences().getString("chatFont")) != null && !fontName.equals("")) {
                FontRegistry fr = ClientPlugin.getDefault().getFontRegistry();
                FontData[] newFont = new FontData[]{new FontData(fontName)};
                fr.put(ChatComposite.CHAT_OUTPUT_FONT, newFont);
                ChatComposite.this.textoutput.setFont(fr.get(ChatComposite.CHAT_OUTPUT_FONT));
            }
        }
    }
}

