/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.discovery;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.osgi.services.discovery.Activator;
import org.eclipse.ecf.internal.osgi.services.discovery.ServicePropertyUtils;
import org.osgi.service.discovery.ServiceEndpointDescription;

public abstract class ECFServiceEndpointDescription
implements ServiceEndpointDescription {
    private final long timeout = new Long(System.getProperty("ecf.osgi.distribution.lookup.timeout", "30000"));
    private final Map serviceProperties;

    public ECFServiceEndpointDescription(Map properties) {
        this.serviceProperties = properties;
    }

    public String getEndpointID() {
        Object o = this.serviceProperties.get("osgi.remote.endpoint.id");
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public String getEndpointInterfaceName(String interfaceName) {
        if (interfaceName == null) {
            return null;
        }
        Object o = this.serviceProperties.get("osgi.remote.endpoint.interface");
        if (o == null || !(o instanceof String)) {
            return null;
        }
        String intfNames = (String)o;
        Collection c = ServicePropertyUtils.createCollectionFromString(intfNames);
        if (c == null) {
            return null;
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            String intfName = (String)i.next();
            if (intfName == null || !intfName.startsWith(interfaceName)) continue;
            return intfName.substring(intfName.length() + ":".length()).trim();
        }
        return null;
    }

    public URL getLocation() {
        Object o = this.serviceProperties.get("osgi.remote.endpoint.location");
        if (o == null || !(o instanceof String)) {
            return null;
        }
        String urlExternalForm = (String)o;
        URL url = null;
        try {
            url = new URL(urlExternalForm);
        }
        catch (MalformedURLException e) {
            Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.osgi.services.discovery", 4, "Exception getting location URL", (Throwable)e));
        }
        return url;
    }

    public Map getProperties() {
        return this.serviceProperties;
    }

    public Object getProperty(String key) {
        return this.serviceProperties.get(key);
    }

    public Collection getPropertyKeys() {
        return this.serviceProperties.keySet();
    }

    public Collection getProvidedInterfaces() {
        Object o = this.serviceProperties.get("service.interface");
        if (o == null || !(o instanceof String)) {
            throw new NullPointerException();
        }
        String providedInterfacesStr = (String)o;
        return ServicePropertyUtils.createCollectionFromString(providedInterfacesStr);
    }

    public String getVersion(String interfaceName) {
        Collection c = this.getProvidedInterfaces();
        if (c == null) {
            return null;
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            String intfName = (String)i.next();
            if (intfName == null || !intfName.startsWith(interfaceName)) continue;
            return intfName.substring(intfName.length() + "|".length()).trim();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ServiceEndpointDescriptionImpl[");
        sb.append(";providedinterfaces=").append(this.getProvidedInterfaces());
        sb.append(";location=").append(this.getLocation());
        sb.append(";lookup timeout=" + this.getLookupTimeout());
        sb.append(";props=").append(this.getProperties()).append("]");
        return sb.toString();
    }

    public abstract ID getECFEndpointID();

    public long getLookupTimeout() {
        return this.timeout;
    }
}

