/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.datashare;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.sharedobject.BaseSharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectTransactionConfig;
import org.eclipse.ecf.core.sharedobject.SharedObjectCreateException;
import org.eclipse.ecf.core.sharedobject.SharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectFactory;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.core.sharedobject.SharedObjectTypeDescription;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectActivatedEvent;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectDeactivatedEvent;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.core.util.IEventProcessor;
import org.eclipse.ecf.datashare.IChannel;
import org.eclipse.ecf.datashare.IChannelConfig;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.datashare.IChannelContainerListener;
import org.eclipse.ecf.datashare.IChannelListener;
import org.eclipse.ecf.datashare.events.IChannelContainerChannelActivatedEvent;
import org.eclipse.ecf.datashare.events.IChannelContainerChannelDeactivatedEvent;
import org.eclipse.ecf.datashare.events.IChannelContainerEvent;
import org.eclipse.ecf.internal.provider.datashare.Activator;
import org.eclipse.ecf.internal.provider.datashare.Messages;
import org.eclipse.osgi.util.NLS;

public class SharedObjectDatashareContainerAdapter
extends BaseSharedObject
implements IChannelContainerAdapter {
    protected static final int DEFAULT_TRANSACTION_WAIT = 30000;
    protected List channelContainerListeners = Collections.synchronizedList(new ArrayList());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    protected void initialize() throws SharedObjectInitException {
        super.initialize();
        this.addEventProcessor(new IEventProcessor(){

            public boolean processEvent(Event event) {
                ISharedObjectDeactivatedEvent sode;
                if (event instanceof ISharedObjectActivatedEvent) {
                    ISharedObjectActivatedEvent soae = (ISharedObjectActivatedEvent)event;
                    if (!soae.getActivatedID().equals((Object)SharedObjectDatashareContainerAdapter.this.getID())) {
                        SharedObjectDatashareContainerAdapter.this.fireChannelContainerListeners((IChannelContainerEvent)new IChannelContainerChannelActivatedEvent(this, soae){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ ISharedObjectActivatedEvent val$soae;
                            {
                                this.this$1 = var1_1;
                                this.val$soae = iSharedObjectActivatedEvent;
                            }

                            public ID getChannelID() {
                                return this.val$soae.getActivatedID();
                            }

                            public ID getChannelContainerID() {
                                return this.val$soae.getLocalContainerID();
                            }

                            public String toString() {
                                StringBuffer buf = new StringBuffer("ChannelActivatedEvent[");
                                buf.append("channelid=").append(this.val$soae.getActivatedID()).append(";");
                                buf.append("containerid=").append(this.val$soae.getLocalContainerID()).append("]");
                                return buf.toString();
                            }
                        });
                    }
                } else if (event instanceof ISharedObjectDeactivatedEvent && !(sode = (ISharedObjectDeactivatedEvent)event).getDeactivatedID().equals((Object)SharedObjectDatashareContainerAdapter.this.getID())) {
                    SharedObjectDatashareContainerAdapter.this.fireChannelContainerListeners((IChannelContainerEvent)new IChannelContainerChannelDeactivatedEvent(this, sode){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ ISharedObjectDeactivatedEvent val$sode;
                        {
                            this.this$1 = var1_1;
                            this.val$sode = iSharedObjectDeactivatedEvent;
                        }

                        public ID getChannelID() {
                            return this.val$sode.getDeactivatedID();
                        }

                        public ID getChannelContainerID() {
                            return this.val$sode.getLocalContainerID();
                        }

                        public String toString() {
                            StringBuffer buf = new StringBuffer("ChannelDeactivatedEvent[");
                            buf.append("channelid=").append(this.val$sode.getDeactivatedID()).append(";");
                            buf.append("containerid=").append(this.val$sode.getLocalContainerID()).append("]");
                            return buf.toString();
                        }
                    });
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChannelContainerListeners(IChannelContainerEvent event) {
        List list = this.channelContainerListeners;
        synchronized (list) {
            Iterator i = this.channelContainerListeners.iterator();
            while (i.hasNext()) {
                IChannelContainerListener l = (IChannelContainerListener)i.next();
                if (l == null) continue;
                l.handleChannelContainerEvent(event);
            }
        }
    }

    public IChannel createChannel(final ID newID, final IChannelListener listener, final Map properties) throws ECFException {
        return this.createChannel(new IChannelConfig(){

            public IChannelListener getListener() {
                return listener;
            }

            public ID getID() {
                return newID;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }

            public Map getProperties() {
                return properties;
            }
        });
    }

    protected SharedObjectDescription createChannelSharedObjectDescription(IChannelConfig channelConfig) throws ECFException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.datashare.BaseChannel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SharedObjectDescription(clazz, channelConfig.getID(), channelConfig.getProperties());
    }

    protected ISharedObjectTransactionConfig createChannelSharedObjectTransactionConfig() {
        return null;
    }

    protected ISharedObject createSharedObject(SharedObjectTypeDescription typeDescription, ISharedObjectTransactionConfig transactionConfig, IChannelListener listener) throws SharedObjectCreateException {
        try {
            Class<?> clazz = Class.forName(typeDescription.getClassName());
            Class[] classArray = new Class[2];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ecf.core.sharedobject.ISharedObjectTransactionConfig");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.eclipse.ecf.datashare.IChannelListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz3;
            Constructor<?> cons = clazz.getDeclaredConstructor(classArray);
            return (ISharedObject)cons.newInstance(transactionConfig, listener);
        }
        catch (Exception e) {
            throw new SharedObjectCreateException(NLS.bind((String)Messages.SharedObjectDatashareContainerAdapter_EXCEPTION_CANNOTCREATESHAREDOBJECT, (Object)typeDescription.getClassName()), (Throwable)e);
        }
    }

    public IChannel createChannel(IChannelConfig newChannelConfig) throws ECFException {
        IChannel channel;
        SharedObjectDescription sodesc = this.createChannelSharedObjectDescription(newChannelConfig);
        SharedObjectTypeDescription sotypedesc = sodesc.getTypeDescription();
        IChannelListener listener = newChannelConfig.getListener();
        ISharedObjectTransactionConfig transactionConfig = this.createChannelSharedObjectTransactionConfig();
        ISharedObject so = null;
        so = sotypedesc.getName() != null ? SharedObjectFactory.getDefault().createSharedObject(sotypedesc, new Object[]{transactionConfig, listener}) : this.createSharedObject(sotypedesc, transactionConfig, listener);
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ecf.datashare.IChannel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((channel = (IChannel)so.getAdapter((Class)clazz)) == null) {
            throw new SharedObjectCreateException(NLS.bind((String)Messages.SharedObjectDatashareContainerAdapter_EXCEPTION_CANNOT_CREATE_OBJECT_OF_TYPE, (Object)channel));
        }
        ID newID = sodesc.getID();
        if (newID == null) {
            newID = IDFactory.getDefault().createGUID();
        }
        this.getContext().getSharedObjectManager().addSharedObject(newID, so, sodesc.getProperties());
        return channel;
    }

    public IChannel getChannel(ID channelID) {
        if (channelID == null || channelID.equals((Object)this.getID())) {
            return null;
        }
        return (IChannel)this.getContext().getSharedObjectManager().getSharedObject(channelID);
    }

    public boolean removeChannel(ID channelID) {
        if (channelID == null || channelID.equals((Object)this.getID())) {
            return false;
        }
        ISharedObject o = this.getContext().getSharedObjectManager().removeSharedObject(channelID);
        return o != null;
    }

    public Namespace getChannelNamespace() {
        IIDFactory iIDFactory = IDFactory.getDefault();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ecf.core.identity.StringID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return iIDFactory.getNamespaceByName(clazz.getName());
    }

    public void addListener(IChannelContainerListener listener) {
        this.channelContainerListeners.add(listener);
    }

    public void removeListener(IChannelContainerListener listener) {
        this.channelContainerListeners.add(listener);
    }

    public Object getAdapter(Class adapter) {
        if (adapter != null) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.ecf.core.IContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.isAssignableFrom(clazz)) {
                IContainerManager containerManager = Activator.getDefault().getContainerManager();
                return containerManager.getContainer(this.getContext().getLocalContainerID());
            }
        }
        return super.getAdapter(adapter);
    }
}

