/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSState;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;

public class Prober
extends TimerTask {
    private final JmDNSImpl jmDNSImpl;
    DNSState taskState = DNSState.PROBING_1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Prober(JmDNSImpl jmDNSImpl) {
        this.jmDNSImpl = jmDNSImpl;
        if (this.jmDNSImpl.getState() == DNSState.PROBING_1) {
            this.jmDNSImpl.setTask(this);
        }
        JmDNSImpl jmDNSImpl2 = this.jmDNSImpl;
        synchronized (jmDNSImpl2) {
            Iterator iterator = this.jmDNSImpl.getServices().values().iterator();
            while (iterator.hasNext()) {
                ServiceInfoImpl info = (ServiceInfoImpl)iterator.next();
                if (info.getState() != DNSState.PROBING_1) continue;
                info.setTask(this);
            }
        }
    }

    public void start(Timer timer) {
        long now = System.currentTimeMillis();
        if (now - this.jmDNSImpl.getLastThrottleIncrement() < 5000L) {
            this.jmDNSImpl.setThrottle(this.jmDNSImpl.getThrottle() + 1);
        } else {
            this.jmDNSImpl.setThrottle(1);
        }
        this.jmDNSImpl.setLastThrottleIncrement(now);
        if (this.jmDNSImpl.getState() == DNSState.ANNOUNCED && this.jmDNSImpl.getThrottle() < 10) {
            timer.schedule((TimerTask)this, JmDNSImpl.getRandom().nextInt(251), 250L);
        } else {
            timer.schedule((TimerTask)this, 1000L, 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        if (this.jmDNSImpl.getTask() == this) {
            this.jmDNSImpl.setTask(null);
        }
        JmDNSImpl jmDNSImpl = this.jmDNSImpl;
        synchronized (jmDNSImpl) {
            Iterator i = this.jmDNSImpl.getServices().values().iterator();
            while (i.hasNext()) {
                ServiceInfoImpl info = (ServiceInfoImpl)i.next();
                if (info.getTask() != this) continue;
                info.setTask(null);
            }
        }
        return super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.jmDNSImpl.getIoLock();
        synchronized (object) {
            block18: {
                DNSOutgoing out = null;
                try {
                    LinkedList list;
                    if (this.jmDNSImpl.getState() == this.taskState && this.jmDNSImpl.getTask() == this) {
                        if (out == null) {
                            out = new DNSOutgoing(0);
                        }
                        out.addQuestion(new DNSQuestion(this.jmDNSImpl.getLocalHost().getName(), 255, 1));
                        this.jmDNSImpl.getLocalHost().addAddressRecords(out, true);
                        this.jmDNSImpl.advanceState();
                    }
                    JmDNSImpl jmDNSImpl = this.jmDNSImpl;
                    synchronized (jmDNSImpl) {
                        list = new LinkedList(this.jmDNSImpl.getServices().values());
                    }
                    Iterator i = list.iterator();
                    while (i.hasNext()) {
                        ServiceInfoImpl info;
                        ServiceInfoImpl serviceInfoImpl = info = (ServiceInfoImpl)i.next();
                        synchronized (serviceInfoImpl) {
                            if (info.getState() == this.taskState && info.getTask() == this) {
                                info.advanceState();
                                if (out == null) {
                                    out = new DNSOutgoing(0);
                                    out.addQuestion(new DNSQuestion(info.getQualifiedName(), 255, 1));
                                }
                                out.addAuthorativeAnswer(new DNSRecord.Service(info.getQualifiedName(), 33, 1, 3600, info.getPriority(), info.getWeight(), info.getPort(), this.jmDNSImpl.getLocalHost().getName()));
                            }
                        }
                    }
                    if (out != null) {
                        this.jmDNSImpl.send(out);
                        break block18;
                    }
                    this.cancel();
                    return;
                }
                catch (Throwable throwable) {
                    this.jmDNSImpl.recover();
                }
            }
            this.taskState = this.taskState.advance();
            if (!this.taskState.isProbing()) {
                this.cancel();
                this.jmDNSImpl.startAnnouncer();
            }
        }
    }
}

