/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerConnectingEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.core.sharedobject.SharedObjectAddException;
import org.eclipse.ecf.core.sharedobject.util.IQueueEnqueue;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.internal.provider.xmpp.Messages;
import org.eclipse.ecf.internal.provider.xmpp.XMPPChatRoomContainerHelper;
import org.eclipse.ecf.internal.provider.xmpp.XMPPContainerContext;
import org.eclipse.ecf.internal.provider.xmpp.XmppPlugin;
import org.eclipse.ecf.internal.provider.xmpp.events.ChatMembershipEvent;
import org.eclipse.ecf.internal.provider.xmpp.events.IQEvent;
import org.eclipse.ecf.internal.provider.xmpp.events.MessageEvent;
import org.eclipse.ecf.internal.provider.xmpp.events.PresenceEvent;
import org.eclipse.ecf.internal.provider.xmpp.smack.ECFConnection;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.chatroom.IChatRoomAdminListener;
import org.eclipse.ecf.presence.chatroom.IChatRoomAdminSender;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageSender;
import org.eclipse.ecf.presence.chatroom.IChatRoomParticipantListener;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageSender;
import org.eclipse.ecf.provider.comm.ConnectionCreateException;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.generic.ClientSOContainer;
import org.eclipse.ecf.provider.generic.ContainerMessage;
import org.eclipse.ecf.provider.generic.SOConfig;
import org.eclipse.ecf.provider.generic.SOContainer;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.SOContext;
import org.eclipse.ecf.provider.generic.SOWrapper;
import org.eclipse.ecf.provider.xmpp.identity.XMPPRoomID;
import org.eclipse.osgi.util.NLS;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.muc.InvitationRejectionListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;

public class XMPPChatRoomContainer
extends ClientSOContainer
implements IChatRoomContainer {
    private static final String CONTAINER_HELPER_ID;
    private ID containerHelperID;
    private XMPPChatRoomContainerHelper containerHelper;
    private MultiUserChat multiuserchat;
    private List chatRoomAdminListeners;
    private IChatRoomAdminSender chatRoomAdminSender;
    IChatMessageSender privateSender = new IChatMessageSender(){

        public void sendChatMessage(ID toID, ID threadID, IChatMessage.Type type, String subject, String body, Map properties) throws ECFException {
        }

        public void sendChatMessage(ID toID, String body) throws ECFException {
        }
    };
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.xmpp.XMPPContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CONTAINER_HELPER_ID = String.valueOf(clazz.getName()) + ".xmppgroupchathandler";
    }

    public XMPPChatRoomContainer(ISharedObjectContainerConfig config, ECFConnection conn, Namespace usernamespace) throws IDCreateException {
        super(config);
        this.connection = conn;
        this.config = config;
        this.containerHelperID = IDFactory.getDefault().createStringID(CONTAINER_HELPER_ID);
        this.containerHelper = new XMPPChatRoomContainerHelper(usernamespace, this.getXMPPConnection());
        this.chatRoomAdminListeners = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendInvitation(ID toUser, String subject, String body) throws ECFException {
        if (toUser == null) {
            throw new ECFException(Messages.XMPPChatRoomContainer_EXCEPTION_TARGET_USER_NOT_NULL);
        }
        ClientSOContainer.Lock lock = this.getConnectLock();
        synchronized (lock) {
            if (this.multiuserchat == null) {
                throw new ContainerConnectException(Messages.XMPPChatRoomContainer_EXCEPTION_NOT_CONNECTED);
            }
            this.multiuserchat.invite(toUser.getName(), body == null ? "" : body);
        }
    }

    public XMPPChatRoomContainer(ECFConnection conn, Namespace usernamespace) throws IDCreateException {
        this((ISharedObjectContainerConfig)new SOContainerConfig(IDFactory.getDefault().createGUID()), conn, usernamespace);
    }

    public void dispose() {
        this.disconnect();
        if (this.containerHelperID != null) {
            this.getSharedObjectManager().removeSharedObject(this.containerHelperID);
            this.containerHelperID = null;
        }
        if (this.containerHelper != null) {
            this.containerHelper.dispose(this.getID());
        }
        this.containerHelper = null;
        if (this.chatRoomAdminListeners != null) {
            this.chatRoomAdminListeners.clear();
        }
        this.chatRoomAdminListeners = null;
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(ContainerMessage data) throws IOException {
        ClientSOContainer.Lock lock = this.getConnectLock();
        synchronized (lock) {
            ID toID = data.getToContainerID();
            if (toID == null) {
                data.setToContainerID(this.remoteServerID);
            }
            super.sendMessage(data);
        }
    }

    protected void handleChatMessage(Message mess) throws IOException {
        SOWrapper wrap = this.getSharedObjectWrapper(this.containerHelperID);
        if (wrap != null) {
            wrap.deliverEvent((Event)new MessageEvent(mess));
        }
    }

    protected boolean verifyToIDForSharedObjectMessage(ID toID) {
        return true;
    }

    public void handleContainerMessage(ContainerMessage mess) throws IOException {
        if (mess == null) {
            this.debug("got null container message...ignoring");
            return;
        }
        Serializable data = mess.getData();
        if (data instanceof ContainerMessage.CreateMessage) {
            this.handleCreateMessage(mess);
        } else if (data instanceof ContainerMessage.CreateResponseMessage) {
            this.handleCreateResponseMessage(mess);
        } else if (data instanceof ContainerMessage.SharedObjectMessage) {
            this.handleSharedObjectMessage(mess);
        } else if (data instanceof ContainerMessage.SharedObjectDisposeMessage) {
            this.handleSharedObjectDisposeMessage(mess);
        } else {
            this.debug("got unrecognized container message...ignoring: " + mess);
        }
    }

    protected void handleIQMessage(IQ mess) throws IOException {
        SOWrapper wrap = this.getSharedObjectWrapper(this.containerHelperID);
        if (wrap != null) {
            wrap.deliverEvent((Event)new IQEvent(mess));
        }
    }

    protected void handlePresenceMessage(Presence mess) throws IOException {
        SOWrapper wrap = this.getSharedObjectWrapper(this.containerHelperID);
        if (wrap != null) {
            wrap.deliverEvent((Event)new PresenceEvent(mess));
        }
    }

    protected void handleChatMembershipEvent(String from, boolean add) {
        SOWrapper wrap = this.getSharedObjectWrapper(this.containerHelperID);
        if (wrap != null) {
            wrap.deliverEvent((Event)new ChatMembershipEvent(from, add));
        }
    }

    protected void handleXMPPMessage(Packet aPacket) {
        try {
            if (aPacket instanceof IQ) {
                this.handleIQMessage((IQ)aPacket);
            } else if (aPacket instanceof Message) {
                this.handleChatMessage((Message)aPacket);
            } else if (aPacket instanceof Presence) {
                this.handlePresenceMessage((Presence)aPacket);
            } else {
                this.debug("got unexpected packet " + aPacket);
            }
        }
        catch (IOException e) {
            this.traceStack("Exception in handleXMPPMessage", e);
        }
    }

    protected XMPPConnection getXMPPConnection() {
        return ((ECFConnection)this.getConnection()).getXMPPConnection();
    }

    protected void addSharedObjectToContainer(ID remote) throws SharedObjectAddException {
        this.getSharedObjectManager().addSharedObject(this.containerHelperID, (ISharedObject)this.containerHelper, new HashMap());
    }

    protected void cleanUpConnectFail() {
        if (this.containerHelper != null) {
            this.getSharedObjectManager().removeSharedObject(this.containerHelperID);
            this.containerHelper = null;
            this.containerHelperID = null;
        }
        this.connectionState = 0;
        this.remoteServerID = null;
    }

    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName(XmppPlugin.getDefault().getRoomNamespaceIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ID remote, IConnectContext connectContext) throws ContainerConnectException {
        if (!(remote instanceof XMPPRoomID)) {
            throw new ContainerConnectException(NLS.bind((String)Messages.XMPPChatRoomContainer_Exception_Connect_Wrong_Type, (Object)remote));
        }
        XMPPRoomID roomID = (XMPPRoomID)remote;
        this.fireContainerEvent((IContainerEvent)new ContainerConnectingEvent(this.getID(), remote, (Object)connectContext));
        ClientSOContainer.Lock lock = this.getConnectLock();
        synchronized (lock) {
            try {
                this.connectionState = 1;
                this.remoteServerID = null;
                this.addSharedObjectToContainer(remote);
                this.multiuserchat = new MultiUserChat(this.getXMPPConnection(), roomID.getMucString());
                String nick = null;
                try {
                    CallbackHandler handler;
                    Callback[] callbacks = new Callback[]{new NameCallback(Messages.XMPPChatRoomContainer_NAME_CALLBACK_NICK, roomID.getNickname())};
                    if (connectContext != null && (handler = connectContext.getCallbackHandler()) != null) {
                        handler.handle(callbacks);
                    }
                    if (callbacks[0] instanceof NameCallback) {
                        NameCallback cb = (NameCallback)callbacks[0];
                        nick = cb.getName();
                    }
                }
                catch (Exception e) {
                    throw new ContainerConnectException(Messages.XMPPChatRoomContainer_EXCEPTION_CALLBACKHANDLER, (Throwable)e);
                }
                String nickname = null;
                nickname = nick == null || nick.equals("") ? roomID.getNickname() : nick;
                this.multiuserchat.addSubjectUpdatedListener(new SubjectUpdatedListener(){

                    public void subjectUpdated(String subject, String from) {
                        XMPPChatRoomContainer.this.fireSubjectUpdated(subject, from);
                    }
                });
                this.multiuserchat.addMessageListener(new PacketListener(){

                    public void processPacket(Packet arg0) {
                        XMPPChatRoomContainer.this.handleXMPPMessage(arg0);
                    }
                });
                this.multiuserchat.addParticipantListener(new PacketListener(){

                    public void processPacket(Packet arg0) {
                        XMPPChatRoomContainer.this.handleXMPPMessage(arg0);
                    }
                });
                this.multiuserchat.addParticipantStatusListener(new ParticipantStatusListener(){

                    public void joined(String arg0) {
                        XMPPChatRoomContainer.this.handleChatMembershipEvent(arg0, true);
                    }

                    public void left(String arg0) {
                        XMPPChatRoomContainer.this.handleChatMembershipEvent(arg0, false);
                    }

                    public void voiceGranted(String arg0) {
                        System.out.println("voiceGranted(" + arg0 + ")");
                    }

                    public void voiceRevoked(String arg0) {
                        System.out.println("voiceRevoked(" + arg0 + ")");
                    }

                    public void membershipGranted(String arg0) {
                        System.out.println("membershipGranted(" + arg0 + ")");
                    }

                    public void membershipRevoked(String arg0) {
                        System.out.println("membershipRevoked(" + arg0 + ")");
                    }

                    public void moderatorGranted(String arg0) {
                        System.out.println("moderatorGranted(" + arg0 + ")");
                    }

                    public void moderatorRevoked(String arg0) {
                        System.out.println("moderatorRevoked(" + arg0 + ")");
                    }

                    public void ownershipGranted(String arg0) {
                        System.out.println("ownershipGranted(" + arg0 + ")");
                    }

                    public void ownershipRevoked(String arg0) {
                        System.out.println("ownershipRevoked(" + arg0 + ")");
                    }

                    public void adminGranted(String arg0) {
                        System.out.println("adminGranted(" + arg0 + ")");
                    }

                    public void adminRevoked(String arg0) {
                        System.out.println("adminRevoked(" + arg0 + ")");
                    }

                    public void kicked(String arg0, String arg1, String arg2) {
                        System.out.println("kicked(" + arg0 + "," + arg1 + "," + arg2 + ")");
                    }

                    public void banned(String arg0, String arg1, String arg2) {
                        System.out.println("banned(" + arg0 + "," + arg1 + "," + arg2 + ")");
                    }

                    public void nicknameChanged(String arg0, String arg1) {
                        System.out.println("nicknameChanged(" + arg0 + "," + arg1 + ")");
                    }
                });
                this.multiuserchat.addInvitationRejectionListener(new InvitationRejectionListener(){

                    public void invitationDeclined(String arg0, String arg1) {
                        System.out.println("invitationDeclined(" + arg0 + "," + arg1 + ")");
                    }
                });
                this.multiuserchat.join(nickname);
                this.connectionState = (byte)2;
                this.remoteServerID = roomID;
                this.containerHelper.setRoomID(this.remoteServerID);
                this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.getID(), (ID)roomID));
            }
            catch (Exception e) {
                this.cleanUpConnectFail();
                ContainerConnectException ce = new ContainerConnectException(NLS.bind((String)Messages.XMPPChatRoomContainer_EXCEPTION_JOINING_ROOM, (Object)((Object)roomID)));
                ce.setStackTrace(e.getStackTrace());
                throw ce;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSubjectUpdated(String subject, String from) {
        ArrayList notify = null;
        List list = this.chatRoomAdminListeners;
        synchronized (list) {
            notify = new ArrayList(this.chatRoomAdminListeners);
        }
        Iterator i = notify.iterator();
        while (i.hasNext()) {
            IChatRoomAdminListener l = (IChatRoomAdminListener)i.next();
            l.handleSubjectChange(this.containerHelper.createUserIDFromName(from), subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        ID groupID = this.getConnectedID();
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectingEvent(this.getID(), groupID));
        ClientSOContainer.Lock lock = this.getConnectLock();
        synchronized (lock) {
            if (this.isConnected()) {
                try {
                    this.multiuserchat.leave();
                }
                catch (Exception e) {
                    this.traceStack("Exception in multi user chat.leave", e);
                }
            }
            this.connectionState = 0;
            this.remoteServerID = null;
            if (this.containerHelper != null) {
                this.containerHelper.disconnect();
            }
            this.connection = null;
        }
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.getID(), groupID));
    }

    protected SOContext createSharedObjectContext(SOConfig soconfig, IQueueEnqueue queue) {
        return new XMPPContainerContext(soconfig.getSharedObjectID(), soconfig.getHomeContainerID(), (SOContainer)this, soconfig.getProperties(), queue);
    }

    protected ID createChatRoomID(String groupName) throws IDCreateException {
        String username = this.getXMPPConnection().getUser();
        int atIndex = username.indexOf(64);
        if (atIndex > 0) {
            username = username.substring(0, atIndex);
        }
        String host = this.getXMPPConnection().getHost();
        Namespace ns = this.getConnectNamespace();
        Object[] objectArray = new Object[5];
        objectArray[0] = username;
        objectArray[1] = host;
        objectArray[3] = groupName;
        objectArray[4] = username;
        ID targetID = IDFactory.getDefault().createID(ns, objectArray);
        return targetID;
    }

    protected ISynchAsynchConnection createConnection(ID remoteSpace, Object data) throws ConnectionCreateException {
        return null;
    }

    public IChatMessageSender getPrivateMessageSender() {
        return this.privateSender;
    }

    public IChatRoomMessageSender getChatRoomMessageSender() {
        return new IChatRoomMessageSender(){

            public void sendMessage(String messageBody) throws ECFException {
                if (XMPPChatRoomContainer.this.multiuserchat != null) {
                    try {
                        XMPPChatRoomContainer.this.multiuserchat.sendMessage(messageBody);
                    }
                    catch (Exception e) {
                        ECFException except = new ECFException(Messages.XMPPChatRoomContainer_EXCEPTION_SEND_MESSAGE, (Throwable)e);
                        throw except;
                    }
                }
            }
        };
    }

    public void connect(String groupName) throws ContainerConnectException {
        ID targetID = null;
        try {
            targetID = this.createChatRoomID(groupName);
        }
        catch (IDCreateException e) {
            throw new ContainerConnectException(Messages.XMPPChatRoomContainer_EXCEPTION_CREATING_ROOM_ID, (Throwable)e);
        }
        this.connect(targetID, null);
    }

    public void addChatRoomParticipantListener(IChatRoomParticipantListener participantListener) {
        if (this.containerHelper != null) {
            this.containerHelper.addChatParticipantListener(participantListener);
        }
    }

    public void removeChatRoomParticipantListener(IChatRoomParticipantListener participantListener) {
        if (this.containerHelper != null) {
            this.containerHelper.removeChatParticipantListener(participantListener);
        }
    }

    public void addMessageListener(IIMMessageListener listener) {
        this.containerHelper.addChatRoomMessageListener(listener);
    }

    public void removeMessageListener(IIMMessageListener listener) {
        this.containerHelper.removeChatRoomMessageListener(listener);
    }

    public void addChatRoomAdminListener(IChatRoomAdminListener subjectListener) {
        if (subjectListener == null) {
            return;
        }
        this.chatRoomAdminListeners.add(subjectListener);
    }

    public void removeChatRoomAdminListener(IChatRoomAdminListener subjectListener) {
        if (subjectListener == null) {
            return;
        }
        this.chatRoomAdminListeners.remove(subjectListener);
    }

    public ID[] getChatRoomParticipants() {
        return this.containerHelper.getChatRoomParticipants();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChatRoomAdminSender getChatRoomAdminSender() {
        XMPPChatRoomContainer xMPPChatRoomContainer = this;
        synchronized (xMPPChatRoomContainer) {
            if (this.chatRoomAdminSender == null) {
                this.chatRoomAdminSender = new IChatRoomAdminSender(){

                    public void sendSubjectChange(String newsubject) throws ECFException {
                        if (XMPPChatRoomContainer.this.multiuserchat == null) {
                            throw new ECFException(Messages.XMPPChatRoomContainer_EXCEPTION_NOT_CONNECTED);
                        }
                        try {
                            XMPPChatRoomContainer.this.multiuserchat.changeSubject(newsubject);
                        }
                        catch (XMPPException e) {
                            throw new ECFException((Throwable)e);
                        }
                    }
                };
            }
        }
        return this.chatRoomAdminSender;
    }
}

