/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContext;
import org.eclipse.ecf.core.sharedobject.ISharedObjectManager;
import org.eclipse.ecf.core.sharedobject.ReplicaSharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.util.IQueueEnqueue;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.provider.generic.SOContainer;

public class SOContext
implements ISharedObjectContext {
    protected SOContainer container = null;
    protected ID sharedObjectID;
    protected ID homeContainerID;
    protected boolean isActive;
    protected Map properties;
    protected IQueueEnqueue queue;
    static /* synthetic */ Class class$0;

    public SOContext(ID objID, ID homeID, SOContainer cont, Map props, IQueueEnqueue queue) {
        this.sharedObjectID = objID;
        this.homeContainerID = homeID;
        this.container = cont;
        this.properties = props;
        this.queue = queue;
        this.isActive = true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    protected void trace(String msg) {
        Trace.trace((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/sharedobjectcontext", (String)(String.valueOf(msg) + ":" + this.container.getID()));
    }

    protected void traceStack(String msg, Throwable e) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.generic.SOContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/catching", clazz, (String)(this.container.getID() + ":" + msg), (Throwable)e);
    }

    protected void makeInactive() {
        this.isActive = false;
    }

    protected boolean isInactive() {
        return !this.isActive;
    }

    public ID getLocalContainerID() {
        return this.container.getID();
    }

    public ISharedObjectManager getSharedObjectManager() {
        if (this.isInactive()) {
            return null;
        }
        return this.container.getSharedObjectManager();
    }

    public IQueueEnqueue getQueue() {
        if (this.isInactive()) {
            return null;
        }
        return this.queue;
    }

    public void connect(ID groupID, IConnectContext joinContext) throws ContainerConnectException {
        if (this.isInactive()) {
            return;
        }
        this.container.connect(groupID, joinContext);
    }

    public void disconnect() {
        if (this.isInactive()) {
            this.trace("leaveGroup() CONTEXT INACTIVE");
            return;
        }
        this.trace("leaveGroup()");
        this.container.disconnect();
    }

    public ID getConnectedID() {
        if (this.isInactive()) {
            return null;
        }
        return this.container.getConnectedID();
    }

    public boolean isGroupManager() {
        if (this.isInactive()) {
            return false;
        }
        return this.container.isGroupManager();
    }

    public boolean isGroupServer() {
        if (this.isInactive()) {
            return false;
        }
        return this.container.isGroupManager();
    }

    public ID[] getGroupMemberIDs() {
        if (this.isInactive()) {
            return new ID[0];
        }
        return this.container.getGroupMemberIDs();
    }

    public void sendCreate(ID toContainerID, ReplicaSharedObjectDescription sd) throws IOException {
        if (this.isInactive()) {
            this.trace("sendCreate(" + toContainerID + "," + sd + ") CONTEXT INACTIVE");
            return;
        }
        this.trace("sendCreate(" + toContainerID + "," + sd + ")");
        this.container.sendCreate(this.sharedObjectID, toContainerID, (SharedObjectDescription)sd);
    }

    public void sendCreateResponse(ID toContainerID, Throwable throwable, long identifier) throws IOException {
        if (this.isInactive()) {
            this.trace("sendCreateResponse(" + toContainerID + "," + throwable + "," + identifier + ") CONTEXT INACTIVE");
            return;
        }
        this.trace("sendCreateResponse(" + toContainerID + "," + throwable + "," + identifier + ")");
        this.container.sendCreateResponse(toContainerID, this.sharedObjectID, throwable, identifier);
    }

    public void sendDispose(ID toContainerID) throws IOException {
        if (this.isInactive()) {
            this.trace("sendDispose(" + toContainerID + ") CONTEXT INACTIVE");
            return;
        }
        this.trace("sendDispose(" + toContainerID + ")");
        this.container.sendDispose(toContainerID, this.sharedObjectID);
    }

    public void sendMessage(ID toContainerID, Object data) throws IOException {
        if (this.isInactive()) {
            this.trace("sendMessage(" + toContainerID + "," + data + ") CONTEXT INACTIVE");
            return;
        }
        this.trace("sendMessage(" + toContainerID + "," + data + ") CONTEXT ACTIVE");
        this.container.sendMessage(toContainerID, this.sharedObjectID, data);
    }

    public Object getAdapter(Class clazz) {
        return this.container.getAdapter(clazz);
    }

    public Namespace getConnectNamespace() {
        if (this.isInactive()) {
            return null;
        }
        return this.container.getConnectNamespace();
    }

    public Map getLocalContainerProperties() {
        if (this.isInactive()) {
            return new HashMap();
        }
        return this.container.createContainerPropertiesForSharedObject(this.sharedObjectID);
    }
}

