/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SSLXMPPConnection;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

class PacketWriter {
    private Thread writerThread;
    private Writer writer;
    private XMPPConnection connection;
    private final LinkedList queue;
    private boolean done = false;
    private final List listeners = new ArrayList();
    private boolean listenersDeleted = false;
    private long lastActive = System.currentTimeMillis();
    private final List interceptors = new ArrayList();
    private boolean interceptorDeleted = false;

    protected PacketWriter(XMPPConnection connection) {
        this.connection = connection;
        this.writer = connection.writer;
        this.queue = new LinkedList();
        this.writerThread = new Thread(){

            public void run() {
                PacketWriter.this.writePackets();
            }
        };
        this.writerThread.setName("Smack Packet Writer");
        this.writerThread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) {
        if (!this.done) {
            this.processInterceptors(packet);
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.addFirst(packet);
                this.queue.notifyAll();
            }
            this.processListeners(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacketListener(PacketListener packetListener, PacketFilter packetFilter) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(new ListenerWrapper(packetListener, packetFilter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePacketListener(PacketListener packetListener) {
        List list = this.listeners;
        synchronized (list) {
            int i = 0;
            while (i < this.listeners.size()) {
                ListenerWrapper wrapper = (ListenerWrapper)this.listeners.get(i);
                if (wrapper != null && wrapper.packetListener.equals(packetListener)) {
                    this.listeners.set(i, null);
                    this.listenersDeleted = true;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPacketListenerCount() {
        List list = this.listeners;
        synchronized (list) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacketInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        List list = this.interceptors;
        synchronized (list) {
            this.interceptors.add(new InterceptorWrapper(packetInterceptor, packetFilter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePacketInterceptor(PacketInterceptor packetInterceptor) {
        List list = this.interceptors;
        synchronized (list) {
            int i = 0;
            while (i < this.interceptors.size()) {
                InterceptorWrapper wrapper = (InterceptorWrapper)this.interceptors.get(i);
                if (wrapper != null && wrapper.packetInterceptor.equals(packetInterceptor)) {
                    this.interceptors.set(i, null);
                    this.interceptorDeleted = true;
                }
                ++i;
            }
        }
    }

    public void startup() {
        this.writerThread.start();
    }

    void startKeepAliveProcess() {
        int keepAliveInterval = SmackConfiguration.getKeepAliveInterval();
        if (keepAliveInterval > 0) {
            Thread keepAliveThread = new Thread(new KeepAliveTask(keepAliveInterval));
            keepAliveThread.setDaemon(true);
            keepAliveThread.start();
        }
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void shutdown() {
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Packet nextPacket() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            while (true) {
                if (this.done || this.queue.size() != 0) {
                    if (this.queue.size() <= 0) break;
                    return (Packet)this.queue.removeLast();
                }
                try {
                    this.queue.wait(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private void writePackets() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 106->112)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processListeners(Packet packet) {
        int i;
        List list = this.listeners;
        synchronized (list) {
            if (this.listenersDeleted) {
                i = this.listeners.size() - 1;
                while (i >= 0) {
                    if (this.listeners.get(i) == null) {
                        this.listeners.remove(i);
                    }
                    --i;
                }
                this.listenersDeleted = false;
            }
        }
        int size = this.listeners.size();
        i = 0;
        while (i < size) {
            ListenerWrapper listenerWrapper = (ListenerWrapper)this.listeners.get(i);
            if (listenerWrapper != null) {
                listenerWrapper.notifyListener(packet);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInterceptors(Packet packet) {
        if (packet != null) {
            int i;
            List list = this.interceptors;
            synchronized (list) {
                if (this.interceptorDeleted) {
                    i = this.interceptors.size() - 1;
                    while (i >= 0) {
                        if (this.interceptors.get(i) == null) {
                            this.interceptors.remove(i);
                        }
                        --i;
                    }
                    this.interceptorDeleted = false;
                }
            }
            int size = this.interceptors.size();
            i = 0;
            while (i < size) {
                InterceptorWrapper interceptorWrapper = (InterceptorWrapper)this.interceptors.get(i);
                if (interceptorWrapper != null) {
                    interceptorWrapper.notifyListener(packet);
                }
                ++i;
            }
        }
    }

    void openStream() throws IOException {
        StringBuffer stream = new StringBuffer();
        stream.append("<stream:stream");
        stream.append(" to=\"").append(this.connection.serviceName).append("\"");
        stream.append(" xmlns=\"jabber:client\"");
        stream.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
        if (this.connection instanceof SSLXMPPConnection) {
            stream.append(">");
        } else {
            stream.append(" version=\"1.0\">");
        }
        this.writer.write(stream.toString());
        this.writer.flush();
    }

    private static class InterceptorWrapper {
        private PacketInterceptor packetInterceptor;
        private PacketFilter packetFilter;

        public InterceptorWrapper(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
            this.packetInterceptor = packetInterceptor;
            this.packetFilter = packetFilter;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof InterceptorWrapper) {
                return ((InterceptorWrapper)object).packetInterceptor.equals(this.packetInterceptor);
            }
            if (object instanceof PacketInterceptor) {
                return object.equals(this.packetInterceptor);
            }
            return false;
        }

        public void notifyListener(Packet packet) {
            if (this.packetFilter == null || this.packetFilter.accept(packet)) {
                this.packetInterceptor.interceptPacket(packet);
            }
        }
    }

    private class KeepAliveTask
    implements Runnable {
        private int delay;

        public KeepAliveTask(int delay) {
            this.delay = delay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {}
            while (!PacketWriter.this.done) {
                Writer writer = PacketWriter.this.writer;
                synchronized (writer) {
                    if (System.currentTimeMillis() - PacketWriter.this.lastActive >= (long)this.delay) {
                        try {
                            PacketWriter.this.writer.write(" ");
                            PacketWriter.this.writer.flush();
                        }
                        catch (Exception exception) {}
                    }
                }
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static class ListenerWrapper {
        private PacketListener packetListener;
        private PacketFilter packetFilter;

        public ListenerWrapper(PacketListener packetListener, PacketFilter packetFilter) {
            this.packetListener = packetListener;
            this.packetFilter = packetFilter;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof ListenerWrapper) {
                return ((ListenerWrapper)object).packetListener.equals(this.packetListener);
            }
            if (object instanceof PacketListener) {
                return object.equals(this.packetListener);
            }
            return false;
        }

        public void notifyListener(Packet packet) {
            if (this.packetFilter == null || this.packetFilter.accept(packet)) {
                this.packetListener.processPacket(packet);
            }
        }
    }
}

