/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.discovery;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.internal.osgi.services.discovery.ServicePublicationHandler;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.osgi.services.discovery";
    private static final long DISCOVERY_TIMEOUT = 5000L;
    private ServiceTracker servicePublicationTracker;
    private ServiceTracker locatorTracker;
    private ServiceTracker advertiserTracker;
    private ServiceTracker discoveredServiceTrackerTracker;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;
    private BundleContext context;
    private static Activator plugin;
    private ServicePublicationHandler servicePublicationHandler;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public static final Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext ctxt) throws Exception {
        plugin = this;
        this.context = ctxt;
        this.servicePublicationHandler = new ServicePublicationHandler();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.discovery.ServicePublication");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.servicePublicationTracker = new ServiceTracker(this.context, clazz.getName(), (ServiceTrackerCustomizer)this.servicePublicationHandler);
        this.servicePublicationTracker.open();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.remote.discovery.vendor", "Eclipse.org");
        ((Dictionary)props).put("osgi.remote.discovery.product", "ECF Discovery");
        ((Dictionary)props).put("osgi.remote.discovery.product.version", "1.0.0");
        ((Dictionary)props).put("osgi.remote.discovery.supported_protocols", "SLP|mDNS|DNS-SRV");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.discovery.Discovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ctxt.registerService(clazz2.getName(), (Object)this.servicePublicationHandler, props);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.ecf.discovery.IDiscoveryLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.locatorTracker = new ServiceTracker(this.context, clazz3.getName(), (ServiceTrackerCustomizer)new LocatorTrackerCustomizer());
        this.locatorTracker.open();
        IDiscoveryLocator locator = (IDiscoveryLocator)this.locatorTracker.getService();
        if (locator != null) {
            locator.addServiceListener((IServiceListener)this.servicePublicationHandler);
        }
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService(PLUGIN_ID);
        }
        return this.logService;
    }

    public void log(IStatus status) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(null, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public void log(ServiceReference sr, IStatus status) {
        this.log(sr, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
    }

    public void log(ServiceReference sr, int level, String message, Throwable t) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(sr, level, message, t);
        }
    }

    BundleContext getContext() {
        return this.context;
    }

    public ServicePublicationHandler getServicePublicationHandler() {
        return this.servicePublicationHandler;
    }

    public IDiscoveryAdvertiser getAdvertiser() throws InterruptedException {
        if (this.advertiserTracker == null) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.ecf.discovery.IDiscoveryAdvertiser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.advertiserTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.advertiserTracker.open();
        }
        return (IDiscoveryAdvertiser)this.advertiserTracker.waitForService(5000L);
    }

    public ServiceReference[] getDiscoveredServiceTrackerReferences() {
        if (this.discoveredServiceTrackerTracker == null) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.osgi.service.discovery.DiscoveredServiceTracker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.discoveredServiceTrackerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.discoveredServiceTrackerTracker.open();
        }
        return this.discoveredServiceTrackerTracker.getServiceReferences();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.discoveredServiceTrackerTracker != null) {
            this.discoveredServiceTrackerTracker.close();
            this.discoveredServiceTrackerTracker = null;
        }
        if (this.locatorTracker != null) {
            this.locatorTracker.close();
            this.locatorTracker = null;
        }
        if (this.advertiserTracker != null) {
            this.advertiserTracker.close();
            this.advertiserTracker = null;
        }
        if (this.servicePublicationTracker != null) {
            this.servicePublicationTracker.close();
            this.servicePublicationTracker = null;
        }
        if (this.servicePublicationHandler != null) {
            this.servicePublicationHandler.dispose();
            this.servicePublicationHandler = null;
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        this.context = null;
        plugin = null;
    }

    private class LocatorTrackerCustomizer
    implements ServiceTrackerCustomizer {
        private LocatorTrackerCustomizer() {
        }

        public Object addingService(ServiceReference reference) {
            IDiscoveryLocator locator = (IDiscoveryLocator)Activator.this.context.getService(reference);
            locator.addServiceListener((IServiceListener)Activator.this.servicePublicationHandler);
            return locator;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
        }
    }
}

