/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.PlatformHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.internal.osgi.services.distribution.DiscoveredServiceTrackerImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.EventHookImpl;
import org.eclipse.ecf.osgi.services.distribution.IHostContainerFinder;
import org.eclipse.ecf.osgi.services.distribution.IProxyContainerFinder;
import org.eclipse.equinox.concurrent.future.IExecutor;
import org.eclipse.equinox.concurrent.future.ThreadsExecutor;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.osgi.services.distribution";
    private static Activator plugin;
    private BundleContext context;
    private ServiceTracker containerManagerTracker;
    private DistributionProviderImpl distributionProvider;
    private ServiceRegistration eventHookRegistration;
    private ServiceRegistration distributionProviderRegistration;
    private ServiceRegistration discoveredServiceTrackerRegistration;
    private ServiceRegistration proxyrsContainerFinderRegistration;
    private ServiceRegistration hostrsContainerFinderRegistration;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;
    private ServiceTracker adapterManagerTracker;
    private ServiceTracker proxyrsContainerFinder;
    private ServiceTracker hostrsContainerFinder;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public static Activator getDefault() {
        return plugin;
    }

    public BundleContext getContext() {
        return this.context;
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService(PLUGIN_ID);
        }
        return this.logService;
    }

    public void log(IStatus status) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(null, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public void log(ServiceReference sr, IStatus status) {
        this.log(sr, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
    }

    public void log(ServiceReference sr, int level, String message, Throwable t) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(sr, level, message, t);
        }
    }

    public void start(BundleContext ctxt) throws Exception {
        plugin = this;
        this.context = ctxt;
        this.distributionProvider = new DistributionProviderImpl();
        this.addDiscoveredServiceTracker();
        this.addServiceRegistryHooks();
        this.addDistributionProvider();
    }

    private void addDiscoveredServiceTracker() {
        DiscoveredServiceTrackerImpl dstImpl = new DiscoveredServiceTrackerImpl(this.distributionProvider, (IExecutor)new ThreadsExecutor());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.discovery.DiscoveredServiceTracker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.discoveredServiceTrackerRegistration = this.context.registerService(clazz.getName(), (Object)dstImpl, null);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ecf.osgi.services.distribution.IProxyContainerFinder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.proxyrsContainerFinderRegistration = this.context.registerService(clazz2.getName(), (Object)dstImpl, null);
    }

    private void addServiceRegistryHooks() {
        EventHookImpl hook = new EventHookImpl(this.distributionProvider);
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.osgi.framework.hooks.service.EventHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventHookRegistration = this.context.registerService(clazz.getName(), (Object)hook, null);
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("org.eclipse.ecf.osgi.services.distribution.IHostContainerFinder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.hostrsContainerFinderRegistration = this.context.registerService(clazz2.getName(), (Object)hook, null);
        try {
            ServiceReference[] refs = this.context.getServiceReferences(null, "(osgi.remote.interfaces=*)");
            if (refs != null) {
                int i = 0;
                while (i < refs.length) {
                    hook.handleRegisteredServiceEvent(refs[i], null);
                    ++i;
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    private void addDistributionProvider() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.remote.distribution.vendor", DistributionProviderImpl.VENDOR_NAME);
        ((Dictionary)properties).put("osgi.remote.distribution.product", DistributionProviderImpl.PRODUCT_NAME);
        ((Dictionary)properties).put("osgi.remote.distribution.product.version", DistributionProviderImpl.PRODUCT_VERSION);
        ((Dictionary)properties).put("osgi.remote.distribition.supported_intents", this.distributionProvider.getSupportedIntents());
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.osgi.service.distribution.DistributionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.distributionProviderRegistration = this.context.registerService(clazz.getName(), (Object)this.distributionProvider, properties);
    }

    private void removeServiceRegistryHooks() {
        if (this.eventHookRegistration != null) {
            this.eventHookRegistration.unregister();
            this.eventHookRegistration = null;
        }
        if (this.hostrsContainerFinderRegistration != null) {
            this.hostrsContainerFinderRegistration.unregister();
            this.hostrsContainerFinderRegistration = null;
        }
    }

    private void removeDistributionProvider() {
        if (this.distributionProviderRegistration != null) {
            this.distributionProviderRegistration.unregister();
            this.distributionProviderRegistration = null;
        }
    }

    private void removeDiscoveredServiceTracker() {
        if (this.discoveredServiceTrackerRegistration != null) {
            this.discoveredServiceTrackerRegistration.unregister();
            this.discoveredServiceTrackerRegistration = null;
        }
        if (this.proxyrsContainerFinderRegistration != null) {
            this.proxyrsContainerFinderRegistration.unregister();
            this.proxyrsContainerFinderRegistration = null;
        }
    }

    public void stop(BundleContext ctxt) throws Exception {
        this.removeDiscoveredServiceTracker();
        this.removeDistributionProvider();
        this.removeServiceRegistryHooks();
        if (this.containerManagerTracker != null) {
            this.containerManagerTracker.close();
            this.containerManagerTracker = null;
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        if (this.distributionProvider != null) {
            this.distributionProvider.dispose();
            this.distributionProvider = null;
        }
        if (this.proxyrsContainerFinder != null) {
            this.proxyrsContainerFinder.close();
            this.proxyrsContainerFinder = null;
        }
        this.context = null;
        plugin = null;
    }

    public IContainerManager getContainerManager() {
        if (this.containerManagerTracker == null) {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("org.eclipse.ecf.core.IContainerManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.containerManagerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.containerManagerTracker.open();
        }
        return (IContainerManager)this.containerManagerTracker.getService();
    }

    public synchronized IProxyContainerFinder[] getProxyRemoteServiceContainerFinders() {
        if (this.proxyrsContainerFinder == null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ecf.osgi.services.distribution.IProxyContainerFinder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.proxyrsContainerFinder = new ServiceTracker(this.context, clazz.getName(), null);
            this.proxyrsContainerFinder.open();
        }
        Object[] svcs = this.proxyrsContainerFinder.getServices();
        return Arrays.asList(svcs).toArray(new IProxyContainerFinder[0]);
    }

    public synchronized IHostContainerFinder[] getHostRemoteServiceContainerFinders() {
        if (this.hostrsContainerFinder == null) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.ecf.osgi.services.distribution.IHostContainerFinder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.hostrsContainerFinder = new ServiceTracker(this.context, clazz.getName(), null);
            this.hostrsContainerFinder.open();
        }
        Object[] svcs = this.hostrsContainerFinder.getServices();
        return Arrays.asList(svcs).toArray(new IHostContainerFinder[0]);
    }

    public IAdapterManager getAdapterManager() {
        IAdapterManager adapterManager;
        if (this.adapterManagerTracker == null) {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("org.eclipse.core.runtime.IAdapterManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.adapterManagerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.adapterManagerTracker.open();
        }
        if ((adapterManager = (IAdapterManager)this.adapterManagerTracker.getService()) == null) {
            adapterManager = PlatformHelper.getPlatformAdapterManager();
        }
        return adapterManager;
    }
}

