/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.DiscoveredServiceID;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.RemoteServiceRegistration;
import org.eclipse.ecf.osgi.services.discovery.ECFServiceEndpointDescription;
import org.eclipse.ecf.osgi.services.discovery.IServiceEndpointDescription;
import org.eclipse.ecf.osgi.services.distribution.IProxyContainerFinder;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.RemoteServiceContainer;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceUnregisteredEvent;
import org.eclipse.equinox.concurrent.future.IExecutor;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.discovery.DiscoveredServiceNotification;
import org.osgi.service.discovery.DiscoveredServiceTracker;
import org.osgi.service.discovery.ServiceEndpointDescription;

public class DiscoveredServiceTrackerImpl
implements DiscoveredServiceTracker,
IProxyContainerFinder {
    DistributionProviderImpl distributionProvider;
    IExecutor executor;
    IProgressMonitor executorProgressMonitor;
    List serviceLocations = new ArrayList();
    Map discoveredRemoteServiceRegistrations = Collections.synchronizedMap(new HashMap());
    List ecfRemoteServiceProperties = Arrays.asList("ecf.rsvc.id", "ecf.robjectClass", "osgi.remote.endpoint.id", "osgi.remote.endpoint.interface", "osgi.remote.endpoint.location", "service.interface", "service.interface.version", "service.properties");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDiscoveredServiceID(ECFServiceEndpointDescription desc) {
        if (desc == null) {
            return false;
        }
        List list = this.serviceLocations;
        synchronized (list) {
            return this.serviceLocations.add(new DiscoveredServiceID(desc.getServiceID().getLocation(), desc.getRemoteServiceId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeDiscoveredServiceID(ECFServiceEndpointDescription desc) {
        if (desc == null) {
            return false;
        }
        List list = this.serviceLocations;
        synchronized (list) {
            return this.serviceLocations.remove(new DiscoveredServiceID(desc.getServiceID().getLocation(), desc.getRemoteServiceId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsDiscoveredServiceID(ECFServiceEndpointDescription desc) {
        if (desc == null) {
            return false;
        }
        List list = this.serviceLocations;
        synchronized (list) {
            return this.serviceLocations.contains(new DiscoveredServiceID(desc.getServiceID().getLocation(), desc.getRemoteServiceId()));
        }
    }

    public DiscoveredServiceTrackerImpl(DistributionProviderImpl dp, IExecutor executor) {
        this.distributionProvider = dp;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serviceChanged(DiscoveredServiceNotification notification) {
        if (notification == null) {
            this.logWarning("serviceChanged", "DiscoveredServiceNotification is null.  Ignoring");
            return;
        }
        int notificationType = notification.getType();
        ServiceEndpointDescription notificationDescription = notification.getServiceEndpointDescription();
        this.trace("serviceChanged", "type=" + notificationType + ",notificationDescription=" + notificationDescription);
        switch (notificationType) {
            case 1: {
                ECFServiceEndpointDescription adesc = null;
                try {
                    adesc = this.getECFserviceEndpointDescription(notificationDescription);
                }
                catch (Exception e) {
                    this.logError("serviceChanged.AVAILABLE", "Error creating ECF endpoint description", e);
                    return;
                }
                if (adesc == null) {
                    return;
                }
                if (!this.isValidService(adesc)) {
                    this.logWarning("serviceChanged.AVAILABLE", "Duplicate or invalid description=" + adesc);
                    return;
                }
                final ECFServiceEndpointDescription ecfASED = adesc;
                this.executor.execute(new IProgressRunnable(){

                    public Object run(IProgressMonitor monitor) throws Exception {
                        try {
                            DiscoveredServiceTrackerImpl.this.handleDiscoveredServiceAvailable(ecfASED, monitor);
                        }
                        catch (Exception e) {
                            DiscoveredServiceTrackerImpl.this.logError("handleDiscoveredServiceAvailble", "Unexpected exception with ecfSED=" + ecfASED, e);
                            throw e;
                        }
                        return null;
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
                return;
            }
            case 4: {
                try {
                    ECFServiceEndpointDescription udesc = this.getECFserviceEndpointDescription(notificationDescription);
                    if (udesc == null) {
                        return;
                    }
                    List list = this.serviceLocations;
                    synchronized (list) {
                        ServiceRegistration[] proxyServiceRegistrations = this.removeProxyServiceRegistrations((ServiceEndpointDescription)udesc);
                        if (proxyServiceRegistrations == null) return;
                        int i = 0;
                        while (i < proxyServiceRegistrations.length) {
                            this.trace("handleDiscoveredServiceUnavailable", "proxyServiceRegistrations=" + proxyServiceRegistrations[i] + ",serviceEndpointDesc=" + udesc);
                            this.unregisterProxyServiceRegistration(proxyServiceRegistrations[i]);
                            ++i;
                        }
                        this.removeDiscoveredServiceID(udesc);
                        return;
                    }
                }
                catch (Exception e) {
                    this.logError("serviceChanged", "UNAVAILABLE", e);
                }
                return;
            }
            case 2: {
                return;
            }
            case 8: {
                return;
            }
            default: {
                this.logWarning("serviceChanged", "DiscoveredServiceNotification type=" + notificationType + " not found.  Ignoring");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidService(ECFServiceEndpointDescription desc) {
        if (desc == null) {
            return false;
        }
        List list = this.serviceLocations;
        synchronized (list) {
            block5: {
                if (!this.containsDiscoveredServiceID(desc)) break block5;
                return false;
            }
            this.addDiscoveredServiceID(desc);
            return true;
        }
    }

    private IRemoteServiceContainer[] findRemoteServiceContainersViaService(IServiceID serviceID, IServiceEndpointDescription description, IProgressMonitor monitor) {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return new IRemoteServiceContainer[0];
        }
        IProxyContainerFinder[] finders = activator.getProxyRemoteServiceContainerFinders();
        if (finders == null || finders.length == 0) {
            this.logError("findRemoteServiceContainersViaService", "No container finders available");
            return new IRemoteServiceContainer[0];
        }
        ArrayList<IRemoteServiceContainer> result = new ArrayList<IRemoteServiceContainer>();
        int i = 0;
        while (i < finders.length) {
            IRemoteServiceContainer[] foundRSContainers = finders[i].findProxyContainers(serviceID, description, monitor);
            if (foundRSContainers != null && foundRSContainers.length > 0) {
                this.trace("findRemoteServiceContainersViaService", "findRemoteServiceContainers finder=" + finders[i] + " ecfSED=" + description + " foundRSContainers=" + Arrays.asList(foundRSContainers));
                int j = 0;
                while (j < foundRSContainers.length) {
                    result.add(foundRSContainers[j]);
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IRemoteServiceContainer[0]);
    }

    private void handleDiscoveredServiceAvailable(ECFServiceEndpointDescription ecfSED, IProgressMonitor monitor) {
        IRemoteServiceContainer[] rsContainers = this.findRemoteServiceContainersViaService(ecfSED.getServiceID(), (IServiceEndpointDescription)ecfSED, monitor);
        if (rsContainers == null || rsContainers.length == 0) {
            this.logError("handleDiscoveredServiceAvailable", "No RemoteServiceContainerAdapters found for description=" + ecfSED, null);
            return;
        }
        if (rsContainers.length > 1) {
            this.logWarning("handleDiscoveredServiceAvailable", "Multiple remote service containers=" + Arrays.asList(rsContainers) + " found for service endpoint description=" + ecfSED);
        }
        ID ecfEndpointID = ecfSED.getECFEndpointID();
        String remoteServiceFilter = ecfSED.getECFRemoteServicesFilter();
        Collection providedInterfaces = ecfSED.getProvidedInterfaces();
        int i = 0;
        while (i < rsContainers.length) {
            Iterator j = providedInterfaces.iterator();
            while (j.hasNext()) {
                String providedInterface = (String)j.next();
                IRemoteServiceReference[] remoteReferences = null;
                try {
                    remoteReferences = rsContainers[i].getContainerAdapter().getRemoteServiceReferences(ecfEndpointID, providedInterface, remoteServiceFilter);
                }
                catch (ContainerConnectException e) {
                    this.logError("handleDiscoveredServiceAvailable", "rsca=" + rsContainers[i] + ",endpointId=" + ecfEndpointID + ",intf=" + providedInterface + ". Connect error in getRemoteServiceReferences", e);
                    continue;
                }
                catch (InvalidSyntaxException e) {
                    this.logError("handleDiscoveredServiceAvailable", "rsca=" + rsContainers[i] + ",endpointId=" + ecfEndpointID + ",intf=" + providedInterface + " Filter syntax error in getRemoteServiceReferences", e);
                    continue;
                }
                if (remoteReferences == null || remoteReferences.length == 0) {
                    this.logError("handleDiscoveredServiceAvailable", "getRemoteServiceReferences result is empty. containerHelper=" + rsContainers[i] + "remoteReferences=" + (remoteReferences == null ? "null" : Arrays.asList(remoteReferences).toString()), null);
                    continue;
                }
                this.registerRemoteServiceReferences(ecfSED, rsContainers[i], remoteReferences);
            }
            ++i;
        }
    }

    private ECFServiceEndpointDescription getECFserviceEndpointDescription(ServiceEndpointDescription aServiceEndpointDesc) {
        ECFServiceEndpointDescription ecfSED;
        if (!(aServiceEndpointDesc instanceof ECFServiceEndpointDescription)) {
            IAdapterManager iAdapterManager = Activator.getDefault().getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.osgi.services.discovery.ECFServiceEndpointDescription");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ecfSED = (ECFServiceEndpointDescription)iAdapterManager.loadAdapter((Object)aServiceEndpointDesc, clazz.getName());
        } else {
            ecfSED = (ECFServiceEndpointDescription)aServiceEndpointDesc;
        }
        return ecfSED;
    }

    private boolean findProxyServiceRegistration(ServiceEndpointDescription sed) {
        Iterator i = this.discoveredRemoteServiceRegistrations.keySet().iterator();
        while (i.hasNext()) {
            ID containerID = (ID)i.next();
            RemoteServiceRegistration reg = (RemoteServiceRegistration)this.discoveredRemoteServiceRegistrations.get(containerID);
            if (!sed.equals(reg.getServiceEndpointDescription())) continue;
            return true;
        }
        return false;
    }

    private ServiceRegistration[] removeProxyServiceRegistrations(ServiceEndpointDescription sed) {
        ArrayList results = new ArrayList();
        Iterator i = this.discoveredRemoteServiceRegistrations.keySet().iterator();
        while (i.hasNext()) {
            ID containerID = (ID)i.next();
            RemoteServiceRegistration reg = (RemoteServiceRegistration)this.discoveredRemoteServiceRegistrations.get(containerID);
            if (!sed.equals(reg.getServiceEndpointDescription())) continue;
            i.remove();
            results.addAll(reg.removeAllServiceRegistrations());
            reg.dispose();
        }
        return results.toArray(new ServiceRegistration[0]);
    }

    private void unregisterProxyServiceRegistration(ServiceRegistration reg) {
        try {
            this.distributionProvider.removeRemoteService(reg.getReference());
            reg.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            this.logWarning("unregisterProxyServiceRegistration", "Exception unregistering serviceRegistration=" + reg);
        }
        catch (Exception e) {
            this.logError("unregisterProxyServiceRegistration", "Exception unregistering serviceRegistration=" + reg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRemoteServiceReferences(ECFServiceEndpointDescription sed, IRemoteServiceContainer ch, IRemoteServiceReference[] remoteReferences) {
        List list = this.serviceLocations;
        synchronized (list) {
            if (!this.containsDiscoveredServiceID(sed)) {
                this.logError("registerRemoteServiceReferences", "serviceLocation=" + sed + " no longer present", null);
                return;
            }
            if (this.findProxyServiceRegistration((ServiceEndpointDescription)sed)) {
                this.logError("registerRemoteServiceReferences", "serviceEndpointDesc=" + sed + " previously registered locally...ignoring", null);
                return;
            }
            int i = 0;
            while (i < remoteReferences.length) {
                IRemoteService remoteService = ch.getContainerAdapter().getRemoteService(remoteReferences[i]);
                if (remoteService == null) {
                    this.logError("registerRemoteServiceReferences", "Remote service is null for remote reference " + remoteReferences[i], null);
                } else {
                    String[] clazzes = (String[])remoteReferences[i].getProperty("ecf.robjectClass");
                    if (clazzes == null || clazzes.length == 0) {
                        this.logError("registerRemoteServiceReferences", "No classes specified for remote service reference " + remoteReferences[i], null);
                    } else {
                        Dictionary properties = this.getPropertiesForRemoteService((ServiceEndpointDescription)sed, ch.getContainerAdapter(), remoteReferences[i], remoteService);
                        Object proxy = null;
                        try {
                            proxy = remoteService.getProxy();
                            if (proxy == null) {
                                this.logError("registerRemoteServiceReferences", "Remote service proxy is null", null);
                            } else {
                                this.trace("registerRemoteServiceReferences", "rsca=" + ch + ",remoteReference=" + remoteReferences[i]);
                                ServiceRegistration registration = Activator.getDefault().getContext().registerService(clazzes, proxy, properties);
                                IRemoteServiceReference ref = remoteReferences[i];
                                ID containerID = ch.getContainer().getID();
                                RemoteServiceRegistration reg = (RemoteServiceRegistration)this.discoveredRemoteServiceRegistrations.get(containerID);
                                if (reg == null) {
                                    reg = new RemoteServiceRegistration(sed, ch, new RemoteServiceReferenceUnregisteredListener());
                                    this.discoveredRemoteServiceRegistrations.put(containerID, reg);
                                }
                                reg.addServiceRegistration(ref, registration);
                                this.distributionProvider.addRemoteService(registration.getReference());
                                this.trace("addLocalServiceRegistration.COMPLETE", "containerHelper=" + ch + ",remoteServiceReference=" + ref + ",localServiceRegistration=" + registration);
                            }
                        }
                        catch (Exception e) {
                            this.logError("registerRemoteServiceReferences", "Exception creating or registering remote reference " + remoteReferences[i], e);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private boolean isRemoteServiceProperty(String propertyKey) {
        return this.ecfRemoteServiceProperties.contains(propertyKey);
    }

    private Dictionary getPropertiesForRemoteService(ServiceEndpointDescription description, IRemoteServiceContainerAdapter containerAdapter, IRemoteServiceReference remoteReference, IRemoteService remoteService) {
        Properties results = new Properties();
        String[] propKeys = remoteReference.getPropertyKeys();
        int i = 0;
        while (i < propKeys.length) {
            if (!this.isRemoteServiceProperty(propKeys[i])) {
                results.put(propKeys[i], remoteReference.getProperty(propKeys[i]));
            }
            ++i;
        }
        results.put("osgi.remote", remoteService);
        return results;
    }

    protected void trace(String methodName, String message) {
        Trace.trace((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug/discoveredservicetracker", this.getClass(), (String)methodName, (String)message);
    }

    protected void traceException(String methodName, String message, Throwable t) {
        Trace.catching((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug/exceptions/catching", this.getClass(), (String)(String.valueOf(methodName == null ? "<unknown>" : methodName) + ":" + (message == null ? "<empty>" : message)), (Throwable)t);
    }

    protected void logError(String methodName, String message, Throwable t) {
        if (t != null) {
            this.traceException(methodName, message, t);
        } else {
            this.trace(methodName, message);
        }
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.osgi.services.distribution", 4, String.valueOf(this.getClass().getName()) + ":" + (methodName == null ? "<unknown>" : methodName) + ":" + (message == null ? "<empty>" : message), t));
    }

    protected void logError(String methodName, String message) {
        this.logError(methodName, message, null);
        this.traceException(methodName, message, null);
    }

    private void logWarning(String methodName, String message) {
        this.trace(methodName, "WARNING:" + message);
        Activator activator = Activator.getDefault();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.internal.osgi.services.distribution.DiscoveredServiceTrackerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        activator.log((IStatus)new Status(2, "org.eclipse.ecf.osgi.services.distribution", 2, String.valueOf(clazz.getName()) + ":" + (methodName == null ? "<unknown>" : methodName) + ":" + (message == null ? "<empty>" : message), null));
    }

    public IRemoteServiceContainer[] findProxyContainers(IServiceID serviceID, IServiceEndpointDescription endpointDescription, IProgressMonitor monitor) {
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        if (containerManager == null) {
            return null;
        }
        IContainer[] containers = containerManager.getAllContainers();
        if (containers == null) {
            this.logWarning("findRSCAs", "No containers found for container manager");
            return new IRemoteServiceContainer[0];
        }
        ArrayList<RemoteServiceContainer> results = new ArrayList<RemoteServiceContainer>();
        int i = 0;
        while (i < containers.length) {
            ID containerID = containers[i].getID();
            if (containerID == null || !containerID.equals((Object)endpointDescription.getECFEndpointID())) {
                IRemoteServiceContainerAdapter adapter;
                IContainer iContainer = containers[i];
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (IRemoteServiceContainerAdapter)iContainer.getAdapter((Class)clazz)) != null && this.includeRCSAForDescription(containers[i], (ServiceEndpointDescription)endpointDescription)) {
                    results.add(new RemoteServiceContainer(containers[i], adapter));
                }
            }
            ++i;
        }
        return results.toArray(new IRemoteServiceContainer[0]);
    }

    private boolean includeRCSAForDescription(IContainer container, ServiceEndpointDescription description) {
        Namespace namespace;
        String connectNamespaceName = (String)description.getProperty("ecf.sp.cns");
        return connectNamespaceName != null && (namespace = container.getConnectNamespace()) != null && namespace.getName().equals(connectNamespaceName);
    }

    class RemoteServiceReferenceUnregisteredListener
    implements IRemoteServiceListener {
        RemoteServiceReferenceUnregisteredListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleServiceEvent(IRemoteServiceEvent event) {
            if (event instanceof IRemoteServiceUnregisteredEvent) {
                DiscoveredServiceTrackerImpl.this.trace("handleRemoteServiceUnregisteredEvent", "localContainerID=" + event.getLocalContainerID() + ",containerID=" + event.getContainerID() + ",remoteReference=" + event.getReference());
                ServiceRegistration[] proxyServiceRegistrations = null;
                List list = DiscoveredServiceTrackerImpl.this.serviceLocations;
                synchronized (list) {
                    RemoteServiceRegistration rsRegs = (RemoteServiceRegistration)DiscoveredServiceTrackerImpl.this.discoveredRemoteServiceRegistrations.get(event.getLocalContainerID());
                    if (rsRegs != null) {
                        proxyServiceRegistrations = rsRegs.removeServiceRegistration(event.getReference());
                        if (rsRegs.isEmpty()) {
                            rsRegs.dispose();
                            DiscoveredServiceTrackerImpl.this.discoveredRemoteServiceRegistrations.remove(event.getContainerID());
                        }
                    }
                }
                if (proxyServiceRegistrations != null) {
                    int i = 0;
                    while (i < proxyServiceRegistrations.length) {
                        DiscoveredServiceTrackerImpl.this.trace("handleRemoteServiceUnregisteredEvent.unregister", "localContainerID=" + event.getLocalContainerID() + ",containerID=" + event.getContainerID() + ",remoteReference=" + event.getReference() + ",proxyServiceRegistrations=" + proxyServiceRegistrations[i]);
                        DiscoveredServiceTrackerImpl.this.unregisterProxyServiceRegistration(proxyServiceRegistrations[i]);
                        ++i;
                    }
                }
            }
        }
    }
}

