/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.internal.osgi.services.distribution.AbstractEventHookImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.osgi.services.distribution.IHostContainerFinder;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.RemoteServiceContainer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.discovery.ServicePublication;

public class EventHookImpl
extends AbstractEventHookImpl
implements IHostContainerFinder {
    private static final List excludedProperties = Arrays.asList("service.id", "objectClass", "osgi.remote.interfaces", "osgi.remote.requires.intents", "osgi.remote", "osgi.remote.configuration.type", "ecf.rsvc.cid");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public EventHookImpl(DistributionProviderImpl distributionProvider) {
        super(distributionProvider);
    }

    protected void findContainersAndRegisterRemoteService(ServiceReference serviceReference, String[] remoteInterfaces) {
        IRemoteServiceContainer[] rsContainers;
        Object osgiRemoteConfigurationType = serviceReference.getProperty("osgi.remote.configuration.type");
        String[] remoteConfigurationType = null;
        if (osgiRemoteConfigurationType != null) {
            if (!(osgiRemoteConfigurationType instanceof String[])) {
                this.logError("handleRegisteredServiceEvent", "osgi.remote.configuration.type is not String[] as required by RFC 119");
                return;
            }
            remoteConfigurationType = (String[])osgiRemoteConfigurationType;
        }
        String[] osgiRemoteRequiresIntents = serviceReference.getProperty("osgi.remote.requires.intents");
        String[] remoteRequiresIntents = null;
        if (osgiRemoteRequiresIntents != null) {
            if (!(osgiRemoteRequiresIntents instanceof String[])) {
                this.logError("handleRegisteredServiceEvent", "service.intents is not String[] as required by RFC 119");
                return;
            }
            osgiRemoteRequiresIntents = osgiRemoteRequiresIntents;
        }
        if ((rsContainers = this.findRemoteServiceContainers(serviceReference, remoteInterfaces, remoteConfigurationType, remoteRequiresIntents)) == null || rsContainers.length == 0) {
            this.trace("registerRemoteService", "No remote service container adapters found for serviceReference=" + serviceReference);
            return;
        }
        int i = 0;
        while (i < rsContainers.length) {
            IRemoteServiceRegistration remoteRegistration = rsContainers[i].getContainerAdapter().registerRemoteService(remoteInterfaces, this.getService(serviceReference), this.getPropertiesForRemoteService(serviceReference));
            this.trace("registerRemoteService", "containerID=" + rsContainers[i].getContainer().getID() + " serviceReference=" + serviceReference + " remoteRegistration=" + remoteRegistration);
            this.fireRemoteServiceRegistered(serviceReference, remoteRegistration);
            this.publishRemoteService(rsContainers[i], serviceReference, remoteInterfaces, remoteRegistration);
            ++i;
        }
    }

    private IRemoteServiceContainer[] findRemoteServiceContainers(ServiceReference serviceReference, String[] remoteInterfaces, String[] remoteConfigurationType, String[] remoteRequiresIntents) {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        IHostContainerFinder[] finders = activator.getHostRemoteServiceContainerFinders();
        if (finders == null || finders.length == 0) {
            this.logError("findRemoteServiceContainers", "No container finders available");
            return null;
        }
        ArrayList<IRemoteServiceContainer> result = new ArrayList<IRemoteServiceContainer>();
        int i = 0;
        while (i < finders.length) {
            IRemoteServiceContainer[] foundRSContainers = finders[i].findHostContainers(serviceReference, remoteInterfaces, remoteConfigurationType, remoteRequiresIntents);
            if (foundRSContainers != null && foundRSContainers.length > 0) {
                this.trace("findRemoteServiceContainersViaService", "findRemoteServiceContainers finder=" + finders[i] + " foundRSContainers=" + Arrays.asList(foundRSContainers));
                int j = 0;
                while (j < foundRSContainers.length) {
                    result.add(foundRSContainers[j]);
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IRemoteServiceContainer[0]);
    }

    public IRemoteServiceContainer[] findHostContainers(ServiceReference serviceReference, String[] remoteInterfaces, String[] remoteConfigurationType, String[] remoteRequiresIntents) {
        Collection rsContainers = this.findRemoteContainersSatisfyingRequiredIntents(remoteRequiresIntents);
        ArrayList<IRemoteServiceContainer> results = new ArrayList<IRemoteServiceContainer>();
        Iterator i = rsContainers.iterator();
        while (i.hasNext()) {
            IRemoteServiceContainer rsContainer = (IRemoteServiceContainer)i.next();
            if (!this.includeContainer(serviceReference, rsContainer)) continue;
            results.add(rsContainer);
        }
        return results.toArray(new IRemoteServiceContainer[0]);
    }

    protected boolean includeContainer(ServiceReference serviceReference, IRemoteServiceContainer rsContainer) {
        IContainer container = rsContainer.getContainer();
        Object cID = serviceReference.getProperty("ecf.rsvc.cid");
        if (cID == null || !(cID instanceof ID)) {
            this.trace("includeContainer", "serviceReference=" + serviceReference + " does not set remote service container id service property.  INCLUDING containerID=" + container.getID() + " in remote registration");
            return true;
        }
        ID containerID = (ID)cID;
        if (container.getID().equals((Object)containerID)) {
            this.trace("includeContainer", "serviceReference=" + serviceReference + " has MATCHING container id=" + containerID + ".  INCLUDING rsca=" + container.getID() + " in remote registration");
            return true;
        }
        this.trace("includeContainer", "serviceReference=" + serviceReference + " has non-matching id=" + containerID + ".  EXCLUDING id=" + container.getID() + " in remote registration");
        return false;
    }

    private Collection findRemoteContainersSatisfyingRequiredIntents(String[] remoteRequiresIntents) {
        ArrayList<RemoteServiceContainer> results = new ArrayList<RemoteServiceContainer>();
        IContainer[] containers = Activator.getDefault().getContainerManager().getAllContainers();
        if (containers == null || containers.length == 0) {
            return null;
        }
        int i = 0;
        while (i < containers.length) {
            ContainerTypeDescription description;
            IRemoteServiceContainerAdapter adapter;
            IContainer iContainer = containers[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IRemoteServiceContainerAdapter)iContainer.getAdapter((Class)clazz)) != null && (description = Activator.getDefault().getContainerManager().getContainerTypeDescription(containers[i].getID())) != null) {
                List<String> supportedIntents = Arrays.asList(description.getSupportedIntents());
                boolean hasIntents = true;
                if (remoteRequiresIntents != null) {
                    int j = 0;
                    while (j < remoteRequiresIntents.length) {
                        if (!supportedIntents.contains(remoteRequiresIntents[j])) {
                            hasIntents = false;
                        }
                        ++j;
                    }
                }
                if (hasIntents) {
                    this.trace("findHostRemoteServiceContainers.include", "containerID=" + containers[i].getID());
                    results.add(new RemoteServiceContainer(containers[i], adapter));
                } else {
                    this.trace("findHostRemoteServiceContainers.exclude", "containerID=" + containers[i].getID() + " supported intents=" + supportedIntents);
                }
            }
            ++i;
        }
        return results;
    }

    Dictionary getServicePublicationProperties(IRemoteServiceContainer rsContainer, ServiceReference ref, String[] remoteInterfaces, IRemoteServiceRegistration remoteRegistration) {
        Namespace rsnamespace;
        Properties properties = new Properties();
        ((Dictionary)properties).put("service.interface", this.getAsCollection(remoteInterfaces));
        ((Dictionary)properties).put("service.properties", this.getServicePropertiesForRemotePublication(ref));
        IContainer container = rsContainer.getContainer();
        ID endpointID = container.getID();
        ((Dictionary)properties).put("ecf.sp.cid", container.getID());
        ID targetID = container.getConnectedID();
        if (targetID != null && !targetID.equals((Object)endpointID)) {
            ((Dictionary)properties).put("ecf.sp.tid", targetID);
        }
        if ((rsnamespace = rsContainer.getContainerAdapter().getRemoteServiceNamespace()) != null) {
            ((Dictionary)properties).put("ecf.rsvc.ns", rsnamespace.getName());
        }
        ((Dictionary)properties).put("ecf.rsvc.id", (Long)remoteRegistration.getProperty("ecf.rsvc.id"));
        return properties;
    }

    private void publishRemoteService(IRemoteServiceContainer rsContainer, final ServiceReference ref, String[] remoteInterfaces, IRemoteServiceRegistration remoteRegistration) {
        Dictionary properties = this.getServicePublicationProperties(rsContainer, ref, remoteInterfaces, remoteRegistration);
        BundleContext context = Activator.getDefault().getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.discovery.ServicePublication");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceRegistration reg = context.registerService(clazz.getName(), (Object)new ServicePublication(){

            public ServiceReference getReference() {
                return ref;
            }
        }, properties);
        this.fireRemoteServicePublished(ref, reg);
        this.trace("publishRemoteService", "containerID=" + rsContainer.getContainer().getID() + ",serviceReference=" + ref + " properties=" + properties + ",remoteRegistration=" + remoteRegistration);
    }

    private Collection getAsCollection(String[] remoteInterfaces) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < remoteInterfaces.length) {
            result.add(remoteInterfaces[i]);
            ++i;
        }
        return result;
    }

    protected Dictionary getPropertiesForRemoteService(ServiceReference sr) {
        String[] propKeys = sr.getPropertyKeys();
        Properties newProps = new Properties();
        int i = 0;
        while (i < propKeys.length) {
            if (!this.excludeRemoteServiceProperty(propKeys[i])) {
                newProps.put(propKeys[i], sr.getProperty(propKeys[i]));
            }
            ++i;
        }
        return newProps;
    }

    protected Map getServicePropertiesForRemotePublication(ServiceReference sr) {
        String[] propKeys = sr.getPropertyKeys();
        Properties newProps = new Properties();
        int i = 0;
        while (i < propKeys.length) {
            if (!this.excludeRemoteServiceProperty(propKeys[i])) {
                newProps.put(propKeys[i], sr.getProperty(propKeys[i]));
            }
            ++i;
        }
        return newProps;
    }

    private boolean excludeRemoteServiceProperty(String string) {
        return excludedProperties.contains(string);
    }
}

