/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.osgi.services.discovery.ECFServiceEndpointDescription;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.osgi.framework.ServiceRegistration;

public class RemoteServiceRegistration {
    private final ECFServiceEndpointDescription serviceEndpointDescription;
    private final IRemoteServiceContainer rsContainer;
    private IRemoteServiceListener listener;
    private Map serviceRegistrations = new HashMap();

    public RemoteServiceRegistration(ECFServiceEndpointDescription sed, IRemoteServiceContainer rsContainer, IRemoteServiceListener l) {
        this.serviceEndpointDescription = sed;
        this.rsContainer = rsContainer;
        this.listener = l;
        this.getContainerAdapter().addRemoteServiceListener(this.listener);
    }

    public ECFServiceEndpointDescription getServiceEndpointDescription() {
        return this.serviceEndpointDescription;
    }

    public IContainer getContainer() {
        return this.rsContainer.getContainer();
    }

    public IRemoteServiceContainerAdapter getContainerAdapter() {
        return this.rsContainer.getContainerAdapter();
    }

    public void dispose() {
        this.getContainerAdapter().removeRemoteServiceListener(this.listener);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("RemoteServiceRegistration[");
        buf.append("sed=").append(this.getServiceEndpointDescription());
        buf.append(";containerID=").append(this.getContainer().getID()).append("]");
        return buf.toString();
    }

    public void addServiceRegistration(IRemoteServiceReference ref, ServiceRegistration registration) {
        ArrayList<ServiceRegistration> l = (ArrayList<ServiceRegistration>)this.serviceRegistrations.get(ref.getID());
        if (l == null) {
            l = new ArrayList<ServiceRegistration>();
            this.serviceRegistrations.put(ref.getID(), l);
        }
        l.add(registration);
    }

    public ServiceRegistration[] removeServiceRegistration(IRemoteServiceReference reference) {
        List l;
        if (this.getContainerAdapter().ungetRemoteService(reference) && (l = (List)this.serviceRegistrations.remove(reference.getID())) != null) {
            return l.toArray(new ServiceRegistration[0]);
        }
        return null;
    }

    public List removeAllServiceRegistrations() {
        ArrayList results = new ArrayList();
        Iterator i = this.serviceRegistrations.keySet().iterator();
        while (i.hasNext()) {
            List l = (List)this.serviceRegistrations.get(i.next());
            if (l == null) continue;
            results.addAll(l);
        }
        return results;
    }

    public boolean isEmpty() {
        return this.serviceRegistrations.size() == 0;
    }
}

