/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.httpclient;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import javax.net.SocketFactory;
import javax.security.auth.login.LoginException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.util.DateUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.filetransfer.FileTransferJob;
import org.eclipse.ecf.filetransfer.IFileRangeSpecification;
import org.eclipse.ecf.filetransfer.IFileTransfer;
import org.eclipse.ecf.filetransfer.IFileTransferRunnable;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.InvalidFileRangeSpecificationException;
import org.eclipse.ecf.filetransfer.events.IFileTransferConnectStartEvent;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEventSource;
import org.eclipse.ecf.filetransfer.events.socket.ISocketListener;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.ConnectingSocketMonitor;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.ECFHttpClientProtocolSocketFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.ECFHttpClientSecureProtocolSocketFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.ISSLSocketFactoryModifier;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.Messages;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketEventSource;
import org.eclipse.ecf.provider.filetransfer.httpclient.HttpClientDefaultSSLSocketFactoryModifier;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferID;
import org.eclipse.ecf.provider.filetransfer.retrieve.AbstractRetrieveFileTransfer;
import org.eclipse.ecf.provider.filetransfer.retrieve.HttpHelper;
import org.eclipse.ecf.provider.filetransfer.util.JREProxyHelper;
import org.eclipse.osgi.util.NLS;

public class HttpClientRetrieveFileTransfer
extends AbstractRetrieveFileTransfer {
    private static final String USERNAME_PREFIX = Messages.HttpClientRetrieveFileTransfer_Username_Prefix;
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 120000;
    protected static final int DEFAULT_READ_TIMEOUT = 60000;
    protected static final int HTTP_PORT = 80;
    protected static final int HTTPS_PORT = 443;
    protected static final int MAX_RETRY = 2;
    protected static final String HTTPS = Messages.FileTransferNamespace_Https_Protocol;
    protected static final String HTTP = Messages.FileTransferNamespace_Http_Protocol;
    protected static final String[] supportedProtocols = new String[]{HTTP, HTTPS};
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private GzipGetMethod getMethod = null;
    private HttpClient httpClient = null;
    private String username;
    private String password;
    private int responseCode = -1;
    private volatile boolean doneFired = false;
    private String remoteFileName;
    protected int httpVersion = 1;
    protected IFileID fileid = null;
    protected JREProxyHelper proxyHelper = null;
    private HostConfigHelper hostConfigHelper;
    private SocketEventSource socketEventSource;
    private ConnectingSocketMonitor connectingSockets;
    private FileTransferJob connectJob;
    private IFileTransferRunnable fileConnectRunnable = new IFileTransferRunnable(){

        public IStatus performFileTransfer(IProgressMonitor monitor) {
            return HttpClientRetrieveFileTransfer.this.performConnect(monitor);
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public HttpClientRetrieveFileTransfer(HttpClient httpClient) {
        this.httpClient = httpClient;
        Assert.isNotNull((Object)this.httpClient);
        this.proxyHelper = new JREProxyHelper();
        this.connectingSockets = new ConnectingSocketMonitor(1);
        this.socketEventSource = new SocketEventSource(){

            public Object getAdapter(Class adapter) {
                if (adapter == null) {
                    return null;
                }
                if (adapter.isInstance((Object)this)) {
                    return this;
                }
                return HttpClientRetrieveFileTransfer.this.getAdapter(adapter);
            }
        };
    }

    public String getRemoteFileName() {
        return this.remoteFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancel() {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"cancel");
        if (this.isCanceled()) {
            return;
        }
        this.setDoneCanceled(this.exception);
        boolean fireDoneEvent = true;
        if (this.connectJob != null) {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"calling connectJob.cancel()");
            this.connectJob.cancel();
        }
        Object object = this.jobLock;
        synchronized (object) {
            if (this.job != null) {
                fireDoneEvent = false;
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"calling transfer job.cancel()");
                this.job.cancel();
            }
        }
        if (this.getMethod != null && !this.getMethod.isAborted()) {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"calling getMethod.abort()");
            this.getMethod.abort();
        }
        if (this.connectingSockets != null) {
            Iterator iterator = this.connectingSockets.getConnectingSockets().iterator();
            while (iterator.hasNext()) {
                Socket socket = (Socket)iterator.next();
                try {
                    Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("Call socket.close() for socket=" + socket.toString()));
                    socket.close();
                }
                catch (IOException e) {
                    Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/exceptions/catching", ((Object)((Object)this)).getClass(), (String)"cancel", (Throwable)e);
                }
            }
        }
        this.hardClose();
        if (fireDoneEvent) {
            this.fireTransferReceiveDoneEvent();
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"cancel");
    }

    protected void hardClose() {
        super.hardClose();
        if (this.getMethod != null) {
            this.getMethod.releaseConnection();
            this.getMethod = null;
        }
        this.responseCode = -1;
        if (this.proxyHelper != null) {
            this.proxyHelper.dispose();
            this.proxyHelper = null;
        }
    }

    protected Credentials getFileRequestCredentials() throws UnsupportedCallbackException, IOException {
        if (this.connectContext == null) {
            return null;
        }
        CallbackHandler callbackHandler = this.connectContext.getCallbackHandler();
        if (callbackHandler == null) {
            return null;
        }
        NameCallback usernameCallback = new NameCallback(USERNAME_PREFIX);
        ObjectCallback passwordCallback = new ObjectCallback();
        callbackHandler.handle(new Callback[]{usernameCallback, passwordCallback});
        this.username = usernameCallback.getName();
        this.password = (String)passwordCallback.getObject();
        return new UsernamePasswordCredentials(this.username, this.password);
    }

    protected void setupAuthentication(String urlString) throws UnsupportedCallbackException, IOException {
        Credentials credentials = null;
        if (this.username == null) {
            credentials = this.getFileRequestCredentials();
        }
        if (credentials != null && this.username != null) {
            AuthScope authScope = new AuthScope(HttpClientRetrieveFileTransfer.getHostFromURL(urlString), HttpClientRetrieveFileTransfer.getPortFromURL(urlString), AuthScope.ANY_REALM);
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("retrieve credentials=" + credentials));
            this.httpClient.getState().setCredentials(authScope, credentials);
        }
    }

    protected void setupHostAndPort(String urlString) {
        this.getHostConfiguration();
        this.hostConfigHelper.setTargetHostByURL(urlString);
    }

    protected void setRequestHeaderValues() throws InvalidFileRangeSpecificationException {
        IFileRangeSpecification rangeSpec = this.getFileRangeSpecification();
        if (rangeSpec != null) {
            long startPosition = rangeSpec.getStartPosition();
            long endPosition = rangeSpec.getEndPosition();
            if (startPosition < 0L) {
                throw new InvalidFileRangeSpecificationException(Messages.HttpClientRetrieveFileTransfer_RESUME_START_POSITION_LESS_THAN_ZERO, rangeSpec);
            }
            if (endPosition != -1L && endPosition <= startPosition) {
                throw new InvalidFileRangeSpecificationException(Messages.HttpClientRetrieveFileTransfer_RESUME_ERROR_END_POSITION_LESS_THAN_START, rangeSpec);
            }
            String rangeHeader = "bytes=" + startPosition + "-" + (endPosition == -1L ? "" : "" + endPosition);
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("retrieve range header=" + rangeHeader));
            this.setRangeHeader(rangeHeader);
        }
        this.getMethod.addRequestHeader("Cache-Control", "max-age=0");
    }

    private void setRangeHeader(String value) {
        this.getMethod.addRequestHeader("Range", value);
    }

    private boolean isHTTP11() {
        return this.httpVersion >= 1;
    }

    public int getResponseCode() {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        HttpVersion version = this.getMethod.getEffectiveVersion();
        if (version == null) {
            this.responseCode = -1;
            this.httpVersion = 1;
            return this.responseCode;
        }
        this.httpVersion = version.getMinor();
        this.responseCode = this.getMethod.getStatusCode();
        return this.responseCode;
    }

    public ID getID() {
        return this.fileid;
    }

    private long getLastModifiedTimeFromHeader() throws IOException {
        Header lastModifiedHeader = this.getMethod.getResponseHeader(LAST_MODIFIED_HEADER);
        if (lastModifiedHeader == null) {
            throw new IOException(Messages.HttpClientRetrieveFileTransfer_INVALID_LAST_MODIFIED_TIME);
        }
        String lastModifiedString = lastModifiedHeader.getValue();
        long lastModified = 0L;
        if (lastModifiedString != null) {
            try {
                lastModified = DateUtil.parseDate((String)lastModifiedString).getTime();
            }
            catch (Exception exception) {
                throw new IOException(Messages.HttpClientRetrieveFileTransfer_EXCEPITION_INVALID_LAST_MODIFIED_FROM_SERVER);
            }
        }
        return lastModified;
    }

    protected void getResponseHeaderValues() throws IOException {
        if (this.getResponseCode() == -1) {
            throw new IOException(Messages.HttpClientRetrieveFileTransfer_INVALID_SERVER_RESPONSE_TO_PARTIAL_RANGE_REQUEST);
        }
        Header lastModifiedHeader = this.getMethod.getResponseHeader(LAST_MODIFIED_HEADER);
        if (lastModifiedHeader != null) {
            this.setLastModifiedTime(this.getLastModifiedTimeFromHeader());
        }
        this.setFileLength(this.getMethod.getResponseContentLength());
        this.fileid = new FileTransferID(this.getRetrieveNamespace(), this.getRemoteFileURL());
        Header contentDispositionHeader = this.getMethod.getResponseHeader("Content-Disposition");
        if (contentDispositionHeader != null) {
            this.remoteFileName = HttpHelper.getRemoteFileNameFromContentDispositionHeader((String)contentDispositionHeader.getValue());
        }
        if (this.remoteFileName == null) {
            IPath path;
            String pathStr = this.getMethod.getPath();
            if (pathStr != null && pathStr.length() > 0 && (path = Path.fromPortableString((String)pathStr)).segmentCount() > 0) {
                this.remoteFileName = path.lastSegment();
            }
            if (this.remoteFileName == null) {
                this.remoteFileName = super.getRemoteFileName();
            }
        }
    }

    Proxy getProxy() {
        return this.proxy;
    }

    protected void setInputStream(InputStream ins) {
        this.remoteFileContents = ins;
    }

    protected InputStream wrapTransferReadInputStream(InputStream inputStream, IProgressMonitor monitor) {
        return inputStream;
    }

    protected void openStreams() throws IncomingFileTransferException {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"openStreams");
        String urlString = this.getRemoteFileURL().toString();
        this.doneFired = false;
        int code = -1;
        try {
            this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(60000);
            this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(120000);
            this.httpClient.getParams().setConnectionManagerTimeout(120000L);
            this.setupAuthentication(urlString);
            this.setupHostAndPort(urlString);
            this.getMethod = new GzipGetMethod(this.hostConfigHelper.getTargetRelativePath());
            this.getMethod.setFollowRedirects(true);
            this.getMethod.getParams().setParameter("http.authentication.credential-provider", (Object)new ECFCredentialsProvider());
            this.setRequestHeaderValues();
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("retrieve=" + urlString));
            if (this.getFileRangeSpecification() == null) {
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"Accept-Encoding: gzip added to request header");
                this.getMethod.setRequestHeader("Accept-encoding", "gzip");
            } else {
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"Accept-Encoding NOT added to header");
            }
            this.fireConnectStartEvent();
            if (this.checkAndHandleDone()) {
                return;
            }
            this.connectingSockets.clear();
            if (this.connectJob == null) {
                this.performConnect((IProgressMonitor)new NullProgressMonitor());
            } else {
                this.connectJob.schedule();
                this.connectJob.join();
                this.connectJob = null;
            }
            if (this.checkAndHandleDone()) {
                return;
            }
            code = this.responseCode;
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("retrieve resp=" + code));
            if (code != 206 && code != 200) {
                if (code == 404) {
                    this.getMethod.releaseConnection();
                    throw new FileNotFoundException(urlString);
                }
                if (code == 401) {
                    this.getMethod.releaseConnection();
                    throw new LoginException(Messages.HttpClientRetrieveFileTransfer_Unauthorized);
                }
                if (code == 403) {
                    this.getMethod.releaseConnection();
                    throw new LoginException("Forbidden");
                }
                if (code == 407) {
                    this.getMethod.releaseConnection();
                    throw new LoginException(Messages.HttpClientRetrieveFileTransfer_Proxy_Auth_Required);
                }
                this.getMethod.releaseConnection();
                throw new IOException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_ERROR_GENERAL_RESPONSE_CODE, (Object)new Integer(code)));
            }
            this.getResponseHeaderValues();
            this.setInputStream(this.getMethod.getResponseBodyAsUnzippedStream());
            this.fireReceiveStartEvent();
        }
        catch (Exception e) {
            Trace.throwing((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/exceptions/throwing", ((Object)((Object)this)).getClass(), (String)"openStreams", (Throwable)e);
            if (code == -1) {
                if (!this.isDone()) {
                    this.setDoneException(e);
                }
                this.fireTransferReceiveDoneEvent();
            }
            IncomingFileTransferException ex = new IncomingFileTransferException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_EXCEPTION_COULD_NOT_CONNECT, (Object)urlString), (Throwable)e, code);
            throw ex;
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"openStreams");
    }

    private boolean checkAndHandleDone() {
        if (this.isDone()) {
            if (!this.doneFired) {
                this.fireTransferReceiveDoneEvent();
            }
            return true;
        }
        return false;
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        super.setConnectContextForAuthentication(connectContext);
        this.username = null;
        this.password = null;
    }

    protected static String getHostFromURL(String url) {
        String result = url;
        int colonSlashSlash = url.indexOf("://");
        if (colonSlashSlash < 0) {
            return "";
        }
        if (colonSlashSlash >= 0) {
            result = url.substring(colonSlashSlash + 3);
        }
        int colonPort = result.indexOf(58);
        int requestPath = result.indexOf(47);
        int substringEnd = colonPort > 0 && requestPath > 0 ? Math.min(colonPort, requestPath) : (colonPort > 0 ? colonPort : (requestPath > 0 ? requestPath : result.length()));
        return result.substring(0, substringEnd);
    }

    protected static int getPortFromURL(String url) {
        int colonSlashSlash = url.indexOf("://");
        if (colonSlashSlash < 0) {
            return HttpClientRetrieveFileTransfer.urlUsesHttps(url) ? 443 : 80;
        }
        int colonPort = url.indexOf(58, colonSlashSlash + 1);
        if (colonPort < 0) {
            return HttpClientRetrieveFileTransfer.urlUsesHttps(url) ? 443 : 80;
        }
        int nextSlash = url.indexOf(47, colonSlashSlash + 3);
        if (nextSlash != -1 && colonPort > nextSlash) {
            return HttpClientRetrieveFileTransfer.urlUsesHttps(url) ? 443 : 80;
        }
        int requestPath = url.indexOf(47, colonPort + 1);
        int end = requestPath < 0 ? url.length() : requestPath;
        return Integer.parseInt(url.substring(colonPort + 1, end));
    }

    protected static boolean urlUsesHttps(String url) {
        return url.matches(String.valueOf(HTTPS) + ".*");
    }

    public static boolean supportsProtocol(String protocolString) {
        int i = 0;
        while (i < supportedProtocols.length) {
            if (supportedProtocols[i].equalsIgnoreCase(protocolString)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isConnected() {
        return this.getMethod != null;
    }

    protected boolean doPause() {
        if (this.isPaused() || !this.isConnected() || this.isDone()) {
            return false;
        }
        this.paused = true;
        return this.paused;
    }

    protected boolean doResume() {
        if (!this.isPaused() || this.isConnected()) {
            return false;
        }
        return this.openStreamsForResume();
    }

    protected void setResumeRequestHeaderValues() throws IOException {
        if (this.bytesReceived <= 0L || this.fileLength <= this.bytesReceived) {
            throw new IOException(Messages.HttpClientRetrieveFileTransfer_RESUME_START_ERROR);
        }
        this.setRangeHeader("bytes=" + this.bytesReceived + "-");
        this.getMethod.addRequestHeader("Cache-Control", "max-age=0");
    }

    private boolean openStreamsForResume() {
        int code;
        String urlString;
        block15: {
            block14: {
                Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"openStreamsForResume");
                urlString = this.getRemoteFileURL().toString();
                this.doneFired = false;
                code = -1;
                try {
                    this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(60000);
                    this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(120000);
                    this.httpClient.getParams().setConnectionManagerTimeout(120000L);
                    this.setupAuthentication(urlString);
                    this.setupHostAndPort(urlString);
                    this.getMethod = new GzipGetMethod(this.hostConfigHelper.getTargetRelativePath());
                    this.getMethod.setFollowRedirects(true);
                    this.getMethod.getParams().setParameter("http.authentication.credential-provider", (Object)new ECFCredentialsProvider());
                    this.setResumeRequestHeaderValues();
                    Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("resume=" + urlString));
                    this.fireConnectStartEvent();
                    if (!this.checkAndHandleDone()) break block14;
                    return false;
                }
                catch (Exception e) {
                    Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/exceptions/catching", ((Object)((Object)this)).getClass(), (String)"openStreamsForResume", (Throwable)e);
                    if (code == -1) {
                        if (!this.isDone()) {
                            this.setDoneException(e);
                        }
                    } else {
                        this.setDoneException((Exception)new IncomingFileTransferException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_EXCEPTION_COULD_NOT_CONNECT, (Object)urlString), (Throwable)e, code));
                    }
                    this.fireTransferReceiveDoneEvent();
                    Trace.exiting((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"openStreamsForResume", (Object)Boolean.FALSE);
                    return false;
                }
            }
            this.connectingSockets.clear();
            if (this.connectJob == null) {
                this.performConnect((IProgressMonitor)new NullProgressMonitor());
            } else {
                this.connectJob.schedule();
                this.connectJob.join();
                this.connectJob = null;
            }
            if (!this.checkAndHandleDone()) break block15;
            return false;
        }
        code = this.responseCode;
        Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("retrieve resp=" + code));
        if (code != 206 && code != 200) {
            if (code == 404) {
                this.getMethod.releaseConnection();
                throw new FileNotFoundException(urlString);
            }
            if (code == 401) {
                this.getMethod.releaseConnection();
                throw new LoginException(Messages.HttpClientRetrieveFileTransfer_Unauthorized);
            }
            if (code == 403) {
                this.getMethod.releaseConnection();
                throw new LoginException("Forbidden");
            }
            if (code == 407) {
                this.getMethod.releaseConnection();
                throw new LoginException(Messages.HttpClientRetrieveFileTransfer_Proxy_Auth_Required);
            }
            this.getMethod.releaseConnection();
            throw new IOException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_ERROR_GENERAL_RESPONSE_CODE, (Object)new Integer(code)));
        }
        this.getResumeResponseHeaderValues();
        this.setInputStream(this.getMethod.getResponseBodyAsUnzippedStream());
        this.paused = false;
        this.fireReceiveResumedEvent();
        Trace.exiting((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"openStreamsForResume", (Object)Boolean.TRUE);
        return true;
    }

    protected void getResumeResponseHeaderValues() throws IOException {
        if (this.getResponseCode() != 206) {
            throw new IOException();
        }
        if (this.lastModifiedTime != this.getLastModifiedTimeFromHeader()) {
            throw new IOException(Messages.HttpClientRetrieveFileTransfer_EXCEPTION_FILE_MODIFIED_SINCE_LAST_ACCESS);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.filetransfer.IFileTransferPausable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz) && this.isHTTP11()) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ecf.filetransfer.events.socket.ISocketEventSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return this.socketEventSource;
        }
        return super.getAdapter(adapter);
    }

    private HostConfiguration getHostConfiguration() {
        if (this.hostConfigHelper == null) {
            this.hostConfigHelper = new HostConfigHelper((ISocketEventSource)this.socketEventSource, this.connectingSockets);
        }
        return this.hostConfigHelper.getHostConfiguration();
    }

    protected void setupProxy(Proxy proxy) {
        if (proxy.getType().equals(Proxy.Type.HTTP)) {
            ProxyAddress address = proxy.getAddress();
            this.getHostConfiguration().setProxy(address.getHostName(), address.getPort());
            String proxyUsername = proxy.getUsername();
            String proxyPassword = proxy.getPassword();
            if (proxyUsername != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                AuthScope proxyAuthScope = new AuthScope(address.getHostName(), address.getPort(), AuthScope.ANY_REALM);
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("retrieve httpproxy=" + proxyAuthScope + ";credentials" + credentials));
                this.httpClient.getState().setProxyCredentials(proxyAuthScope, (Credentials)credentials);
            }
        } else if (proxy.getType().equals(Proxy.Type.SOCKS)) {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("retrieve socksproxy=" + proxy.getAddress()));
            this.proxyHelper.setupProxy(proxy);
        }
    }

    protected static NTCredentials createNTLMCredentials(Proxy p) {
        if (p == null) {
            return null;
        }
        String un = HttpClientRetrieveFileTransfer.getNTLMUserName(p);
        String domain = HttpClientRetrieveFileTransfer.getNTLMDomainName(p);
        if (un == null || domain == null) {
            return null;
        }
        return new NTCredentials(un, p.getPassword(), p.getAddress().getHostName(), domain);
    }

    protected static String getNTLMDomainName(Proxy p) {
        String domainUsername = p.getUsername();
        if (domainUsername == null) {
            return null;
        }
        int slashloc = domainUsername.indexOf(92);
        if (slashloc == -1) {
            return null;
        }
        return domainUsername.substring(0, slashloc);
    }

    protected static String getNTLMUserName(Proxy p) {
        String domainUsername = p.getUsername();
        if (domainUsername == null) {
            return null;
        }
        int slashloc = domainUsername.indexOf(92);
        if (slashloc == -1) {
            return null;
        }
        return domainUsername.substring(slashloc + 1);
    }

    protected void fireConnectStartEvent() {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"fireConnectStartEvent");
        this.listener.handleTransferEvent((IFileTransferEvent)new IFileTransferConnectStartEvent(){

            public IFileID getFileID() {
                return HttpClientRetrieveFileTransfer.this.remoteFileID;
            }

            public void cancel() {
                HttpClientRetrieveFileTransfer.this.cancel();
            }

            public FileTransferJob prepareConnectJob(FileTransferJob j) {
                return HttpClientRetrieveFileTransfer.this.prepareConnectJob(j);
            }

            public void connectUsingJob(FileTransferJob j) {
                HttpClientRetrieveFileTransfer.this.connectUsingJob(j);
            }

            public String toString() {
                StringBuffer sb = new StringBuffer("IFileTransferConnectStartEvent[");
                sb.append(this.getFileID());
                sb.append("]");
                return sb.toString();
            }

            public Object getAdapter(Class adapter) {
                return HttpClientRetrieveFileTransfer.this.getAdapter(adapter);
            }
        });
    }

    protected String createConnectJobName() {
        return String.valueOf(this.getRemoteFileURL().toString()) + this.createRangeName() + Messages.HttpClientRetrieveFileTransfer_CONNECTING_JOB_NAME;
    }

    protected FileTransferJob prepareConnectJob(FileTransferJob cjob) {
        if (cjob == null) {
            cjob = new FileTransferJob(this.createJobName());
        }
        cjob.setFileTransfer((IFileTransfer)this);
        cjob.setFileTransferRunnable(this.fileConnectRunnable);
        return cjob;
    }

    protected void connectUsingJob(FileTransferJob cjob) {
        Assert.isNotNull((Object)cjob);
        this.connectJob = cjob;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus performConnect(IProgressMonitor monitor) {
        int ticks = 1;
        monitor.beginTask(String.valueOf(this.getRemoteFileURL().toString()) + Messages.HttpClientRetrieveFileTransfer_CONNECTING_TASK_NAME, ticks);
        try {
            try {
                if (monitor.isCanceled()) {
                    throw this.newUserCancelledException();
                }
                this.responseCode = this.httpClient.executeMethod(this.getHostConfiguration(), (HttpMethod)this.getMethod);
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("retrieve resp=" + this.responseCode));
            }
            catch (Exception e) {
                Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/exceptions/catching", ((Object)((Object)this)).getClass(), (String)"performConnect", (Throwable)e);
                if (!this.isDone()) {
                    this.setDoneException(e);
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    protected void fireReceiveResumedEvent() {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)("fireReceiveResumedEvent len=" + this.fileLength + ";rcvd=" + this.bytesReceived));
        super.fireReceiveResumedEvent();
    }

    protected void fireTransferReceiveDataEvent() {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)("fireTransferReceiveDataEvent len=" + this.fileLength + ";rcvd=" + this.bytesReceived));
        super.fireTransferReceiveDataEvent();
    }

    protected void fireTransferReceiveDoneEvent() {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)("fireTransferReceiveDoneEvent len=" + this.fileLength + ";rcvd=" + this.bytesReceived));
        this.doneFired = true;
        super.fireTransferReceiveDoneEvent();
    }

    protected void fireTransferReceivePausedEvent() {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)("fireTransferReceivePausedEvent len=" + this.fileLength + ";rcvd=" + this.bytesReceived));
        super.fireTransferReceivePausedEvent();
    }

    final class ECFCredentialsProvider
    implements CredentialsProvider {
        ECFCredentialsProvider() {
        }

        public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean isProxyAuthenticating) throws CredentialsNotAvailableException {
            if ("ntlm".equalsIgnoreCase(scheme.getSchemeName())) {
                return HttpClientRetrieveFileTransfer.createNTLMCredentials(HttpClientRetrieveFileTransfer.this.getProxy());
            }
            return null;
        }
    }

    public class GzipGetMethod
    extends GetMethod {
        private static final String CONTENT_ENCODING = "Content-Encoding";
        private static final String ACCEPT_ENCODING = "Accept-encoding";
        private static final String CONTENT_ENCODING_GZIP = "gzip";
        private static final String CONTENT_ENCODING_ACCEPTED = "gzip";
        private boolean gzipReceived = false;

        public GzipGetMethod(String urlString) {
            super(urlString);
        }

        private boolean isZippedResponse() {
            boolean contentEncodingGzip = this.getResponseHeader(CONTENT_ENCODING) != null && this.getResponseHeader(CONTENT_ENCODING).getValue().equals("gzip");
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("Content-Encoding: gzip header " + (contentEncodingGzip ? "PRESENT" : "ABSENT")));
            boolean hasGzSuffix = HttpClientRetrieveFileTransfer.this.targetHasGzSuffix(HttpClientRetrieveFileTransfer.this.remoteFileName);
            return contentEncodingGzip && !hasGzSuffix;
        }

        public int execute(HttpState state, HttpConnection conn) throws HttpException, IOException {
            Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"GzipGetMethod.execute");
            int result = super.execute(state, conn);
            switch (result) {
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("GzipGetMethod.execute.  Received redirect=" + result + ".  Removing gzip accept encoding"));
                    this.gzipReceived = false;
                    this.removeRequestHeader(ACCEPT_ENCODING);
                }
            }
            Trace.exiting((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"org.eclipse.ecf.provider.filetransfer.httpclient/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"GzipGetMethod.execute", (Object)new Integer(result));
            return result;
        }

        public InputStream getResponseBodyAsUnzippedStream() throws IOException {
            this.gzipReceived = this.isZippedResponse();
            InputStream input = super.getResponseBodyAsStream();
            try {
                if (this.gzipReceived) {
                    Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"Using gzip input stream to decode");
                    return new GZIPInputStream(input);
                }
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)"Not using gzip input stream");
            }
            catch (IOException e) {
                Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.provider.filetransfer.httpclient", 2, "Exception creating gzip input stream", (Throwable)e));
                throw e;
            }
            return input;
        }
    }

    static final class HostConfigHelper {
        private ISocketEventSource source;
        private ISocketListener socketListener;
        private String targetURL;
        private String targetRelativePath;
        private HostConfiguration hostConfiguration;

        public HostConfigHelper(ISocketEventSource source, ISocketListener socketListener) {
            Assert.isNotNull((Object)source);
            this.source = source;
            this.socketListener = socketListener;
            this.hostConfiguration = new HostConfiguration();
        }

        public HostConfiguration getHostConfiguration() {
            return this.hostConfiguration;
        }

        private static String getTargetRelativePathFromURL(String url) {
            int colonSlashSlash = url.indexOf("://");
            if (colonSlashSlash < 0) {
                return url;
            }
            int nextSlash = url.indexOf(47, colonSlashSlash + 3);
            if (nextSlash == -1) {
                return "";
            }
            String relativeURL = url.substring(nextSlash);
            if (relativeURL.startsWith("//")) {
                relativeURL = "//example.com" + relativeURL;
            }
            return relativeURL;
        }

        public void setTargetHostByURL(String url) {
            this.targetURL = url;
            this.targetRelativePath = HostConfigHelper.getTargetRelativePathFromURL(this.targetURL);
            String host = HttpClientRetrieveFileTransfer.getHostFromURL(this.targetURL);
            int port = HttpClientRetrieveFileTransfer.getPortFromURL(this.targetURL);
            if (HttpClientRetrieveFileTransfer.urlUsesHttps(this.targetURL)) {
                ISSLSocketFactoryModifier sslSocketFactoryModifier = Activator.getDefault().getSSLSocketFactoryModifier();
                if (sslSocketFactoryModifier == null) {
                    sslSocketFactoryModifier = new HttpClientDefaultSSLSocketFactoryModifier();
                }
                ECFHttpClientSecureProtocolSocketFactory psf = new ECFHttpClientSecureProtocolSocketFactory(sslSocketFactoryModifier, this.source, this.socketListener);
                Protocol sslProtocol = new Protocol(HTTPS, (ProtocolSocketFactory)psf, port);
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("retrieve host=" + host + ";port=" + port));
                this.hostConfiguration.setHost(host, port, sslProtocol);
            } else {
                ECFHttpClientProtocolSocketFactory psf = new ECFHttpClientProtocolSocketFactory(SocketFactory.getDefault(), this.source, this.socketListener);
                Protocol protocol = new Protocol(HTTP, (ProtocolSocketFactory)psf, port);
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient", (String)("retrieve host=" + host + ";port=" + port));
                this.hostConfiguration.setHost(host, port, protocol);
            }
        }

        public String getTargetRelativePath() {
            return this.targetRelativePath;
        }
    }
}

