/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.ProviderPlugin;
import org.eclipse.ecf.provider.generic.Messages;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.TCPClientSOContainer;
import org.eclipse.ecf.provider.generic.TCPServerSOContainer;

public class GenericContainerInstantiator
implements IContainerInstantiator {
    protected static final String[] genericProviderIntents = new String[]{"passByValue", "exactlyOnce", "ordered"};
    public static final String TCPCLIENT_NAME = "ecf.generic.client";
    public static final String TCPSERVER_NAME = "ecf.generic.server";
    private static final int CREATE_INSTANCE_ERROR_CODE = 4441;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected ID getIDFromArg(Object arg) throws IDCreateException {
        if (arg == null) {
            throw new IDCreateException(Messages.getString("GenericContainerInstantiator.ID_Cannot_Be_Null"));
        }
        if (arg instanceof ID) {
            return (ID)arg;
        }
        if (arg instanceof String) {
            String val = (String)arg;
            if (val.equals("")) {
                return IDFactory.getDefault().createGUID();
            }
            return IDFactory.getDefault().createStringID(val);
        }
        if (arg instanceof Integer) {
            return IDFactory.getDefault().createGUID(((Integer)arg).intValue());
        }
        return IDFactory.getDefault().createGUID();
    }

    protected Integer getIntegerFromArg(Object arg) {
        if (arg == null) {
            return new Integer(-1);
        }
        if (arg instanceof Integer) {
            return (Integer)arg;
        }
        if (arg instanceof String) {
            return new Integer((String)arg);
        }
        return new Integer(-1);
    }

    protected GenericContainerArgs getClientArgs(String[] argDefaults, Object[] args) throws IDCreateException {
        ID newID = null;
        Integer ka = null;
        if (argDefaults != null && argDefaults.length > 0) {
            if (argDefaults.length == 2) {
                newID = this.getIDFromArg(argDefaults[0]);
                ka = this.getIntegerFromArg(argDefaults[1]);
            } else {
                ka = this.getIntegerFromArg(argDefaults[0]);
            }
        }
        if (args != null && args.length > 0) {
            if (args.length == 2) {
                newID = this.getIDFromArg(args[0]);
                ka = this.getIntegerFromArg(args[1]);
            } else {
                ka = this.getIntegerFromArg(args[0]);
            }
        }
        if (newID == null) {
            newID = IDFactory.getDefault().createGUID();
        }
        if (ka == null) {
            ka = new Integer(0);
        }
        return new GenericContainerArgs(newID, ka);
    }

    protected boolean isClient(ContainerTypeDescription description) {
        return !description.getName().equals(TCPSERVER_NAME);
    }

    protected GenericContainerArgs getServerArgs(String[] argDefaults, Object[] args) throws IDCreateException {
        ID newID = null;
        Integer ka = null;
        if (argDefaults != null && argDefaults.length > 0) {
            if (argDefaults.length == 2) {
                newID = this.getIDFromArg(argDefaults[0]);
                ka = this.getIntegerFromArg(argDefaults[1]);
            } else {
                newID = this.getIDFromArg(argDefaults[0]);
            }
        }
        if (args != null && args.length > 0) {
            if (args.length == 2) {
                newID = this.getIDFromArg(args[0]);
                ka = this.getIntegerFromArg(args[1]);
            } else {
                newID = this.getIDFromArg(args[0]);
            }
        }
        if (newID == null) {
            newID = IDFactory.getDefault().createGUID();
        }
        if (ka == null) {
            ka = new Integer(0);
        }
        return new GenericContainerArgs(newID, ka);
    }

    public IContainer createInstance(ContainerTypeDescription description, Object[] args) throws ContainerCreateException {
        boolean isClient = this.isClient(description);
        try {
            GenericContainerArgs gcargs = null;
            String[] argDefaults = null;
            gcargs = isClient ? this.getClientArgs(argDefaults, args) : this.getServerArgs(argDefaults, args);
            if (isClient) {
                return new TCPClientSOContainer(new SOContainerConfig(gcargs.getID()), gcargs.getKeepAlive());
            }
            return new TCPServerSOContainer(new SOContainerConfig(gcargs.getID()), gcargs.getKeepAlive());
        }
        catch (Exception e) {
            Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/catching", this.getClass(), (String)"createInstance", (Throwable)e);
            ProviderPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider", 4441, "createInstance", (Throwable)e));
            Trace.throwing((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/throwing", this.getClass(), (String)"createInstance", (Throwable)e);
            throw new ContainerCreateException("createInstance", (Throwable)e);
        }
    }

    protected Set getAdaptersForClass(Class clazz) {
        HashSet<String> result = new HashSet<String>();
        IAdapterManager adapterManager = ProviderPlugin.getDefault().getAdapterManager();
        if (adapterManager != null) {
            result.addAll(Arrays.asList(adapterManager.computeAdapterTypes(clazz)));
        }
        return result;
    }

    protected Set getInterfacesForClass(Set s, Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return s;
        }
        s.addAll(this.getInterfacesForClass(s, clazz.getSuperclass()));
        s.addAll(Arrays.asList(clazz.getInterfaces()));
        return s;
    }

    protected Set getInterfacesForClass(Class clazz) {
        Set clazzes = this.getInterfacesForClass(new HashSet(), clazz);
        int index = 0;
        HashSet<String> result = new HashSet<String>();
        Iterator i = clazzes.iterator();
        while (i.hasNext()) {
            result.add(((Class)i.next()).getName());
            ++index;
        }
        return result;
    }

    protected String[] getInterfacesAndAdaptersForClass(Class clazz) {
        Set result = this.getAdaptersForClass(clazz);
        result.addAll(this.getInterfacesForClass(clazz));
        return result.toArray(new String[0]);
    }

    public String[] getSupportedAdapterTypes(ContainerTypeDescription description) {
        if (!this.isClient(description)) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ecf.provider.generic.TCPServerSOContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.getInterfacesAndAdaptersForClass(clazz);
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ecf.provider.generic.TCPClientSOContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getInterfacesAndAdaptersForClass(clazz);
    }

    public Class[][] getSupportedParameterTypes(ContainerTypeDescription description) {
        if (!this.isClient(description)) {
            Class[][] classArray = new Class[2][];
            Class[] classArray2 = new Class[1];
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.ecf.core.identity.ID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz;
            classArray[0] = classArray2;
            Class[] classArray3 = new Class[2];
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.ecf.core.identity.ID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray3[0] = clazz2;
            Class<?> clazz3 = class$4;
            if (clazz3 == null) {
                try {
                    clazz3 = class$4 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray3[1] = clazz3;
            classArray[1] = classArray3;
            return classArray;
        }
        Class[][] classArray = new Class[3][];
        classArray[0] = new Class[0];
        Class[] classArray4 = new Class[1];
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ecf.core.identity.ID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray4[0] = clazz;
        classArray[1] = classArray4;
        Class[] classArray5 = new Class[2];
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.ecf.core.identity.ID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray5[0] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray5[1] = clazz5;
        classArray[2] = classArray5;
        return classArray;
    }

    public String[] getSupportedIntents(ContainerTypeDescription description) {
        return genericProviderIntents;
    }

    protected class GenericContainerArgs {
        ID id;
        Integer keepAlive;

        public GenericContainerArgs(ID id, Integer keepAlive) {
            this.id = id;
            this.keepAlive = keepAlive;
        }

        public ID getID() {
            return this.id;
        }

        public Integer getKeepAlive() {
            return this.keepAlive;
        }
    }
}

