/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.provider.comm.IConnectRequestHandler;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.generic.ServerSOContainer;
import org.eclipse.ecf.provider.generic.TCPServerSOContainerGroup;

public class TCPServerSOContainer
extends ServerSOContainer
implements IConnectRequestHandler {
    public static final String DEFAULT_PROTOCOL = "ecftcp";
    public static final int DEFAULT_PORT = 3282;
    public static final int DEFAULT_KEEPALIVE = 30000;
    public static final String DEFAULT_NAME = "/server";
    public static final String DEFAULT_HOST = "localhost";
    protected int keepAlive;
    protected TCPServerSOContainerGroup group;
    protected boolean isSingle = false;

    protected int getKeepAlive() {
        return this.keepAlive;
    }

    public static String getServerURL(String host, String name) {
        return "ecftcp://" + host + ":" + 3282 + name;
    }

    public static String getDefaultServerURL() {
        return TCPServerSOContainer.getServerURL(DEFAULT_HOST, DEFAULT_NAME);
    }

    public TCPServerSOContainer(ISharedObjectContainerConfig config, TCPServerSOContainerGroup grp, int keepAlive) throws IOException, URISyntaxException {
        super(config);
        this.keepAlive = keepAlive;
        URI actualURI = new URI(this.getID().getName());
        int urlPort = actualURI.getPort();
        if (this.group == null) {
            this.isSingle = true;
            this.group = new TCPServerSOContainerGroup(urlPort);
            this.group.putOnTheAir();
        } else {
            this.group = grp;
        }
        String path = actualURI.getPath();
        this.group.add(path, this);
    }

    public TCPServerSOContainer(ISharedObjectContainerConfig config, TCPServerSOContainerGroup listener, String path, int keepAlive) {
        super(config);
        this.initialize(listener, path, keepAlive);
    }

    protected void initialize(TCPServerSOContainerGroup listener, String path, int ka) {
        this.keepAlive = ka;
        this.group = listener;
        this.group.add(path, this);
    }

    public void dispose() {
        URI aURI = null;
        try {
            aURI = new URI(this.getID().getName());
        }
        catch (Exception exception) {}
        this.group.remove(aURI.getPath());
        if (this.isSingle) {
            this.group.takeOffTheAir();
        }
        super.dispose();
    }

    public TCPServerSOContainer(ISharedObjectContainerConfig config) throws IOException, URISyntaxException {
        this(config, null, 30000);
    }

    public TCPServerSOContainer(ISharedObjectContainerConfig config, int keepAlive) throws IOException, URISyntaxException {
        this(config, null, keepAlive);
    }

    public Serializable handleConnectRequest(Socket socket, String target, Serializable data, ISynchAsynchConnection conn) {
        return this.acceptNewClient(socket, target, data, conn);
    }

    protected Serializable getConnectDataFromInput(Serializable input) throws Exception {
        return input;
    }
}

