/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.osgi.framework.InvalidSyntaxException;

public class RemoteServiceContainer
implements IRemoteServiceContainer {
    private final IContainer container;
    private final IRemoteServiceContainerAdapter containerAdapter;

    public RemoteServiceContainer(IContainer container, IRemoteServiceContainerAdapter containerAdapter) {
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)containerAdapter);
        this.container = container;
        this.containerAdapter = containerAdapter;
    }

    public IContainer getContainer() {
        return this.container;
    }

    public IRemoteServiceContainerAdapter getContainerAdapter() {
        return this.containerAdapter;
    }

    public IRemoteService getRemoteService(String targetLocation, String serviceInterfaceClass, String filter) throws ContainerConnectException, InvalidSyntaxException {
        IRemoteServiceReference serviceReference;
        ID targetID = null;
        if (targetLocation != null) {
            targetID = IDFactory.getDefault().createID(this.getContainer().getConnectNamespace(), targetLocation);
        }
        if ((serviceReference = this.getServiceReference(targetID, serviceInterfaceClass, filter)) == null) {
            return null;
        }
        return this.getContainerAdapter().getRemoteService(serviceReference);
    }

    protected IRemoteServiceReference getServiceReference(ID targetId, String serviceInterfaceClass, String filter) throws ContainerConnectException, InvalidSyntaxException {
        IRemoteServiceReference[] references = this.getContainerAdapter().getRemoteServiceReferences(targetId, serviceInterfaceClass, filter);
        if (references == null || references.length == 0) {
            return null;
        }
        return this.selectReference(references);
    }

    protected IRemoteServiceReference selectReference(IRemoteServiceReference[] references) {
        int length;
        int n = length = references == null ? 0 : references.length;
        if (length == 0) {
            return null;
        }
        int index = 0;
        if (length > 1) {
            int[] rankings = new int[length];
            int count = 0;
            int maxRanking = Integer.MIN_VALUE;
            int i = 0;
            while (i < length) {
                int ranking;
                Object property = references[i].getProperty("ecf.rsvc.ranking");
                rankings[i] = ranking = property instanceof Integer ? (Integer)property : 0;
                if (ranking > maxRanking) {
                    index = i;
                    maxRanking = ranking;
                    count = 1;
                } else if (ranking == maxRanking) {
                    ++count;
                }
                ++i;
            }
            if (count > 1) {
                long minId = Long.MAX_VALUE;
                int i2 = 0;
                while (i2 < length) {
                    long id;
                    if (rankings[i2] == maxRanking && (id = ((Long)references[i2].getProperty("ecf.rsvc.id")).longValue()) < minId) {
                        index = i2;
                        minId = id;
                    }
                    ++i2;
                }
            }
        }
        return references[index];
    }

    public IRemoteService getRemoteService(String targetLocation, String serviceInterfaceClass) throws ContainerConnectException {
        try {
            return this.getRemoteService(targetLocation, serviceInterfaceClass, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }

    public IRemoteService getRemoteService(String serviceInterfaceClass) {
        try {
            return this.getRemoteService(null, serviceInterfaceClass);
        }
        catch (ContainerConnectException containerConnectException) {
            return null;
        }
    }
}

