/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.equinox.concurrent.future.IFuture;

public class RemoteServiceHelper {
    public static long defaultTimeout = 30000L;

    public static long getDefaultTimeout() {
        return defaultTimeout;
    }

    public static void setDefaultTimeout(long timeout) {
        defaultTimeout = timeout;
    }

    public static void asyncExec(IRemoteService remoteService, String method, Object[] parameters, IRemoteCallListener listener) {
        RemoteServiceHelper.asyncExec(remoteService, method, parameters, RemoteServiceHelper.getDefaultTimeout(), listener);
    }

    public static void asyncExec(IRemoteService remoteService, final String method, final Object[] parameters, final long timeout, IRemoteCallListener listener) {
        Assert.isNotNull((Object)remoteService);
        Assert.isNotNull((Object)method);
        Assert.isNotNull((Object)listener);
        remoteService.callAsync(new IRemoteCall(){

            public String getMethod() {
                return method;
            }

            public Object[] getParameters() {
                return parameters;
            }

            public long getTimeout() {
                return timeout;
            }
        }, listener);
    }

    public static IFuture futureExec(IRemoteService remoteService, final String method, final Object[] parameters, final long timeout) {
        Assert.isNotNull((Object)remoteService);
        Assert.isNotNull((Object)method);
        return remoteService.callAsync(new IRemoteCall(){

            public String getMethod() {
                return method;
            }

            public Object[] getParameters() {
                return parameters;
            }

            public long getTimeout() {
                return timeout;
            }
        });
    }

    public static IFuture futureExec(IRemoteService remoteService, String method, Object[] parameters) {
        return RemoteServiceHelper.futureExec(remoteService, method, parameters, RemoteServiceHelper.getDefaultTimeout());
    }

    public static Object syncExec(IRemoteService remoteService, final String method, final Object[] parameters, final long timeout) throws ECFException {
        Assert.isNotNull((Object)remoteService);
        Assert.isNotNull((Object)method);
        return remoteService.callSync(new IRemoteCall(){

            public String getMethod() {
                return method;
            }

            public Object[] getParameters() {
                return parameters;
            }

            public long getTimeout() {
                return timeout;
            }
        });
    }

    public static Object syncExec(IRemoteService remoteService, String method, Object[] parameters) throws ECFException {
        return RemoteServiceHelper.syncExec(remoteService, method, parameters, RemoteServiceHelper.getDefaultTimeout());
    }
}

