/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.ServiceURL;
import ch.ethz.iks.slp.impl.RequestMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class AttributeRequest
extends RequestMessage {
    String url;
    List tagList;
    String spi;

    AttributeRequest(ServiceURL serviceURL, List scopes, List tags, Locale theLocale) {
        this.funcID = (byte)6;
        this.url = serviceURL.toString();
        this.scopeList = scopes;
        if (this.scopeList == null) {
            this.scopeList = new ArrayList();
            this.scopeList.add("default");
        }
        this.tagList = tags;
        if (this.tagList == null) {
            this.tagList = new ArrayList();
        }
        this.locale = theLocale == null ? SLPCore.DEFAULT_LOCALE : theLocale;
        this.spi = SLPCore.CONFIG.getSecurityEnabled() ? SLPCore.CONFIG.getSPI() : "";
    }

    AttributeRequest(ServiceType type, List scopes, List tags, Locale theLocale) {
        this.funcID = (byte)6;
        this.url = type.toString();
        this.scopeList = scopes;
        if (this.scopeList == null) {
            this.scopeList = new ArrayList();
            this.scopeList.add("default");
        }
        this.tagList = tags;
        if (this.tagList == null) {
            this.tagList = new ArrayList();
        }
        this.locale = theLocale == null ? SLPCore.DEFAULT_LOCALE : theLocale;
        this.spi = SLPCore.CONFIG.getSecurityEnabled() ? SLPCore.CONFIG.getSPI() : "";
    }

    AttributeRequest(DataInputStream input) throws IOException {
        this.prevRespList = AttributeRequest.stringToList(input.readUTF(), ",");
        this.url = input.readUTF();
        this.scopeList = AttributeRequest.stringToList(input.readUTF(), ",");
        this.tagList = AttributeRequest.stringToList(input.readUTF(), ",");
        this.spi = input.readUTF();
    }

    protected void writeTo(DataOutputStream out) throws IOException {
        super.writeHeader(out, this.getSize());
        out.writeUTF(AttributeRequest.listToString(this.prevRespList, ","));
        out.writeUTF(this.url);
        out.writeUTF(AttributeRequest.listToString(this.scopeList, ","));
        out.writeUTF(AttributeRequest.listToString(this.tagList, ","));
        out.writeUTF(this.spi);
    }

    int getSize() {
        return this.getHeaderSize() + 2 + AttributeRequest.listToString(this.prevRespList, ",").length() + 2 + this.url.length() + 2 + AttributeRequest.listToString(this.scopeList, ",").length() + 2 + AttributeRequest.listToString(this.tagList, ",").length() + 2 + this.spi.length();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(", prevRespList: " + this.prevRespList);
        buffer.append(", URL: " + this.url);
        buffer.append(", scopeList: " + this.scopeList);
        buffer.append(", tag-list: " + this.tagList);
        buffer.append(", slpSpi: " + this.spi);
        return buffer.toString();
    }
}

