/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.impl.DAAdvertisement;
import ch.ethz.iks.slp.impl.PlatformAbstraction;
import ch.ethz.iks.slp.impl.ReplyMessage;
import ch.ethz.iks.slp.impl.RequestMessage;
import ch.ethz.iks.slp.impl.SLPConfiguration;
import ch.ethz.iks.slp.impl.SLPDaemon;
import ch.ethz.iks.slp.impl.SLPMessage;
import ch.ethz.iks.slp.impl.SLPUtils;
import ch.ethz.iks.slp.impl.ServiceRequest;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class SLPCore {
    private static volatile boolean isMulticastSocketInitialized;
    private static volatile boolean isInitialized;
    protected static PlatformAbstraction platform;
    static final Locale DEFAULT_LOCALE;
    static final int SLP_PORT;
    static final int SLP_RESERVED_PORT = 427;
    static final String SLP_MCAST_ADDRESS = "239.255.255.253";
    static final InetAddress MCAST_ADDRESS;
    static final SLPConfiguration CONFIG;
    static final boolean TCP_ONLY = false;
    static final String SLP_DA_TYPE = "service:directory-agent";
    static String[] myIPs;
    static final boolean noDiscovery;
    protected static final Constructor advertiser;
    protected static final Constructor locator;
    private static final Constructor daemonConstr;
    private static SLPDaemon daemon;
    private static Thread multicastThread;
    private static MulticastSocket mtcSocket;
    private static short nextXid;
    private static Map replyListeners;
    static Map dAs;
    static Map dASPIs;
    static InetAddress LOCALHOST;
    static /* synthetic */ Class class$0;

    static {
        SLPConfiguration config;
        isMulticastSocketInitialized = false;
        isInitialized = false;
        DEFAULT_LOCALE = Locale.getDefault();
        replyListeners = new HashMap();
        dAs = new HashMap();
        dASPIs = new HashMap();
        try {
            LOCALHOST = InetAddress.getLocalHost();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Locale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] locale = classArray;
        Constructor<?> constr = null;
        try {
            constr = Class.forName("ch.ethz.iks.slp.impl.AdvertiserImpl").getConstructor(locale);
        }
        catch (Exception exception) {}
        advertiser = constr;
        constr = null;
        try {
            constr = Class.forName("ch.ethz.iks.slp.impl.LocatorImpl").getConstructor(locale);
        }
        catch (Exception exception) {}
        locator = constr;
        constr = null;
        try {
            constr = Class.forName("ch.ethz.iks.slp.impl.SLPDaemonImpl").getConstructor(null);
        }
        catch (Exception exception) {}
        daemonConstr = constr;
        File propFile = new File("jslp.properties");
        try {
            config = propFile.exists() ? new SLPConfiguration(propFile) : new SLPConfiguration();
        }
        catch (IOException e1) {
            System.out.println("Could not parse the property file" + propFile.toString());
            e1.printStackTrace();
            config = new SLPConfiguration();
        }
        CONFIG = config;
        noDiscovery = CONFIG.getNoDaDiscovery();
        String[] IPs = CONFIG.getInterfaces();
        if (IPs == null) {
            InetAddress[] addresses = null;
            try {
                addresses = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                IPs = new String[addresses.length];
                int i = 0;
                while (i < addresses.length) {
                    IPs[i] = addresses[i].getHostAddress();
                    ++i;
                }
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println("Reverse lookup of host name failed. Running service discovery on localloop.");
                try {
                    addresses = new InetAddress[]{InetAddress.getLocalHost()};
                }
                catch (UnknownHostException e1) {
                    e1.printStackTrace();
                }
            }
        }
        myIPs = IPs;
        SLP_PORT = CONFIG.getPort();
        nextXid = (short)Math.round(Math.random() * 32767.0);
        InetAddress mcast = null;
        try {
            mcast = InetAddress.getByName(SLP_MCAST_ADDRESS);
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        MCAST_ADDRESS = mcast;
    }

    protected static void init() {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        platform.logDebug("jSLP is running on the following interfaces: " + Arrays.asList(myIPs));
        platform.logDebug("jSLP is using port: " + SLP_PORT);
        String[] daAddresses = CONFIG.getDaAddresses();
        if (daAddresses == null) {
            if (noDiscovery) {
                throw new IllegalArgumentException("Configuration 'net.slp.noDaDiscovery=true' requires a non-empty list of preconfigured DAs");
            }
        } else {
            try {
                ServiceRequest req = new ServiceRequest(new ServiceType(SLP_DA_TYPE), null, null, null);
                req.port = SLP_PORT;
                int i = 0;
                while (i < daAddresses.length) {
                    try {
                        req.address = InetAddress.getByName(daAddresses[i]);
                        DAAdvertisement daa = (DAAdvertisement)SLPCore.sendMessage(req, true);
                        String[] scopes = daa.scopeList.toArray(new String[daa.scopeList.size()]);
                        int j = 0;
                        while (j < scopes.length) {
                            platform.logDebug("jSLP is adding DA, " + daAddresses[i] + " for the Scope, " + scopes[j]);
                            SLPUtils.addValue(dAs, scopes[i].toLowerCase(), daAddresses[i]);
                            ++j;
                        }
                    }
                    catch (ServiceLocationException e) {
                        platform.logWarning("Error communitcating with " + daAddresses[i], e);
                    }
                    catch (UnknownHostException e) {
                        platform.logWarning("Unknown net.slp.DAAddresses address: " + daAddresses[i], e);
                    }
                    ++i;
                }
            }
            catch (IllegalArgumentException ise) {
                platform.logDebug("May never happen", ise);
            }
        }
        if (!noDiscovery) {
            try {
                ArrayList<String> scopes = new ArrayList<String>();
                scopes.add("default");
                SLPCore.daLookup(scopes);
            }
            catch (Exception e) {
                platform.logError("Exception in initial DA lookup", e);
            }
        }
    }

    protected static void initMulticastSocket() {
        if (isMulticastSocketInitialized) {
            return;
        }
        isMulticastSocketInitialized = true;
        try {
            mtcSocket = new MulticastSocket(SLP_PORT);
            mtcSocket.setTimeToLive(CONFIG.getMcastTTL());
            if (CONFIG.getInterfaces() != null) {
                try {
                    mtcSocket.setInterface(InetAddress.getByName(myIPs[0]));
                }
                catch (Throwable t) {
                    platform.logDebug("Setting multicast socket interface to " + myIPs[0] + " failed.", t);
                }
            }
            mtcSocket.joinGroup(MCAST_ADDRESS);
        }
        catch (BindException be) {
            platform.logError(be.getMessage(), be);
            throw new RuntimeException("You have to be root to open port " + SLP_PORT);
        }
        catch (Exception e) {
            platform.logError(e.getMessage(), e);
        }
        multicastThread = new Thread(){

            public void run() {
                byte[] bytes = new byte[CONFIG.getMTU()];
                while (true) {
                    try {
                        while (true) {
                            DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
                            mtcSocket.receive(packet);
                            SLPMessage reply = SLPCore.handleMessage(SLPMessage.parse(packet.getAddress(), packet.getPort(), new DataInputStream(new ByteArrayInputStream(packet.getData())), false));
                            if (reply == null) continue;
                            byte[] repbytes = reply.getBytes();
                            DatagramPacket datagramPacket = new DatagramPacket(repbytes, repbytes.length, reply.address, reply.port);
                            mtcSocket.send(datagramPacket);
                            platform.logDebug("SEND (" + reply.address + ":" + reply.port + ") " + reply.toString());
                        }
                    }
                    catch (Exception e) {
                        platform.logError("Exception in Multicast Receiver Thread", e);
                        continue;
                    }
                    break;
                }
            }
        };
        multicastThread.start();
        if (daemonConstr != null) {
            try {
                daemon = (SLPDaemon)daemonConstr.newInstance(null);
            }
            catch (Exception exception) {
                daemon = null;
            }
        }
    }

    static InetAddress getMyIP() {
        try {
            return InetAddress.getByName(myIPs[0]);
        }
        catch (UnknownHostException e) {
            platform.logError("Unknown net.slp.interfaces address: " + myIPs[0], e);
            return null;
        }
    }

    public static List findScopes() throws ServiceLocationException {
        return new ArrayList(dAs.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SLPMessage handleMessage(SLPMessage message) throws ServiceLocationException {
        if (message == null) {
            return null;
        }
        platform.logTraceMessage("RECEIVED (" + message.address + ":" + message.port + ") " + message);
        switch (message.funcID) {
            case 8: {
                if (noDiscovery) {
                    platform.logTraceDrop("DROPPED (" + message.address + ":" + message.port + ") " + message.toString() + "(reason: noDADiscovery is set");
                    return null;
                }
                DAAdvertisement advert = (DAAdvertisement)message;
                if (advert.errorCode != 0) {
                    platform.logTraceDrop("DROPPED DAADvertisement (" + advert.address + ":" + advert.port + ") " + advert.toString() + "(reason: " + advert.errorCode + " != 0");
                    return null;
                }
                if (advert.url != advert.address.getHostAddress()) {
                    advert.url = advert.address.getHostAddress();
                }
                if (advert.statelessBootTimestamp == 0) {
                    Iterator iter = advert.scopeList.iterator();
                    while (iter.hasNext()) {
                        String scope = ((String)iter.next()).toLowerCase();
                        SLPUtils.removeValue(dAs, scope.toLowerCase(), advert.url);
                        dASPIs.remove(advert.url);
                    }
                } else {
                    Object iter = advert.scopeList.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            iter = dAs;
                            synchronized (iter) {
                                dAs.notifyAll();
                                break;
                            }
                        }
                        String scope = ((String)iter.next()).toLowerCase();
                        SLPUtils.addValue(dAs, scope, advert.url);
                        if (!CONFIG.getSecurityEnabled()) continue;
                        dASPIs.put(advert.url, SLPMessage.stringToList(advert.spi, ","));
                    }
                    if (daemon != null) {
                        daemon.newDaDiscovered(advert);
                    }
                }
                platform.logDebug("NEW DA LIST: " + dAs);
                return null;
            }
            case 2: 
            case 7: 
            case 10: {
                Map iter = replyListeners;
                synchronized (iter) {
                    List queue = (List)replyListeners.get(new Integer(message.xid));
                    if (queue == null) {
                        platform.logTraceReg("SRVTYPEREPLY recieved (" + message.address + ":" + message.port + ") " + message.toString() + " but not replyListeners present anymore");
                        return null;
                    }
                    List list = queue;
                    synchronized (list) {
                        queue.add(message);
                        queue.notifyAll();
                    }
                    return null;
                }
            }
            case 1: 
            case 6: 
            case 9: {
                int i = 0;
                while (true) {
                    if (i >= myIPs.length) {
                        if (daemon == null) break;
                        return daemon.handleMessage(message);
                    }
                    if (((RequestMessage)message).prevRespList.contains(myIPs[i])) {
                        platform.logTraceDrop("DROPPED (" + message.address + ":" + message.port + ") " + message.toString() + "(udp multicast)");
                        return null;
                    }
                    ++i;
                }
                platform.logDebug("SRVTYPERQST recieved (" + message.address + ":" + message.port + ") " + message.toString() + " but no SLPDaemon to handle the message present");
                return null;
            }
        }
        if (daemon != null) {
            return daemon.handleMessage(message);
        }
        platform.logDebug("A message recieved (" + message.address + ":" + message.port + ") " + message.toString() + " but no SLPDaemon to handle the message present");
        return null;
    }

    static short nextXid() {
        if (nextXid == 0) {
            nextXid = 1;
        }
        short s = nextXid;
        nextXid = (short)(s + 1);
        return s;
    }

    static void daLookup(List scopes) throws ServiceLocationException {
        int i = 0;
        try {
            while (i < myIPs.length) {
                InetAddress addr = InetAddress.getByName(myIPs[i]);
                DatagramSocket socket = new DatagramSocket(0, addr);
                ServiceRequest sreq = new ServiceRequest(new ServiceType(SLP_DA_TYPE), scopes, null, DEFAULT_LOCALE);
                sreq.xid = SLPCore.nextXid();
                sreq.scopeList = scopes;
                sreq.address = MCAST_ADDRESS;
                sreq.multicast = true;
                byte[] bytes = sreq.getBytes();
                DatagramPacket d = new DatagramPacket(bytes, bytes.length, MCAST_ADDRESS, SLP_PORT);
                platform.logTraceMessage("SENT " + sreq + "(udp multicast)");
                SLPCore.setupReceiverThread(socket, CONFIG.getWaitTime(), sreq);
                try {
                    socket.send(d);
                }
                catch (SocketException socketException) {
                    ArrayList<String> remaining = new ArrayList<String>(Arrays.asList(myIPs));
                    String faulty = myIPs[i];
                    remaining.remove(faulty);
                    myIPs = remaining.toArray(new String[remaining.size()]);
                    platform.logDebug("Blacklisting IP " + faulty);
                }
                ++i;
            }
        }
        catch (IllegalArgumentException ise) {
            platform.logDebug("May never happen, no filter set", ise);
        }
        catch (UnknownHostException uhe) {
            platform.logWarning("Unknown net.slp.interfaces address: " + myIPs[i], uhe);
            throw new ServiceLocationException(19, uhe.getMessage());
        }
        catch (IOException e) {
            platform.logWarning("Error connecting to: " + myIPs[i], e);
            throw new ServiceLocationException(19, e.getMessage());
        }
    }

    static ReplyMessage sendMessageTCP(SLPMessage msg) throws ServiceLocationException {
        try {
            if (msg.xid == 0) {
                msg.xid = SLPCore.nextXid();
            }
            Socket socket = new Socket(msg.address, msg.port);
            socket.setSoTimeout(CONFIG.getTCPTimeout());
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            DataInputStream in = new DataInputStream(socket.getInputStream());
            msg.writeTo(out);
            ReplyMessage reply = (ReplyMessage)SLPMessage.parse(msg.address, msg.port, in, true);
            socket.close();
            return reply;
        }
        catch (Exception e) {
            throw new ServiceLocationException(19, e.getMessage());
        }
    }

    static ReplyMessage sendMessage(SLPMessage msg, boolean expectReply) throws ServiceLocationException {
        DatagramPacket received;
        DatagramSocket dsocket;
        block8: {
            if (msg.xid == 0) {
                msg.xid = SLPCore.nextXid();
            }
            if (msg.getSize() > CONFIG.getMTU()) {
                return SLPCore.sendMessageTCP(msg);
            }
            dsocket = new DatagramSocket();
            dsocket.setSoTimeout(CONFIG.getDatagramMaxWait());
            byte[] bytes = msg.getBytes();
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, msg.address, msg.port);
            byte[] receivedBytes = new byte[CONFIG.getMTU()];
            received = new DatagramPacket(receivedBytes, receivedBytes.length);
            dsocket.send(packet);
            platform.logTraceMessage("SENT (" + msg.address + ":" + msg.port + ") " + msg + " (via udp port " + dsocket.getLocalPort() + ")");
            if (expectReply) break block8;
            return null;
        }
        try {
            dsocket.receive(received);
            dsocket.close();
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(received.getData()));
            ReplyMessage reply = (ReplyMessage)SLPMessage.parse(received.getAddress(), received.getPort(), in, false);
            return reply;
        }
        catch (SocketException se) {
            throw new ServiceLocationException(17, se.getMessage());
        }
        catch (ProtocolException protocolException) {
            return SLPCore.sendMessageTCP(msg);
        }
        catch (IOException ioe) {
            platform.logError("Exception during sending of " + msg);
            platform.logError("to " + msg.address + ":" + msg.port);
            platform.logError("Exception:", ioe);
            throw new ServiceLocationException(19, ioe.getMessage());
        }
        catch (Throwable t) {
            platform.logDebug(t.getMessage(), t);
            throw new ServiceLocationException(1, t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List multicastConvergence(RequestMessage msg) throws ServiceLocationException {
        try {
            Integer queryXID;
            ArrayList responses;
            ArrayList<String> responders;
            ArrayList<ReplyMessage> replyQueue;
            long start;
            block25: {
                start = System.currentTimeMillis();
                replyQueue = new ArrayList<ReplyMessage>();
                responders = new ArrayList<String>();
                responses = new ArrayList();
                if (msg.xid == 0) {
                    msg.xid = SLPCore.nextXid();
                }
                queryXID = new Integer(msg.xid);
                Map map = replyListeners;
                synchronized (map) {
                    replyListeners.put(queryXID, replyQueue);
                }
                msg.port = SLP_PORT;
                msg.prevRespList = new ArrayList();
                msg.multicast = true;
                msg.address = LOCALHOST;
                try {
                    replyQueue.add(SLPCore.sendMessageTCP(msg));
                }
                catch (ServiceLocationException e) {
                    if (e.getErrorCode() == 19) break block25;
                    throw e;
                }
            }
            msg.address = MCAST_ADDRESS;
            int i = 0;
            while (true) {
                if (i >= myIPs.length) {
                    Map map = replyListeners;
                    synchronized (map) {
                        replyListeners.remove(queryXID);
                        break;
                    }
                }
                InetAddress addr = InetAddress.getByName(myIPs[i]);
                MulticastSocket socket = new MulticastSocket();
                socket.setInterface(addr);
                socket.setTimeToLive(CONFIG.getMcastTTL());
                SLPCore.setupReceiverThread(socket, CONFIG.getMcastMaxWait(), msg);
                long totalTimeout = System.currentTimeMillis() + (long)CONFIG.getMcastMaxWait();
                int[] transmissionSchedule = CONFIG.getMcastTimeouts();
                int retryCounter = 0;
                int failCounter = 0;
                boolean seenNew = false;
                boolean seenLocalResponse = false;
                long nextTimeout = System.currentTimeMillis() + (long)transmissionSchedule[retryCounter];
                while (!Thread.currentThread().isInterrupted() && totalTimeout > System.currentTimeMillis() && nextTimeout > System.currentTimeMillis() && retryCounter < transmissionSchedule.length && failCounter < CONFIG.getConvergenceFailerCount()) {
                    msg.prevRespList = responders;
                    byte[] message = msg.getBytes();
                    if (message.length > CONFIG.getMTU()) break;
                    DatagramPacket p = new DatagramPacket(message, message.length, InetAddress.getByName(SLP_MCAST_ADDRESS), SLP_PORT);
                    try {
                        socket.send(p);
                    }
                    catch (IOException iOException) {
                        break;
                    }
                    platform.logTraceMessage("SENT " + msg);
                    try {
                        Thread.sleep(transmissionSchedule[retryCounter]);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    ArrayList<ReplyMessage> arrayList = replyQueue;
                    synchronized (arrayList) {
                        block26: {
                            if (replyQueue.isEmpty()) {
                                ++failCounter;
                                nextTimeout = System.currentTimeMillis() + (long)transmissionSchedule[retryCounter++];
                                continue;
                            }
                            while (true) {
                                if (replyQueue.isEmpty()) {
                                    if (seenNew) break;
                                    ++failCounter;
                                    break block26;
                                }
                                ReplyMessage reply = (ReplyMessage)replyQueue.remove(0);
                                if (responders.contains(reply.address.getHostAddress())) continue;
                                if (SLPCore.isLocalResponder(reply.address)) {
                                    if (seenLocalResponse) continue;
                                    seenLocalResponse = true;
                                }
                                seenNew = true;
                                responders.add(reply.address.getHostAddress());
                                responses.addAll(reply.getResult());
                            }
                            seenNew = false;
                        }
                    }
                    nextTimeout = System.currentTimeMillis() + (long)transmissionSchedule[retryCounter++];
                }
                ++i;
            }
            platform.logDebug("convergence for xid=" + msg.xid + " finished after " + (System.currentTimeMillis() - start) + " ms, result: " + responses);
            return responses;
        }
        catch (IOException ioe) {
            platform.logDebug(ioe.getMessage(), ioe);
            throw new ServiceLocationException(19, ioe.getMessage());
        }
    }

    private static boolean isLocalResponder(InetAddress addr) {
        int i = 0;
        while (i < myIPs.length) {
            if (addr.getHostAddress().equals(myIPs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void setupReceiverThread(final DatagramSocket socket, final long minLifetime, final SLPMessage msg) {
        new Thread(){

            public void run() {
                byte[] bytes = new byte[CONFIG.getMTU()];
                long timeout = System.currentTimeMillis() + minLifetime + 1000L;
                while (System.currentTimeMillis() < timeout) {
                    try {
                        long l = timeout - System.currentTimeMillis();
                        int soTimeout = (int)(l < 0L ? 1L : l);
                        socket.setSoTimeout(soTimeout);
                    }
                    catch (SocketException e1) {
                        platform.logError("Exception in mcast receiver thread", e1);
                        return;
                    }
                    DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
                    try {
                        socket.receive(packet);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        continue;
                    }
                    catch (IOException e) {
                        platform.logDebug(e.getMessage(), e);
                        return;
                    }
                    DataInputStream in = new DataInputStream(new ByteArrayInputStream(packet.getData()));
                    try {
                        SLPCore.handleMessage(SLPMessage.parse(packet.getAddress(), packet.getPort(), in, false));
                    }
                    catch (ProtocolException protocolException) {
                        try {
                            msg.address = packet.getAddress();
                            msg.port = packet.getPort();
                            msg.multicast = false;
                            SLPCore.handleMessage(SLPCore.sendMessageTCP(msg));
                        }
                        catch (ServiceLocationException serviceLocationException) {}
                    }
                    catch (ServiceLocationException e) {
                        platform.logDebug(e.getMessage(), e);
                    }
                }
                socket.close();
            }
        }.start();
    }
}

