/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ui.deprecated.views;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.internal.ui.Activator;
import org.eclipse.ecf.internal.ui.deprecated.views.ChatLine;
import org.eclipse.ecf.internal.ui.deprecated.views.ILocalInputHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.part.ViewPart;

public class TextChatComposite
extends Composite {
    protected static final int DEFAULT_INPUT_HEIGHT = 25;
    protected static final int DEFAULT_INPUT_SEPARATOR = 5;
    protected String TEXT_INPUT_INIT = "<input chat text here>";
    protected Color meColor = null;
    protected Color otherColor = null;
    protected Color systemColor = null;
    protected StyledText styledText;
    protected Text textinput;
    protected int[] sashWeights = new int[]{7, 2};
    protected boolean isTyping;
    protected String initText;
    protected ILocalInputHandler inputHandler;
    SimpleDateFormat df = new SimpleDateFormat("hh:mm a");
    protected IUser localUser;
    protected IUser remoteUser;
    protected boolean showTimestamp = true;
    private Action outputClear = null;
    private Action outputCopy = null;
    private Action outputPaste = null;
    private Action outputSelectAll = null;
    private ViewPart view = null;

    public TextChatComposite(ViewPart view, Composite parent, int style, String initText, ILocalInputHandler handler, IUser localUser, IUser remoteUser) {
        super(parent, style);
        this.view = view;
        this.initText = initText;
        this.inputHandler = handler;
        this.localUser = localUser;
        this.remoteUser = remoteUser;
        this.meColor = new Color((Device)this.getShell().getDisplay(), 23, 135, 65);
        this.otherColor = new Color((Device)this.getShell().getDisplay(), 65, 13, 165);
        this.systemColor = new Color((Device)this.getShell().getDisplay(), 123, 135, 165);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TextChatComposite.this.meColor.dispose();
                TextChatComposite.this.otherColor.dispose();
                TextChatComposite.this.systemColor.dispose();
            }
        });
        this.setLayout((Layout)new GridLayout());
        SashForm sash = new SashForm((Composite)this, 66048);
        sash.setLayoutData((Object)new GridData(1808));
        this.styledText = this.createStyledTextWidget((Composite)sash);
        this.styledText.setEditable(false);
        this.textinput = new Text((Composite)sash, 2624);
        this.textinput.setText(this.TEXT_INPUT_INIT);
        this.textinput.selectAll();
        this.textinput.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent evt) {
                TextChatComposite.this.handleKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
            }
        });
        this.textinput.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                String t = TextChatComposite.this.textinput.getText();
                if (t.equals(TextChatComposite.this.TEXT_INPUT_INIT)) {
                    TextChatComposite.this.textinput.selectAll();
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.textinput.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                String t = TextChatComposite.this.textinput.getText();
                if (t.equals(TextChatComposite.this.TEXT_INPUT_INIT)) {
                    TextChatComposite.this.textinput.selectAll();
                }
            }
        });
        this.textinput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TextChatComposite.this.isTyping && TextChatComposite.this.textinput.getText().trim().length() == 0) {
                    TextChatComposite.this.isTyping = false;
                } else if (!TextChatComposite.this.isTyping) {
                    TextChatComposite.this.isTyping = true;
                    TextChatComposite.this.sendStartedTyping();
                }
            }
        });
        sash.setWeights(this.sashWeights);
        this.makeActions();
        this.hookContextMenu();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("TextChatComposite.displaytimestamp")) {
                    TextChatComposite.this.showTimestamp = (Boolean)event.getNewValue();
                }
            }
        });
    }

    private StyledText createStyledTextWidget(Composite parent) {
        try {
            SourceViewer result = new SourceViewer(parent, null, null, true, 2634);
            result.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()));
            result.setDocument((IDocument)new Document());
            return result.getTextWidget();
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.ui", 2, "Source viewer not available.  Hyperlinking will be disabled.", (Throwable)e));
            return new StyledText(parent, 2634);
        }
        catch (NoClassDefFoundError e) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.ui", 2, "Source viewer not available.  Hyperlinking will be disabled.", (Throwable)e));
            return new StyledText(parent, 2634);
        }
    }

    private void makeActions() {
        this.outputSelectAll = new Action(){

            public void run() {
                TextChatComposite.this.outputSelectAll();
            }
        };
        this.outputSelectAll.setText("Select All");
        this.outputSelectAll.setAccelerator(262209);
        this.outputCopy = new Action(){

            public void run() {
                TextChatComposite.this.outputCopy();
            }
        };
        this.outputCopy.setText("Copy");
        this.outputCopy.setAccelerator(262211);
        this.outputCopy.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.outputClear = new Action(){

            public void run() {
                TextChatComposite.this.outputClear();
            }
        };
        this.outputClear.setText("Clear");
        this.outputPaste = new Action(){

            public void run() {
                TextChatComposite.this.outputPaste();
            }
        };
        this.outputPaste.setText("Paste");
        this.outputCopy.setAccelerator(262230);
        this.outputPaste.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
    }

    protected void outputClear() {
        if (MessageDialog.openConfirm(null, (String)"Confirm Clear Text Output", (String)"Are you sure you want to clear output?")) {
            this.styledText.setText("");
        }
    }

    protected void outputCopy() {
        String t = this.styledText.getSelectionText();
        if (t == null || t.length() == 0) {
            this.styledText.selectAll();
        }
        this.styledText.copy();
        this.styledText.setSelection(this.styledText.getText().length());
    }

    protected void outputPaste() {
        this.textinput.paste();
    }

    protected void outputSelectAll() {
        this.styledText.selectAll();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TextChatComposite.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.styledText);
        this.styledText.setMenu(menu);
        ISelectionProvider selectionProvider = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                TextSelection selection = new TextSelection(TextChatComposite.this.styledText.getSelectionRange().x, TextChatComposite.this.styledText.getSelectionRange().y);
                return selection;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
                if (selection instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    TextChatComposite.this.styledText.setSelection(textSelection.getOffset(), textSelection.getOffset() + textSelection.getLength());
                }
            }
        };
        this.view.getSite().registerContextMenu(menuMgr, selectionProvider);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.outputCopy);
        manager.add((IAction)this.outputPaste);
        manager.add((IAction)this.outputClear);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.outputSelectAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void setLocalUser(IUser newUser) {
        this.localUser = newUser;
    }

    public void setRemoteUser(IUser remoteUser) {
        this.remoteUser = remoteUser;
    }

    public IUser getRemoteUser() {
        return this.remoteUser;
    }

    protected String getCurrentDateTime() {
        StringBuffer sb = new StringBuffer("(");
        sb.append(this.df.format(new Date())).append(") ");
        return sb.toString();
    }

    private String createLineWithTimestamp(String line) {
        if (this.showTimestamp) {
            return String.valueOf(this.getCurrentDateTime()) + line;
        }
        return line;
    }

    public IUser getLocalUser() {
        return this.localUser;
    }

    public void appendText(ChatLine text) {
        String t;
        StyledText st = this.styledText;
        if (text == null || st == null) {
            return;
        }
        int startRange = st.getText().length();
        StringBuffer sb = new StringBuffer();
        if (text.getOriginator() != null) {
            sb.append(this.createLineWithTimestamp(String.valueOf(text.getOriginator().getName()) + ": "));
            StyleRange sr = new StyleRange();
            sr.start = startRange;
            sr.length = sb.length();
            IUser lu = this.getLocalUser();
            sr.foreground = lu != null && lu.getID().equals((Object)text.getOriginator().getID()) ? this.meColor : this.otherColor;
            st.append(sb.toString());
            st.setStyleRange(sr);
        }
        int beforeMessageIndex = st.getText().length();
        st.append(text.getText().trim());
        if (text.getOriginator() == null) {
            StyleRange sr = new StyleRange();
            sr.start = beforeMessageIndex;
            sr.length = text.getText().length();
            sr.foreground = this.systemColor;
            st.setStyleRange(sr);
        }
        if (!text.isNoCRLF()) {
            st.append("\n");
        }
        if ((t = st.getText()) == null) {
            return;
        }
        st.setSelection(t.length());
    }

    protected void handleKeyPressed(KeyEvent evt) {
        if (evt.character == '\r') {
            this.handleEnter();
            evt.doit = false;
        }
    }

    protected void handleEnter() {
        String text = this.textinput.getText().trim();
        if (text != null) {
            this.sendTextLineInput(text);
        }
        this.clearInput();
        this.isTyping = false;
    }

    protected void clearInput() {
        this.textinput.setText("");
    }

    protected void sendTextLineInput(String text) {
        if (this.inputHandler != null) {
            IUser lu = this.getLocalUser();
            IUser ru = this.getRemoteUser();
            if (lu != null && ru != null) {
                this.inputHandler.inputText(ru.getID(), text);
                this.appendText(new ChatLine(text, lu));
            } else {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.ui", 100, "Null localUser or remoteUser for textchatcomposite", (Throwable)new NullPointerException()));
            }
        } else {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.ui", 100, "No inputhandler available for textchatcomposite", (Throwable)new NullPointerException()));
        }
    }

    protected void sendStartedTyping() {
        if (this.inputHandler != null) {
            IUser lu = this.getLocalUser();
            IUser ru = this.getRemoteUser();
            if (lu != null && ru != null) {
                this.inputHandler.startTyping(ru.getID());
            } else {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.ui", 100, "Null localUser or remoteUser for textchatcomposite", (Throwable)new NullPointerException()));
            }
        } else {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.ui", 100, "No inputhandler available for textchatcomposite", (Throwable)new NullPointerException()));
        }
    }

    protected String getShellName() {
        return "org.eclipse.ecf.ui.views.TextChatComposite";
    }

    public void dispose() {
        super.dispose();
    }

    protected void setDisposed() {
        this.textinput.setEnabled(false);
    }

    protected void checkSubclass() {
    }
}

