/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.ecf.core.util.IAsyncResult;
import org.eclipse.ecf.core.util.ICallable;
import org.eclipse.ecf.core.util.TimeoutException;

public class AsyncResult
implements IAsyncResult {
    protected Object resultValue = null;
    protected boolean resultReady = false;
    protected InvocationTargetException resultException = null;

    public Runnable setter(final ICallable function) {
        return new Runnable(){

            public void run() {
                try {
                    AsyncResult.this.set(function.call());
                }
                catch (Throwable ex) {
                    AsyncResult.this.setException(ex);
                }
            }
        };
    }

    protected Object doGet() throws InvocationTargetException {
        if (this.resultException != null) {
            throw this.resultException;
        }
        return this.resultValue;
    }

    public synchronized Object get() throws InterruptedException, InvocationTargetException {
        while (!this.resultReady) {
            this.wait();
        }
        return this.doGet();
    }

    public synchronized Object get(long msecs) throws TimeoutException, InterruptedException, InvocationTargetException {
        long startTime = msecs <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = msecs;
        if (this.resultReady) {
            return this.doGet();
        }
        if (waitTime <= 0L) {
            throw new TimeoutException(msecs);
        }
        do {
            this.wait(waitTime);
            if (!this.resultReady) continue;
            return this.doGet();
        } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
        throw new TimeoutException(msecs);
    }

    public synchronized void set(Object newValue) {
        this.resultValue = newValue;
        this.resultReady = true;
        this.notifyAll();
    }

    public synchronized void setException(Throwable ex) {
        this.resultException = new InvocationTargetException(ex);
        this.resultReady = true;
        this.notifyAll();
    }

    public synchronized InvocationTargetException getException() {
        return this.resultException;
    }

    public synchronized boolean isReady() {
        return this.resultReady;
    }

    public synchronized Object peek() {
        return this.resultValue;
    }

    public synchronized void clear() {
        this.resultValue = null;
        this.resultException = null;
        this.resultReady = false;
    }
}

