/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.ui.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.IContainerConnectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.filetransfer.IFileTransferInfo;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransferRequestListener;
import org.eclipse.ecf.filetransfer.ISendFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IFileTransferRequestEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.internal.provider.xmpp.ui.Messages;
import org.eclipse.ecf.internal.provider.xmpp.ui.wizards.XMPPConnectWizard;
import org.eclipse.ecf.internal.provider.xmpp.ui.wizards.XMPPConnectWizardPage;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.im.IChatManager;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageEvent;
import org.eclipse.ecf.presence.im.IChatMessageSender;
import org.eclipse.ecf.presence.im.ITypingMessageEvent;
import org.eclipse.ecf.presence.im.ITypingMessageSender;
import org.eclipse.ecf.presence.ui.MessagesView;
import org.eclipse.ecf.presence.ui.MultiRosterView;
import org.eclipse.ecf.ui.IConnectWizard;
import org.eclipse.ecf.ui.actions.AsynchContainerConnectAction;
import org.eclipse.ecf.ui.dialogs.IDCreateErrorDialog;
import org.eclipse.ecf.ui.util.PasswordCacheHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class XMPPConnectWizard
extends Wizard
implements IConnectWizard,
INewWizard {
    XMPPConnectWizardPage page;
    private Shell shell;
    protected IContainer container;
    private ID targetID;
    private IConnectContext connectContext;
    protected String usernameAtHost;
    protected IIncomingFileTransferRequestListener requestListener = new IIncomingFileTransferRequestListener(){

        public void handleFileTransferRequest(IFileTransferRequestEvent event) {
            Display.getDefault().asyncExec(new Runnable(this, event){
                final /* synthetic */ 1 this$1;
                private final /* synthetic */ IFileTransferRequestEvent val$event;
                {
                    this.this$1 = var1_1;
                    this.val$event = iFileTransferRequestEvent;
                }

                public void run() {
                    String username = this.val$event.getRequesterID().getName();
                    IFileTransferInfo transferInfo = this.val$event.getFileTransferInfo();
                    String fileName = transferInfo.getFile().getName();
                    Object[] bindings = new Object[]{username, fileName, transferInfo.getFileSize() == -1L ? "unknown" : String.valueOf(transferInfo.getFileSize()) + " bytes", transferInfo.getDescription() == null ? "none" : transferInfo.getDescription()};
                    if (MessageDialog.openQuestion((Shell)XMPPConnectWizard.access$0(1.access$0(this.this$1)), (String)NLS.bind((String)Messages.XMPPConnectWizard_FILE_RECEIVE_TITLE, (Object)username), (String)NLS.bind((String)Messages.XMPPConnectWizard_FILE_RECEIVE_MESSAGE, (Object[])bindings))) {
                        FileDialog fd = new FileDialog(XMPPConnectWizard.access$0(1.access$0(this.this$1)), 4096);
                        fd.setFilterPath(System.getProperty("user.home"));
                        fd.setFileName(fileName);
                        int suffixLoc = fileName.lastIndexOf(46);
                        if (suffixLoc != -1) {
                            String ext = fileName.substring(fileName.lastIndexOf(46));
                            fd.setFilterExtensions(new String[]{ext});
                        }
                        fd.setText(NLS.bind((String)Messages.XMPPConnectWizard_FILE_SAVE_TITLE, (Object)username));
                        String res = fd.open();
                        if (res == null) {
                            this.val$event.reject();
                        } else {
                            try {
                                FileOutputStream fos = new FileOutputStream(new File(res));
                                this.val$event.accept((OutputStream)fos, new IFileTransferListener(this, fos){
                                    final /* synthetic */ 2 this$2;
                                    private final /* synthetic */ FileOutputStream val$fos;
                                    {
                                        this.this$2 = var1_1;
                                        this.val$fos = fileOutputStream;
                                    }

                                    public void handleTransferEvent(IFileTransferEvent event) {
                                        if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
                                            try {
                                                this.val$fos.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                MessageDialog.openError((Shell)XMPPConnectWizard.access$0(1.access$0(this.this$1)), (String)Messages.XMPPConnectWizard_RECEIVE_ERROR_TITLE, (String)NLS.bind((String)Messages.XMPPConnectWizard_RECEIVE_ERROR_MESSAGE, (Object[])new Object[]{fileName, username, e.getLocalizedMessage()}));
                            }
                        }
                    } else {
                        this.val$event.reject();
                    }
                }
            });
        }

        static /* synthetic */ XMPPConnectWizard access$0(1 var0) {
            return var0.XMPPConnectWizard.this;
        }
    };
    private IWorkbench workbench;
    private IChatMessageSender icms;
    private ITypingMessageSender itms;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public XMPPConnectWizard() {
    }

    public XMPPConnectWizard(String usernameAtHost) {
        this();
        this.usernameAtHost = usernameAtHost;
    }

    public void addPages() {
        this.page = new XMPPConnectWizardPage(this.usernameAtHost);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IContainer container) {
        this.shell = workbench.getActiveWorkbenchWindow().getShell();
        this.container = container;
        this.workbench = workbench;
        this.setWindowTitle(Messages.XMPPConnectWizard_WIZARD_TITLE);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.shell = workbench.getActiveWorkbenchWindow().getShell();
        this.workbench = workbench;
        this.container = null;
        try {
            this.container = ContainerFactory.getDefault().createContainer("ecf.xmpp.smack");
        }
        catch (ContainerCreateException containerCreateException) {}
        this.setWindowTitle(Messages.XMPPConnectWizard_WIZARD_TITLE);
    }

    private void openView() {
        try {
            MultiRosterView view = (MultiRosterView)this.workbench.getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ecf.presence.ui.MultiRosterView");
            view.addContainer(this.container);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private void displayMessage(IChatMessageEvent e) {
        final IChatMessage message = e.getChatMessage();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessagesView view = (MessagesView)XMPPConnectWizard.this.workbench.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ecf.presence.ui.MessagesView");
                if (view != null) {
                    IWorkbenchPartSite iWorkbenchPartSite = view.getSite();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
                    view.openTab(XMPPConnectWizard.this.icms, XMPPConnectWizard.this.itms, XMPPConnectWizard.this.targetID, message.getFromID());
                    view.showMessage(message);
                    service.warnOfContentChange();
                } else {
                    try {
                        IWorkbenchPage page = XMPPConnectWizard.this.workbench.getActiveWorkbenchWindow().getActivePage();
                        view = (MessagesView)page.showView("org.eclipse.ecf.presence.ui.MessagesView", null, 3);
                        if (!page.isPartVisible((IWorkbenchPart)view)) {
                            IWorkbenchPartSite iWorkbenchPartSite = view.getSite();
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
                            service.warnOfContentChange();
                        }
                        view.openTab(XMPPConnectWizard.this.icms, XMPPConnectWizard.this.itms, XMPPConnectWizard.this.targetID, message.getFromID());
                        view.showMessage(message);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void displayTypingNotification(final ITypingMessageEvent e) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessagesView view = (MessagesView)XMPPConnectWizard.this.workbench.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ecf.presence.ui.MessagesView");
                if (view != null) {
                    view.displayTypingNotification(e);
                }
            }
        });
    }

    public boolean performFinish() {
        final String connectID = this.page.getConnectID();
        final String password = this.page.getPassword();
        this.page.saveComboText();
        this.connectContext = ConnectContextFactory.createPasswordConnectContext((String)password);
        try {
            this.targetID = IDFactory.getDefault().createID(this.container.getConnectNamespace(), connectID);
        }
        catch (IDCreateException e) {
            new IDCreateErrorDialog(null, connectID, e).open();
            return false;
        }
        this.page.saveComboItems();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.presence.IPresenceContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IPresenceContainerAdapter adapter = (IPresenceContainerAdapter)this.container.getAdapter((Class)clazz);
        this.container.addListener(new IContainerListener(){

            public void handleEvent(IContainerEvent event) {
                if (event instanceof IContainerConnectedEvent) {
                    Display.getDefault().asyncExec(new Runnable(this){
                        final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            XMPPConnectWizard.access$5(6.access$0(this.this$1));
                        }
                    });
                }
            }

            static /* synthetic */ XMPPConnectWizard access$0(6 var0) {
                return var0.XMPPConnectWizard.this;
            }
        });
        IChatManager icm = adapter.getChatManager();
        this.icms = icm.getChatMessageSender();
        this.itms = icm.getTypingMessageSender();
        icm.addMessageListener(new IIMMessageListener(){

            public void handleMessageEvent(IIMMessageEvent e) {
                if (e instanceof IChatMessageEvent) {
                    XMPPConnectWizard.this.displayMessage((IChatMessageEvent)e);
                } else if (e instanceof ITypingMessageEvent) {
                    XMPPConnectWizard.this.displayTypingNotification((ITypingMessageEvent)e);
                }
            }
        });
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ecf.filetransfer.ISendFileTransferContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISendFileTransferContainerAdapter ioftca = (ISendFileTransferContainerAdapter)this.container.getAdapter((Class)clazz2);
        ioftca.addListener(this.requestListener);
        new AsynchContainerConnectAction(this.container, this.targetID, this.connectContext, null, new Runnable(){

            public void run() {
                XMPPConnectWizard.this.cachePassword(connectID, password);
            }
        }).run();
        return true;
    }

    protected void cachePassword(String connectID, String password) {
        if (password != null && !password.equals("")) {
            PasswordCacheHelper pwStorage = new PasswordCacheHelper(connectID);
            pwStorage.savePassword(password);
        }
    }

    static /* synthetic */ Shell access$0(XMPPConnectWizard xMPPConnectWizard) {
        return xMPPConnectWizard.shell;
    }

    static /* synthetic */ void access$5(XMPPConnectWizard xMPPConnectWizard) {
        xMPPConnectWizard.openView();
    }
}

