/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.osgi.services.distribution.IHostContainerFinder;
import org.eclipse.ecf.osgi.services.distribution.IHostDistributionListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.service.discovery.ServicePublication;

public class EventHookImpl
implements EventHook {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final DistributionProviderImpl distributionProvider;
    private final Map srvRefToRemoteSrvRegistration = new HashMap();
    private final Map srvRefToServicePublicationRegistration = new HashMap();
    private static final List excludedProperties = Arrays.asList("service.id", "objectClass", "osgi.remote.interfaces", "osgi.remote.requires.intents", "osgi.remote", "osgi.remote.configuration.type", "ecf.rsvc.cid");
    static /* synthetic */ Class class$0;

    public EventHookImpl(DistributionProviderImpl distributionProvider) {
        this.distributionProvider = distributionProvider;
    }

    private void findContainersAndRegisterRemoteService(ServiceReference serviceReference, String[] remoteInterfaces) {
        String[] remoteRequiresIntents;
        String[] remoteConfigurationType = this.getStringArrayFromPropertyValue(serviceReference.getProperty("osgi.remote.configuration.type"));
        IRemoteServiceContainer[] rsContainers = this.findRemoteServiceContainers(serviceReference, remoteInterfaces, remoteConfigurationType, remoteRequiresIntents = this.getStringArrayFromPropertyValue(serviceReference.getProperty("osgi.remote.requires.intents")));
        if (rsContainers == null || rsContainers.length == 0) {
            this.trace("registerRemoteService", "No remote service container adapters found for serviceReference=" + serviceReference);
            return;
        }
        int i = 0;
        while (i < rsContainers.length) {
            IRemoteServiceRegistration remoteRegistration = rsContainers[i].getContainerAdapter().registerRemoteService(remoteInterfaces, this.getService(serviceReference), this.getPropertiesForRemoteService(serviceReference));
            this.trace("registerRemoteService", "containerID=" + rsContainers[i].getContainer().getID() + " serviceReference=" + serviceReference + " remoteRegistration=" + remoteRegistration);
            this.fireRemoteServiceRegistered(serviceReference, remoteRegistration);
            this.publishRemoteService(rsContainers[i], serviceReference, remoteInterfaces, remoteRegistration);
            this.fireHostRegisteredUnregistered(serviceReference, rsContainers[i], remoteRegistration, true);
            ++i;
        }
    }

    private IRemoteServiceContainer[] findRemoteServiceContainers(ServiceReference serviceReference, String[] remoteInterfaces, String[] remoteConfigurationType, String[] remoteRequiresIntents) {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        IHostContainerFinder finder = activator.getHostRemoteServiceContainerFinder();
        if (finder == null) {
            this.logError("findRemoteServiceContainers", "No container finders available");
            return null;
        }
        return finder.findHostContainers(serviceReference, remoteInterfaces, remoteConfigurationType, remoteRequiresIntents);
    }

    private Dictionary getServicePublicationProperties(IRemoteServiceContainer rsContainer, ServiceReference ref, String[] remoteInterfaces, IRemoteServiceRegistration remoteRegistration) {
        Namespace rsnamespace;
        Properties properties = new Properties();
        ((Dictionary)properties).put("osgi.remote.interfaces", this.getAsCollection(remoteInterfaces));
        ((Dictionary)properties).put("osgi.remote.discovery.publication.service.properties", this.getServicePropertiesForRemotePublication(ref));
        IContainer container = rsContainer.getContainer();
        ID endpointID = container.getID();
        ((Dictionary)properties).put("ecf.sp.cid", endpointID);
        ID targetID = container.getConnectedID();
        if (targetID != null && !targetID.equals((Object)endpointID)) {
            ((Dictionary)properties).put("ecf.sp.tid", targetID);
        }
        if ((rsnamespace = rsContainer.getContainerAdapter().getRemoteServiceNamespace()) != null) {
            ((Dictionary)properties).put("ecf.rsvc.ns", rsnamespace.getName());
        }
        ((Dictionary)properties).put("ecf.rsvc.id", (Long)remoteRegistration.getProperty("ecf.rsvc.id"));
        return properties;
    }

    private void publishRemoteService(IRemoteServiceContainer rsContainer, final ServiceReference ref, String[] remoteInterfaces, IRemoteServiceRegistration remoteRegistration) {
        Dictionary properties = this.getServicePublicationProperties(rsContainer, ref, remoteInterfaces, remoteRegistration);
        Activator activator = Activator.getDefault();
        if (activator != null) {
            BundleContext context = activator.getContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.discovery.ServicePublication");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ServiceRegistration reg = context.registerService(clazz.getName(), (Object)new ServicePublication(){

                public ServiceReference getReference() {
                    return ref;
                }
            }, properties);
            this.fireRemoteServicePublished(ref, reg);
            this.trace("publishRemoteService", "containerID=" + rsContainer.getContainer().getID() + ",serviceReference=" + ref + " properties=" + properties + ",remoteRegistration=" + remoteRegistration);
        }
    }

    private Collection getAsCollection(String[] remoteInterfaces) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < remoteInterfaces.length) {
            result.add(remoteInterfaces[i]);
            ++i;
        }
        return result;
    }

    private Dictionary getPropertiesForRemoteService(ServiceReference sr) {
        String[] propKeys = sr.getPropertyKeys();
        Properties newProps = new Properties();
        int i = 0;
        while (i < propKeys.length) {
            if (!this.excludeRemoteServiceProperty(propKeys[i])) {
                newProps.put(propKeys[i], sr.getProperty(propKeys[i]));
            }
            ++i;
        }
        return newProps;
    }

    private Map getServicePropertiesForRemotePublication(ServiceReference sr) {
        String[] propKeys = sr.getPropertyKeys();
        Properties newProps = new Properties();
        int i = 0;
        while (i < propKeys.length) {
            if (!this.excludeRemoteServiceProperty(propKeys[i])) {
                newProps.put(propKeys[i], sr.getProperty(propKeys[i]));
            }
            ++i;
        }
        return newProps;
    }

    private boolean excludeRemoteServiceProperty(String string) {
        return excludedProperties.contains(string);
    }

    public void event(ServiceEvent event, Collection contexts) {
        switch (event.getType()) {
            case 2: {
                this.handleModifiedServiceEvent(event.getServiceReference(), contexts);
                break;
            }
            case 8: {
                break;
            }
            case 1: {
                this.handleRegisteredServiceEvent(event.getServiceReference(), contexts);
                break;
            }
            case 4: {
                this.handleUnregisteringServiceEvent(event.getServiceReference(), contexts);
                break;
            }
        }
    }

    private String[] getStringArrayFromPropertyValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Collection) {
            return ((Collection)value).toArray(new String[0]);
        }
        return null;
    }

    void handleRegisteredServiceEvent(ServiceReference serviceReference, Collection contexts) {
        Object osgiRemotes = serviceReference.getProperty("osgi.remote.interfaces");
        if (osgiRemotes != null) {
            String[] remoteInterfaces;
            String[] remoteInterfacesArr = this.getStringArrayFromPropertyValue(osgiRemotes);
            if (remoteInterfacesArr == null) {
                this.logError("handleRegisteredServiceEvent", "remoteInterfaces not of String [] type as required by RFC 119");
                return;
            }
            this.trace("handleRegisteredServiceEvent", "serviceReference=" + serviceReference + ",remoteInterfaces=" + Arrays.asList(remoteInterfacesArr));
            String[] stringArray = remoteInterfaces = remoteInterfacesArr != null ? this.getInterfacesForServiceReference(remoteInterfacesArr, serviceReference) : null;
            if (remoteInterfaces == null) {
                this.logError("handleRegisteredServiceEvent", "No exposed remoteInterfaces found for serviceReference=" + serviceReference);
                return;
            }
            this.findContainersAndRegisterRemoteService(serviceReference, remoteInterfaces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoteServiceRegistered(ServiceReference serviceReference, IRemoteServiceRegistration remoteServiceRegistration) {
        Map map = this.srvRefToRemoteSrvRegistration;
        synchronized (map) {
            ArrayList<IRemoteServiceRegistration> l = (ArrayList<IRemoteServiceRegistration>)this.srvRefToRemoteSrvRegistration.get(serviceReference);
            if (l == null) {
                l = new ArrayList<IRemoteServiceRegistration>();
                this.srvRefToRemoteSrvRegistration.put(serviceReference, l);
            }
            l.add(remoteServiceRegistration);
            this.distributionProvider.addExposedService(serviceReference);
        }
    }

    private void fireHostRegisteredUnregistered(final ServiceReference reference, final IRemoteServiceContainer container, final IRemoteServiceRegistration remoteRegistration, final boolean registered) {
        IHostDistributionListener[] listeners;
        Activator activator = Activator.getDefault();
        if (activator != null && (listeners = activator.getHostRegistrationListeners()) != null) {
            int i = 0;
            while (i < listeners.length) {
                final IHostDistributionListener l = listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        EventHookImpl.this.logError("fireHostRegisteredUnregistered", "Exception calling host distribution listener", exception);
                    }

                    public void run() throws Exception {
                        if (registered) {
                            l.registered(reference, container, remoteRegistration);
                        } else {
                            l.unregistered(reference, remoteRegistration);
                        }
                    }
                });
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoteServiceUnregistered(ServiceReference reference) {
        IRemoteServiceRegistration[] registrations = null;
        Map map = this.srvRefToRemoteSrvRegistration;
        synchronized (map) {
            this.distributionProvider.removeExposedService(reference);
            List l = (List)this.srvRefToRemoteSrvRegistration.remove(reference);
            if (l != null) {
                registrations = l.toArray(new IRemoteServiceRegistration[0]);
                l.clear();
            }
        }
        if (registrations != null) {
            int i = 0;
            while (i < registrations.length) {
                try {
                    registrations[i].unregister();
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (Exception e) {
                    this.logError("fireRemoteServiceUnregistered", "Exception unregistering remote registration=" + registrations[i], e);
                }
                this.fireHostRegisteredUnregistered(reference, null, registrations[i], false);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoteServicePublished(ServiceReference serviceReference, ServiceRegistration servicePublicationRegistration) {
        Map map = this.srvRefToServicePublicationRegistration;
        synchronized (map) {
            ArrayList<ServiceRegistration> l = (ArrayList<ServiceRegistration>)this.srvRefToServicePublicationRegistration.get(serviceReference);
            if (l == null) {
                l = new ArrayList<ServiceRegistration>();
                this.srvRefToServicePublicationRegistration.put(serviceReference, l);
            }
            l.add(servicePublicationRegistration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoteServiceUnpublished(ServiceReference reference) {
        ServiceRegistration[] registrations = null;
        Map map = this.srvRefToServicePublicationRegistration;
        synchronized (map) {
            List l = (List)this.srvRefToServicePublicationRegistration.remove(reference);
            if (l != null) {
                registrations = l.toArray(new ServiceRegistration[0]);
                l.clear();
            }
        }
        if (registrations != null) {
            int i = 0;
            while (i < registrations.length) {
                try {
                    registrations[i].unregister();
                }
                catch (Exception e) {
                    this.logError("fireRemoteServiceUnpublished", "Exception unregistering service publication registrations=" + registrations[i], e);
                }
                ++i;
            }
        }
    }

    private String[] getInterfacesForServiceReference(String[] remoteInterfaces, ServiceReference serviceReference) {
        if (remoteInterfaces == null || remoteInterfaces.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> results = new ArrayList<String>();
        List<String> interfaces = Arrays.asList((String[])serviceReference.getProperty("objectClass"));
        int i = 0;
        while (i < remoteInterfaces.length) {
            String intf = remoteInterfaces[i];
            if ("*".equals(intf)) {
                return interfaces.toArray(new String[0]);
            }
            if (intf != null && interfaces.contains(intf)) {
                results.add(intf);
            }
            ++i;
        }
        return results.toArray(new String[0]);
    }

    private void trace(String methodName, String message) {
        Trace.trace((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug/eventhook", this.getClass(), (String)methodName, (String)message);
    }

    private void traceException(String methodName, String message, Throwable t) {
        Trace.catching((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug/exceptions/catching", this.getClass(), (String)(String.valueOf(methodName == null ? "<unknown>" : methodName) + ":" + (message == null ? "<empty>" : message)), (Throwable)t);
    }

    private void logError(String methodName, String message, Throwable t) {
        this.traceException(methodName, message, t);
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.osgi.services.distribution", 4, String.valueOf(this.getClass().getName()) + ":" + (methodName == null ? "<unknown>" : methodName) + ":" + (message == null ? "<empty>" : message), t));
    }

    private void logError(String methodName, String message) {
        this.logError(methodName, message, null);
        this.traceException(methodName, message, null);
    }

    private void handleUnregisteringServiceEvent(ServiceReference serviceReference, Collection contexts) {
        this.fireRemoteServiceUnregistered(serviceReference);
        this.fireRemoteServiceUnpublished(serviceReference);
    }

    private void handleModifiedServiceEvent(ServiceReference serviceReference, Collection contexts) {
        this.trace("org.eclipse.ecf.internal.osgi.services.distribution.AbstractEventHookImpl.handleModifiedServiceEvent(ServiceReference, Collection)", "implement!");
    }

    private Object getService(ServiceReference sr) {
        return Activator.getDefault().getContext().getService(sr);
    }
}

