/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.r_osgi;

import ch.ethz.iks.r_osgi.RemoteOSGiException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.provider.r_osgi.RemoteServiceReferenceImpl;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallStartEvent;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ThreadsExecutor;

final class RemoteServiceImpl
implements IRemoteService {
    RemoteServiceReferenceImpl refImpl;
    private Object service;
    private long nextID;

    public RemoteServiceImpl(RemoteServiceReferenceImpl refImpl, Object service) {
        this.refImpl = refImpl;
        this.service = service;
    }

    public void callAsync(IRemoteCall call, IRemoteCallListener listener) {
        new AsyncResult(call, listener).start();
    }

    public IFuture callAsync(final IRemoteCall call) {
        ThreadsExecutor executor = new ThreadsExecutor();
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return RemoteServiceImpl.this.callSync(call);
            }
        }, null);
    }

    public Object callSync(IRemoteCall call) throws ECFException {
        Class[] formalParams = new Class[call.getParameters().length];
        int i = 0;
        while (i < formalParams.length) {
            formalParams[i] = call.getParameters()[i].getClass();
            ++i;
        }
        try {
            return this.service.getClass().getMethod(call.getMethod(), formalParams).invoke(this.service, call.getParameters());
        }
        catch (Throwable t) {
            throw new ECFException(t);
        }
    }

    public void fireAsync(IRemoteCall call) throws ECFException {
        try {
            this.callAsync(call);
        }
        catch (RemoteOSGiException r) {
            throw new ECFException((Throwable)r);
        }
        catch (Throwable throwable) {}
    }

    public Object getProxy() throws ECFException {
        if (!this.refImpl.getR_OSGiServiceReference().isActive()) {
            throw new ECFException("Container currently not connected");
        }
        return this.service;
    }

    synchronized long getNextID() {
        return this.nextID++;
    }

    private class AsyncResult
    extends Thread {
        Object result;
        Throwable exception;
        IRemoteCall call;
        private IRemoteCallListener listener;

        AsyncResult(IRemoteCall call, IRemoteCallListener listener) {
            this.call = call;
            this.listener = listener;
        }

        public synchronized Object get(long msecs) throws InterruptedException, InvocationTargetException {
            if (this.exception != null) {
                throw this.getException();
            }
            if (this.result != null) {
                return this.result;
            }
            this.wait(msecs);
            return this.result;
        }

        public synchronized InvocationTargetException getException() {
            return this.exception == null ? null : new InvocationTargetException(this.exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object r = null;
            Throwable e = null;
            long reqID = RemoteServiceImpl.this.getNextID();
            if (this.listener != null) {
                this.listener.handleEvent((IRemoteCallEvent)new IRemoteCallStartEvent(this, reqID){
                    final /* synthetic */ AsyncResult this$1;
                    private final /* synthetic */ long val$reqID;
                    {
                        this.this$1 = asyncResult;
                        this.val$reqID = l;
                    }

                    public IRemoteCall getCall() {
                        return this.this$1.call;
                    }

                    public IRemoteServiceReference getReference() {
                        return AsyncResult.access$0((AsyncResult)this.this$1).refImpl;
                    }

                    public long getRequestId() {
                        return this.val$reqID;
                    }
                });
            }
            try {
                r = RemoteServiceImpl.this.callSync(this.call);
            }
            catch (Throwable t) {
                e = t;
            }
            AsyncResult asyncResult = this;
            synchronized (asyncResult) {
                this.result = r;
                this.exception = e;
                this.notify();
            }
            if (this.listener != null) {
                this.listener.handleEvent((IRemoteCallEvent)new IRemoteCallCompleteEvent(this, reqID){
                    final /* synthetic */ AsyncResult this$1;
                    private final /* synthetic */ long val$reqID;
                    {
                        this.this$1 = asyncResult;
                        this.val$reqID = l;
                    }

                    public Throwable getException() {
                        return this.this$1.exception;
                    }

                    public Object getResponse() {
                        return this.this$1.result;
                    }

                    public boolean hadException() {
                        return this.this$1.exception != null;
                    }

                    public long getRequestId() {
                        return this.val$reqID;
                    }
                });
            }
        }

        static /* synthetic */ RemoteServiceImpl access$0(AsyncResult asyncResult) {
            return asyncResult.RemoteServiceImpl.this;
        }
    }
}

