/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.search;

import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.user.User;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.provider.xmpp.Messages;
import org.eclipse.ecf.internal.provider.xmpp.XmppPlugin;
import org.eclipse.ecf.internal.provider.xmpp.search.XMPPCriteria;
import org.eclipse.ecf.internal.provider.xmpp.search.XMPPResultItem;
import org.eclipse.ecf.internal.provider.xmpp.search.XMPPSearch;
import org.eclipse.ecf.internal.provider.xmpp.search.XMPPSelection;
import org.eclipse.ecf.internal.provider.xmpp.smack.ECFConnection;
import org.eclipse.ecf.presence.search.AbstractUserSearchManager;
import org.eclipse.ecf.presence.search.ICriteria;
import org.eclipse.ecf.presence.search.ICriterion;
import org.eclipse.ecf.presence.search.IRestriction;
import org.eclipse.ecf.presence.search.IResult;
import org.eclipse.ecf.presence.search.IResultList;
import org.eclipse.ecf.presence.search.ISearch;
import org.eclipse.ecf.presence.search.IUserSearchEvent;
import org.eclipse.ecf.presence.search.IUserSearchListener;
import org.eclipse.ecf.presence.search.ResultList;
import org.eclipse.ecf.presence.search.UserSearchCompleteEvent;
import org.eclipse.ecf.presence.search.UserSearchException;
import org.eclipse.ecf.provider.xmpp.identity.XMPPID;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.search.UserSearch;

public class XMPPUserSearchManager
extends AbstractUserSearchManager {
    protected static final String SERVICE_SEARCH = "search.";
    protected ECFConnection ecfConnection;
    protected Namespace connectNamespace;
    protected ID connectedID;
    protected Form form;
    protected UserSearch manager = new UserSearch();
    protected boolean enabled;
    protected ICriteria criteria;
    protected static final String FORM_TYPE = "FORM_TYPE";
    protected static final String NAME = "name";
    protected static final String JID = "jid";
    protected static final String SEARCH_ACTION = "search";

    public ICriteria createCriteria() {
        return new XMPPCriteria();
    }

    public IRestriction createRestriction() {
        return new XMPPSelection();
    }

    public ISearch search(ICriteria criteria) throws UserSearchException {
        ResultList resultList = new ResultList();
        try {
            if (this.form == null) {
                this.form = this.manager.getSearchForm(this.ecfConnection.getXMPPConnection(), SERVICE_SEARCH + this.ecfConnection.getXMPPConnection().getServiceName());
            }
            List criterions = criteria.getCriterions();
            String[] fields = this.getUserPropertiesFields();
            int i = 0;
            while (i < fields.length) {
                Iterator criterionsIterator = criterions.iterator();
                while (criterionsIterator.hasNext()) {
                    ICriterion criterion = (ICriterion)criterionsIterator.next();
                    if (!criterion.equals(fields[i])) continue;
                    Form answerForm = this.form.createAnswerForm();
                    answerForm.setAnswer(fields[i], true);
                    answerForm.setAnswer(SEARCH_ACTION, criterion.toExpression());
                    ReportedData data = this.manager.sendSearchForm(this.ecfConnection.getXMPPConnection(), answerForm, SERVICE_SEARCH + this.ecfConnection.getXMPPConnection().getServiceName());
                    IResultList partialResultList = this.createResultList(data);
                    resultList.addAll(partialResultList.getResults());
                }
                ++i;
            }
            return new XMPPSearch(resultList);
        }
        catch (XMPPException e) {
            String message = null;
            message = e.getXMPPError() != null && e.getXMPPError().getCode() == 404 ? Messages.XMPPContainer_UNRECOGONIZED_SEARCH_SERVICE : e.getLocalizedMessage();
            throw new UserSearchException(message, (Throwable)e, criteria);
        }
        catch (ECFException e) {
            throw new UserSearchException((Throwable)e, criteria);
        }
    }

    protected IResultList createResultList(ReportedData data) {
        ResultList result = new ResultList();
        Iterator rows = data.getRows();
        while (rows.hasNext()) {
            ReportedData.Row row = (ReportedData.Row)rows.next();
            Iterator jids = row.getValues(JID);
            Iterator names = row.getValues(NAME);
            String jid = null;
            String name = null;
            while (jids.hasNext() && names.hasNext()) {
                try {
                    jid = (String)jids.next();
                    name = (String)names.next();
                    User user = new User((ID)new XMPPID(this.connectNamespace, jid), name);
                    result.add((IResult)new XMPPResultItem((IUser)user));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("cannot create connect id for client " + jid + " , name = " + name, e);
                }
            }
        }
        return result;
    }

    public void search(final ICriteria criteria, final IUserSearchListener listener) {
        Assert.isNotNull((Object)criteria);
        Assert.isNotNull((Object)listener);
        Job job = new Job(Messages.XMPPUserSearchManager_JOB){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ISearch search = XMPPUserSearchManager.this.search(criteria);
                    UserSearchCompleteEvent complete = new UserSearchCompleteEvent(search);
                    listener.handleUserSearchEvent((IUserSearchEvent)complete);
                }
                catch (UserSearchException e) {
                    XMPPUserSearchManager.this.log(e.getLocalizedMessage(), e);
                    return new Status(4, "org.eclipse.ecf.provider.xmpp", 4, "Exception in user search", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void setConnection(Namespace connectNamespace, ID connectedID, ECFConnection connection) {
        Assert.isNotNull((Object)connectNamespace);
        Assert.isNotNull((Object)connectedID);
        Assert.isNotNull((Object)connection);
        this.connectNamespace = connectNamespace;
        this.connectedID = connectedID;
        this.ecfConnection = connection;
    }

    public String[] getUserPropertiesFields() throws ECFException {
        try {
            if (this.form == null) {
                this.form = this.manager.getSearchForm(this.ecfConnection.getXMPPConnection(), SERVICE_SEARCH + this.ecfConnection.getXMPPConnection().getServiceName());
            }
            HashSet<String> fields = new HashSet<String>();
            Iterator userProperties = this.form.getFields();
            while (userProperties.hasNext()) {
                FormField field = (FormField)userProperties.next();
                String variable = field.getVariable();
                if (variable.equalsIgnoreCase(FORM_TYPE) || variable.equalsIgnoreCase(SEARCH_ACTION)) continue;
                fields.add(variable);
            }
            return fields.toArray(new String[0]);
        }
        catch (XMPPException e) {
            String message = null;
            message = e.getXMPPError() != null && e.getXMPPError().getCode() == 404 ? Messages.XMPPContainer_UNRECOGONIZED_SEARCH_SERVICE : e.getLocalizedMessage();
            throw new ECFException(message, (Throwable)e);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected void log(String msg, Throwable e) {
        XmppPlugin.log(msg, e);
    }

    public void fireUserSearchEvent(IUserSearchEvent event) {
        super.fireUserSearchEvent(event);
    }
}

