/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ecf.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.team.internal.ecf.core.RemoteShare;
import org.osgi.framework.BundleContext;

public class TeamSynchronization
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ecf.sync.team";
    private static TeamSynchronization plugin;
    private static Map channels;

    static {
        channels = new HashMap();
    }

    public static void addShare(ID containerId, IChannelContainerAdapter channelContainer) throws ECFException {
        if (!channels.containsKey(containerId)) {
            channels.put(containerId, new RemoteShare(channelContainer));
        }
    }

    public static RemoteShare getShare(ID containerId) {
        return (RemoteShare)((Object)channels.get(containerId));
    }

    public static void removeShare(ID containerId) {
        channels.remove(containerId);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static TeamSynchronization getDefault() {
        return plugin;
    }

    public static byte[] readFile(IFile file) {
        try {
            if (file.exists()) {
                InputStream contents = file.getContents();
                byte[] bytes = new byte[contents.available()];
                contents.read(bytes);
                return bytes;
            }
        }
        catch (IOException e) {
            TeamSynchronization.log("Could not read file content: " + file.getFullPath(), e);
        }
        catch (CoreException e) {
            TeamSynchronization.log("Could not retrieve file content: " + file.getFullPath(), e);
        }
        return null;
    }

    public static void log(String message) {
        TeamSynchronization.log(message, null);
    }

    public static void log(String message, Throwable throwable) {
        TeamSynchronization.log((IStatus)new Status(4, PLUGIN_ID, message, throwable));
    }

    public static void log(IStatus status) {
        TeamSynchronization.getDefault().getLog().log(status);
    }
}

