/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.irc.datashare;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannelListener;
import org.eclipse.ecf.internal.provider.irc.Activator;
import org.eclipse.ecf.internal.provider.irc.identity.IRCID;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageSender;
import org.eclipse.ecf.presence.im.IChatID;
import org.eclipse.ecf.provider.datashare.nio.NIOChannel;
import org.eclipse.ecf.provider.datashare.nio.NIODatashareContainer;

class IRCDatashareChannel
extends NIOChannel {
    private static final String BIND_IP_PROPERTY = "org.eclipse.ecf.provider.irc.bindIP";
    private static final String BIND_PORT_PROPERTY = "org.eclipse.ecf.provider.irc.bindPort";
    private static final String LOCAL_IP_PROPERTY = "org.eclipse.ecf.provider.irc.localIP";
    private Namespace receiverNamespace;
    private IRCID userId;
    private IChatRoomMessageSender sender;
    private String ip;

    IRCDatashareChannel(NIODatashareContainer datashareContainer, Namespace receiverNamespace, ID userId, IChatRoomMessageSender sender, ID id, IChannelListener listener) throws ECFException {
        super(datashareContainer, userId, id, listener);
        this.receiverNamespace = receiverNamespace;
        this.userId = (IRCID)userId;
        this.sender = sender;
    }

    protected void log(IStatus status) {
        Activator.getDefault().log(status);
    }

    protected SocketAddress getBindAddress() {
        String bindIP = System.getProperty(BIND_IP_PROPERTY);
        String bindPort = System.getProperty(BIND_PORT_PROPERTY);
        if (bindIP == null) {
            if (bindPort == null) {
                return super.getBindAddress();
            }
            try {
                return new InetSocketAddress(Integer.parseInt(bindPort));
            }
            catch (NumberFormatException numberFormatException) {
                Activator.log("Invalid bind property value (org.eclipse.ecf.provider.irc.bindPort) specified: " + bindPort);
                return super.getBindAddress();
            }
        }
        if (bindPort == null) {
            return new InetSocketAddress(bindIP, 0);
        }
        try {
            return new InetSocketAddress(bindIP, Integer.parseInt(bindPort));
        }
        catch (NumberFormatException numberFormatException) {
            Activator.log("Invalid bind property value (org.eclipse.ecf.provider.irc.bindPort) specified: " + bindPort);
            return new InetSocketAddress(bindIP, 0);
        }
    }

    void setIP(String ip) {
        String propertyIP = System.getProperty(LOCAL_IP_PROPERTY);
        this.ip = propertyIP == null ? ip : propertyIP;
    }

    protected void sendRequest(ID receiver) throws ECFException {
        String name = ((IChatID)receiver).getUsername();
        StringBuffer buffer = new StringBuffer();
        buffer.append("/msg ").append(name);
        buffer.append(" \u0001ECF ");
        buffer.append(this.ip).append(':').append(this.getLocalPort());
        buffer.append('\u0001');
        this.sender.sendMessage(buffer.toString());
    }

    public void sendMessage(ID receiver, byte[] message) throws ECFException {
        Assert.isNotNull((Object)receiver, (String)"A receiver must be specified");
        String name = receiver instanceof IChatID ? ((IChatID)receiver).getUsername() : receiver.getName();
        StringBuffer buffer = new StringBuffer(name);
        buffer.append('@').append(this.userId.getHost());
        buffer.append(':').append(this.userId.getPort());
        ID modifiedId = this.receiverNamespace.createInstance(new Object[]{buffer.toString()});
        super.sendMessage(modifiedId, message);
    }
}

